// VaxSIPUserAgent.cpp: implementation of the CVaxSIPUserAgentLibEx class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Define.h"
#include "VaxSIPUserAgentLibEx.h"
#include "VaxVoIP.h"
#include "VaxVoIPDlg.h"
#include "Mmsystem.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVaxSIPUserAgentLibEx::CVaxSIPUserAgentLibEx(CVaxVoIPDlg* pMianDlg) : CVaxSIPUserAgentLib()
{
	m_pMainDlg = pMianDlg;
			
	m_bEnableREC = FALSE;
	m_bBoostMic = FALSE;
	m_bDetectAMD = FALSE;

	m_nActiveAudioInDeviceId  = -1;
	m_nActiveAudioOutDeviceId = -1;

	m_nTypeDTMF = VAX_DTMF_TYPE_AUTO;

	m_bCaptureSoundDevice = TRUE;
	m_bActivateVideoDevice = TRUE;

	m_nVideoDeviceId = 0;
	m_nVideoQuality = VAX_VIDEO_QUALITY_MEDIUM;
}

CVaxSIPUserAgentLibEx::~CVaxSIPUserAgentLibEx()
{
	
}

//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

int CVaxSIPUserAgentLibEx::GetTotalLine()
{
   return VAX_TOTAL_NO_LINES;
}

//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::Initialize(LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sAuthLogin, LPCTSTR sAuthPwd, LPCTSTR sDomainRealm, LPCTSTR sServerAddr, int nServerPort, int nServerType, BOOL bRegisterSIP, BOOL bCaptureSoundDevice)
{
	 /****************************************/

    CVaxSIPUserAgentLib::SetLicenceKey("TRIAL-LICENSE-KEY");

    /****************************************/
	
	m_objDontShowErrorMsg.RemoveAll();

	if(!CVaxSIPUserAgentLib::Initialize())
		return FALSE;

	if (!CVaxSIPUserAgentLib::AddAccountSIP(VAX_ACCOUNT_NAME_PHONE, nServerType, "", -1, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort))
	{
		CVaxSIPUserAgentLib::UnInitialize();
		return FALSE;
	}

	//CVaxSIPUserAgentLib::DiagnosticLogSIP("", TRUE, TRUE);

	OnVaxOnline();

	CVaxSIPUserAgentLib::NetworkReachability(TRUE);
                
	if (bRegisterSIP)
    {
		CVaxSIPUserAgentLib::RegisterAccountSIP(VAX_ACCOUNT_NAME_PHONE, 1800);
		CVaxSIPUserAgentLib::AutoRegistration(VAX_ACCOUNT_NAME_PHONE, true, -1, 4);
	}

	m_bCaptureSoundDevice = bCaptureSoundDevice;
    CVaxSIPUserAgentLib::EnableKeepAlive(VAX_ACCOUNT_NAME_PHONE, 10);

	return TRUE;
}

void CVaxSIPUserAgentLibEx::UnInitialize()
{
	CVaxSIPUserAgentLib::UnInitialize();
	OnVaxOffline();
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::RegisterAccountREC(BOOL bRegister, LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sAuthLogin, LPCTSTR sAuthPwd, LPCTSTR sDomainRealm, LPCTSTR sServerAddr, int nServerPort)
{
	m_bEnableREC = FALSE;

	CVaxSIPUserAgentLib::RemoveAccountSIP(VAX_ACCOUNT_NAME_REC);

	if(!CVaxSIPUserAgentLib::AddAccountSIP(VAX_ACCOUNT_NAME_REC, VAX_ACCOUNT_TYPE_UDP, "", -1, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort))
		return FALSE;
	
	if(bRegister)
	{
		if(!CVaxSIPUserAgentLib::RegisterAccountSIP(VAX_ACCOUNT_NAME_REC, 1800))
			return FALSE;
	}
	else
	{
		m_bEnableREC = TRUE;
	}
	
	return TRUE;
}

BOOL CVaxSIPUserAgentLibEx::UnRegisterAccountREC()
{
	m_bEnableREC = FALSE;

	CVaxSIPUserAgentLib::RemoveAccountSIP(VAX_ACCOUNT_NAME_REC);
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::DialCallToREC(int nLineNo)
{
	if(!m_bEnableREC)
		return FALSE;
		
	if(!CVaxSIPUserAgentLib::DialCallToREC(VAX_ACCOUNT_NAME_REC, nLineNo, "0000"))
	{
		m_objDontShowErrorMsg.AddTail("DialCallToREC");
		OnStatusMsgREC(nLineNo);
		return FALSE;
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::AcceptCall(int nLineNo, LPCTSTR sCallId)
{
	int nInputDeviceId = m_nActiveAudioInDeviceId;
	int nOutputDeviceId = m_nActiveAudioOutDeviceId;

	if (m_bCaptureSoundDevice == FALSE)
    {
		nInputDeviceId = VAX_CAPTURE_SOUND_DEVICE_NONE;
        nOutputDeviceId = VAX_CAPTURE_SOUND_DEVICE_NONE;
	}
	
	if(!CVaxSIPUserAgentLib::AcceptCall(nLineNo, sCallId, nInputDeviceId, nOutputDeviceId))
		return FALSE;
	
	DialCallToREC(nLineNo);
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::DigitDTMF(int nLineNo, LPCTSTR sDigit)
{
	return CVaxSIPUserAgentLib::DigitDTMF(nLineNo, sDigit, m_nTypeDTMF);
}

void CVaxSIPUserAgentLibEx::ForceDigitDTMF(int nTypeDTMF)
{
	m_nTypeDTMF = nTypeDTMF;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::IsVolumeBoostMic()
{
	return m_bBoostMic;
}

BOOL CVaxSIPUserAgentLibEx::SetVolumeBoostMic(BOOL bEnable)
{
	int nBoostVol = 0;

	if(bEnable)
		nBoostVol = 20;

	BOOL bResult = CVaxSIPUserAgentLib::SetVolumeMic(nBoostVol);
	
	if(!bResult)
	{
        m_bBoostMic = FALSE;
	}
	
	m_bBoostMic = bEnable;
	return bResult;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::SetActiveAudioInDevice(int nAudioInDevice)
{
	m_nActiveAudioInDeviceId = nAudioInDevice;
}

void CVaxSIPUserAgentLibEx::SetActiveAudioOutDevice(int nAudioOutDevice)
{
	m_nActiveAudioOutDeviceId = nAudioOutDevice;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::DialCall(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo)
{
    int nInputDeviceId = m_nActiveAudioInDeviceId;
	int nOutputDeviceId = m_nActiveAudioOutDeviceId;

	if (m_bCaptureSoundDevice == FALSE)
    {
		nInputDeviceId = VAX_CAPTURE_SOUND_DEVICE_NONE;
        nOutputDeviceId = VAX_CAPTURE_SOUND_DEVICE_NONE;
	}
	
	if(!CVaxSIPUserAgentLib::DialCall(VAX_ACCOUNT_NAME_PHONE, nLineNo, sCallerName, sCallerId, sDialNo, nInputDeviceId, nOutputDeviceId))
	{
		return FALSE;
	}

	DialCallToREC(nLineNo);
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::SetActiveVideoDevice(int nDeviceId)
{
	m_nVideoDeviceId = nDeviceId;
	CaptureVideoDevice();
}

void CVaxSIPUserAgentLibEx::SetVideoQuality(int nQuality)
{
	m_nVideoQuality = nQuality;
	CaptureVideoDevice();
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::DetectAMD(BOOL bEnable)
{
	m_bDetectAMD = bEnable;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::ActivateVideoDevice(BOOL bActivate)
{
	m_bActivateVideoDevice = bActivate;
	CaptureVideoDevice();
}

void CVaxSIPUserAgentLibEx::CaptureVideoDevice()
{
	if(GetVideoDevTotal() == 0)
		return;
	
	CVaxSIPUserAgentLib::CloseVideoDev();

	if(!m_bActivateVideoDevice)
		return;

	if(!CVaxSIPUserAgentLib::OpenVideoDev(m_nVideoDeviceId, m_nVideoQuality))
	{
		return;
	}

	CVaxSIPUserAgentLib::VideoCodecBitRate(VAX_VIDEO_CODEC_VP8, m_nVideoQuality);
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

int CVaxSIPUserAgentLibEx::GetOutboundCodec(int nLineNo)
{
	int nResult = CVaxSIPUserAgentLib::GetOutboundCodec(nLineNo);
	
	if(nResult == -1)
		m_objDontShowErrorMsg.AddTail("GetOutboundCodec");
	
	return nResult;
}

int CVaxSIPUserAgentLibEx::GetInboundCodec(int nLineNo)
{
	int nResult = CVaxSIPUserAgentLib::GetInboundCodec(nLineNo);
	
	if(nResult == -1)
		m_objDontShowErrorMsg.AddTail("GetInboundCodec");
	
	return nResult;
}

CString CVaxSIPUserAgentLibEx::GetVoiceCodecName(int nCodecNo)
{
    if(nCodecNo == VAX_AUDIO_CODEC_G711U)
        return "gsm711u";
	
	if(nCodecNo == VAX_AUDIO_CODEC_G711A)
        return "gsm711a";

    if(nCodecNo == VAX_AUDIO_CODEC_GSM610)
        return "gsm6.10";

	if(nCodecNo == VAX_AUDIO_CODEC_ILBC)
		return "iLBC";

    if(nCodecNo == VAX_AUDIO_CODEC_G729)
        return "g729";

    return "";
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::DialRingEnable()
{
	BOOL bResult = CVaxSIPUserAgentLib::DialRingEnable(VAX_DIAL_RING_WAVE_FILE);
	
	if(!bResult)
	{
		m_objDontShowErrorMsg.AddTail("DialRingEnable");
		m_pMainDlg->MessageBox("Unable to access dial ring wave file", "VaxVoIP Phone SDK", MB_ICONEXCLAMATION);
	}
}

void CVaxSIPUserAgentLibEx::BusyRingEnable()
{
	BOOL bResult = CVaxSIPUserAgentLib::BusyRingEnable(VAX_BUSY_RING_WAVE_FILE);
	
	if(!bResult)
	{
		m_objDontShowErrorMsg.AddTail("BusyRingEnable");
		m_pMainDlg->MessageBox("Unable to access busy ring wave file", "VaxVoIP Phone SDK", MB_ICONEXCLAMATION);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::ChatAddContact(LPCTSTR sUserName)
{
	return CVaxSIPUserAgentLib::ChatAddContact(VAX_ACCOUNT_NAME_PHONE, sUserName, TRUE);
}

BOOL CVaxSIPUserAgentLibEx::ChatRemoveContact(LPCTSTR sUserName)
{
	return CVaxSIPUserAgentLib::ChatRemoveContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
}

BOOL CVaxSIPUserAgentLibEx::ChatSetMyStatus(int nStatusId)
{
	return CVaxSIPUserAgentLib::ChatSetMyStatus(VAX_ACCOUNT_NAME_PHONE, nStatusId);
}

BOOL CVaxSIPUserAgentLibEx::ChatSendMessageText(LPCTSTR sUserName, LPCTSTR sMsgText)
{
	return CVaxSIPUserAgentLib::ChatSendMessageText(VAX_ACCOUNT_NAME_PHONE, sUserName, sMsgText, FALSE, 0);
}

BOOL CVaxSIPUserAgentLibEx::ChatSendMessageTyping(LPCTSTR sUserName)
{
	return CVaxSIPUserAgentLib::ChatSendMessageTyping(VAX_ACCOUNT_NAME_PHONE, sUserName, 0);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::BusyLampAddContact(LPCTSTR sUserName)
{
	return CVaxSIPUserAgentLib::BusyLampAddContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
}

BOOL CVaxSIPUserAgentLibEx::BusyLampRemoveContact(LPCTSTR sUserName)
{
	return CVaxSIPUserAgentLib::BusyLampRemoveContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

BOOL CVaxSIPUserAgentLibEx::RegisterAccountSIP(int nExpire)
{
	return CVaxSIPUserAgentLib::RegisterAccountSIP(VAX_ACCOUNT_NAME_PHONE, nExpire);
}

BOOL CVaxSIPUserAgentLibEx::AutoRegistration(BOOL bEnable, int nTickCountLimit, int nTickSeconds)
{
	return CVaxSIPUserAgentLib::AutoRegistration(VAX_ACCOUNT_NAME_PHONE, bEnable, nTickCountLimit, nTickSeconds);
}

BOOL CVaxSIPUserAgentLibEx::EnableKeepAlive(int nSeconds)
{
	return CVaxSIPUserAgentLib::EnableKeepAlive(VAX_ACCOUNT_NAME_PHONE, nSeconds);
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnVaxOnline()
{
	m_pMainDlg->OnVaxOnline();
}

void CVaxSIPUserAgentLibEx::OnVaxOffline()
{
	m_pMainDlg->OnVaxOffline();
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
	
void CVaxSIPUserAgentLibEx::OnDigitDTMF(LPCTSTR sAccountName, int nLineNo, LPCTSTR sDigit)
{
	m_pMainDlg->OnDigitDTMF(nLineNo, sDigit);
}

void CVaxSIPUserAgentLibEx::OnPlayWaveDone(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnPlayWaveDone(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnAudioSessionLost(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnAudioSessionLost(nLineNo);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnConnectingToRegister(LPCTSTR sAccountName)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnConnectingToRegister();
		return;
    }

	m_pMainDlg->OnConnectingToRegister();
}

void CVaxSIPUserAgentLibEx::OnTryingToRegister(LPCTSTR sAccountName)	
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnTryingToRegisterREC();
		return;
    }

	m_pMainDlg->OnTryingToRegister();
}

void CVaxSIPUserAgentLibEx::OnFailToRegister(LPCTSTR sAccountName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_bEnableREC = FALSE;

		m_pMainDlg->OnFailToRegisterREC(nStatusCode, sReasonPhrase);
        return;
    }

	m_pMainDlg->OnFailToRegister(nStatusCode, sReasonPhrase);
}

void CVaxSIPUserAgentLibEx::OnSuccessToRegister(LPCTSTR sAccountName)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_bEnableREC = TRUE;
		m_pMainDlg->OnSuccessToRegisterREC();
        return;
    }

	m_pMainDlg->OnSuccessToRegister();
}

void CVaxSIPUserAgentLibEx::OnConnectingToReRegister(LPCTSTR sAccountName)
{
	m_pMainDlg->OnConnectingToReRegister();
}

void CVaxSIPUserAgentLibEx::OnTryingToReRegister(LPCTSTR sAccountName)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnTryingToReRegisterREC();
        return;
    }

	m_pMainDlg->OnTryingToReRegister();
}

void CVaxSIPUserAgentLibEx::OnFailToReRegister(LPCTSTR sAccountName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_bEnableREC = FALSE;

		m_pMainDlg->OnFailToReRegisterREC(nStatusCode, sReasonPhrase);
        return;
    }

	m_pMainDlg->OnFailToReRegister(nStatusCode, sReasonPhrase);
}

void CVaxSIPUserAgentLibEx::OnSuccessToReRegister(LPCTSTR sAccountName)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_bEnableREC = TRUE;

		m_pMainDlg->OnSuccessToReRegisterREC();
        return;
    }

	m_pMainDlg->OnSuccessToReRegister();
}

void CVaxSIPUserAgentLibEx::OnTryingToUnRegister(LPCTSTR sAccountName)	
{
	m_pMainDlg->OnTryingToRegister();
}

void CVaxSIPUserAgentLibEx::OnFailToUnRegister(LPCTSTR sAccountName)
{
	m_pMainDlg->OnFailToUnRegister();
}

void CVaxSIPUserAgentLibEx::OnSuccessToUnRegister(LPCTSTR sAccountName)
{
	m_pMainDlg->OnSuccessToUnRegister();
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnSuccessToHold(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnSuccessToHold(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnTryingToHold(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnTryingToHold(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnFailToHold(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnFailToHold(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnSuccessToUnHold(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnSuccessToUnHold(nLineNo);
}
void CVaxSIPUserAgentLibEx::OnTryingToUnHold(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnTryingToUnHold(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnFailToUnHold(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnFailToUnHold(nLineNo);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnDialCallStarted(LPCTSTR sAccountName, int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnDialCallStartedREC(nLineNo, sCallerName, sCallerId, sDialNo);
		return;
	}
	
	m_pMainDlg->OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
}

void CVaxSIPUserAgentLibEx::OnDialingCall(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnDialingCallREC(nLineNo, nStatusCode, sReasonPhrase);
		return;
	}
	
	m_pMainDlg->OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
}

void CVaxSIPUserAgentLibEx::OnDialCallFailed(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sContact)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnDialCallFailedREC(nLineNo, nStatusCode, sReasonPhrase);
		return;
	}

	m_pMainDlg->OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase);
}

void CVaxSIPUserAgentLibEx::OnConnectedCall(LPCTSTR sAccountName, int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort)
{
	if (CString(sAccountName).CompareNoCase(VAX_ACCOUNT_NAME_REC) == 0)
	{
		m_pMainDlg->OnConnectedCallREC(nLineNo, sToRTPIP, nToRTPPort);
		return;
	}
	
	CVaxSIPUserAgentLib::DetectAMD(nLineNo, m_bDetectAMD, 6000, 300, 2);
	m_pMainDlg->OnConnectedCall(nLineNo, sToRTPIP, nToRTPPort);
}

void CVaxSIPUserAgentLibEx::OnHungupCall(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnHungupCall(nLineNo);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnIncomingCallStarted(LPCTSTR sAccountName, LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, LPCTSTR sFromURI, LPCTSTR sToURI)
{
	m_pMainDlg->OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
}

void CVaxSIPUserAgentLibEx::OnIncomingCallEnded(LPCTSTR sAccountName, LPCTSTR sCallId, int nReasonCode)
{
	m_pMainDlg->OnIncomingCallEnded(sCallId);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnRingToneStarted(LPCTSTR sAccountName, LPCTSTR sCallId)
{
	m_pMainDlg->OnRingToneStarted(sCallId);
}

void CVaxSIPUserAgentLibEx::OnRingToneEnded(LPCTSTR sAccountName, LPCTSTR sCallId)
{
	m_pMainDlg->OnRingToneEnded(sCallId);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnTransferCallAccepted(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnTransferCallAccepted(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnTransferCallFailed(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pMainDlg->OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnChatSubscribeSuccess(LPCTSTR sAccountName, LPCTSTR sUserName)
{
	m_pMainDlg->OnChatSubscribeSuccess(sUserName);
}
        
void CVaxSIPUserAgentLibEx::OnChatSubscribeFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pMainDlg->OnChatSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
}

void CVaxSIPUserAgentLibEx::OnChatContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusId)
{
	m_pMainDlg->OnChatContactStatus(sUserName, nStatusId);
}
	
void CVaxSIPUserAgentLibEx::OnChatSendMsgTextSuccess(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue)
{
	m_pMainDlg->OnChatSendMsgTextSuccess(sUserName, sMsgText, nUserValue);
}

void CVaxSIPUserAgentLibEx::OnChatSendMsgTextFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue)
{
	m_pMainDlg->OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue);
}
	
void CVaxSIPUserAgentLibEx::OnChatSendMsgTypingSuccess(LPCTSTR sAccountName, LPCTSTR sUserName, UINT64 nUserValue)
{
	m_pMainDlg->OnChatSendMsgTypingSuccess(sUserName, nUserValue);
}

void CVaxSIPUserAgentLibEx::OnChatSendMsgTypingFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue)
{
	m_pMainDlg->OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase, nUserValue);
}

void CVaxSIPUserAgentLibEx::OnChatRecvMsgText(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, BOOL bIsChatContact)
{
	m_pMainDlg->OnChatRecvMsgText(sUserName, sMsgText);
}

void CVaxSIPUserAgentLibEx::OnChatRecvMsgTypingStart(LPCTSTR sAccountName, LPCTSTR sUserName)
{
	m_pMainDlg->OnChatRecvMsgTypingStart(sUserName);
}

void CVaxSIPUserAgentLibEx::OnChatRecvMsgTypingStop(LPCTSTR sAccountName, LPCTSTR sUserName)
{
	m_pMainDlg->OnChatRecvMsgTypingStop(sUserName);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnBusyLampSubscribeSuccess(LPCTSTR sAccountName, LPCTSTR sUserName)
{
	m_pMainDlg->OnBusyLampSubscribeSuccess(sUserName);
}

void CVaxSIPUserAgentLibEx::OnBusyLampSubscribeFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pMainDlg->OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
}

void CVaxSIPUserAgentLibEx::OnBusyLampContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusId)
{
	m_pMainDlg->OnBusyLampContactStatus(sUserName, nStatusId);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnAudioRecordedPCM(LPCTSTR sAccountName, int nLineNo, char* pDataPCM, int nSizePCM, int nTypePCM)
{
}

void CVaxSIPUserAgentLibEx::OnDetectedAMD(LPCTSTR sAccountName, int nLineNo, BOOL bIsHuman)
{
	m_pMainDlg->OnDetectedAMD(nLineNo,bIsHuman);
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnIncomingDiagnostic(LPCTSTR sAccountName, LPCTSTR sMsgSIP, LPCTSTR sFromIP, int nFromPort)
{
}

void CVaxSIPUserAgentLibEx::OnOutgoingDiagnostic(LPCTSTR sAccountName, LPCTSTR sMsgSIP, LPCTSTR sToIP, int nToPort)
{
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnHoldCall(LPCTSTR sAccountName, int nLineNo)
{
}

void CVaxSIPUserAgentLibEx::OnUnHoldCall(LPCTSTR sAccountName, int nLineNo)
{
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnMsgNOTIFY(LPCTSTR sAccountName, LPCTSTR sMsg)
{
}

void CVaxSIPUserAgentLibEx::OnVoiceMailMsg(LPCTSTR sAccountName, BOOL bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, LPCTSTR sMsgAccount)
{
	m_pMainDlg->OnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnVideoRemoteStarted(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnVideoRemoteStarted(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnVideoRemoteEnded(LPCTSTR sAccountName, int nLineNo)
{
	m_pMainDlg->OnVideoRemoteEnded(nLineNo);
}

void CVaxSIPUserAgentLibEx::OnVideoDeviceFrameRGB(int nDeviceId, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
{
	m_pMainDlg->OnVideoDeviceFrameRGB(nDeviceId, pFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
}

void CVaxSIPUserAgentLibEx::OnVideoRemoteFrameRGB(LPCTSTR sAccountName, int nLineNo, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
{
	m_pMainDlg->OnVideoRemoteFrameRGB(nLineNo, pFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
}

///////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnStatusMsgREC(int nLineNo)
{
	int nErrorCode = CVaxSIPUserAgentLib::GetVaxErrorCode();
	CString sErrorMsg = CVaxSIPUserAgentLib::GetVaxErrorMsg();

	m_pMainDlg->OnStatusMsgREC(nLineNo, nErrorCode, sErrorMsg);
}

///////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnAddCallHistory(LPCTSTR sAccountName, BOOL bOutboundCallType, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, UINT64 nStartTime, UINT64 nEndTime, UINT64 nDuration, UINT64 nDayNo, int nHistoryTypeId)
{
}

void CVaxSIPUserAgentLibEx::OnNetworkReachability(BOOL bAvailable)
{
	m_pMainDlg->OnNetworkReachability(bAvailable);
}

///////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnAudioDeviceMicVU(int nLevelVU)
{
	m_pMainDlg->OnAudioDeviceMicVU(nLevelVU);
}

void CVaxSIPUserAgentLibEx::OnAudioDeviceSpkVU(int nLevelVU)
{
	m_pMainDlg->OnAudioDeviceSpkVU(nLevelVU);
}

///////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

void CVaxSIPUserAgentLibEx::OnVaxErrorMsg(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode)
{
	POSITION hPos = m_objDontShowErrorMsg.Find(sFuncName);
	
	if(hPos != NULL)
	{
		m_objDontShowErrorMsg.RemoveAt(hPos);
		return;
	}
	
	m_pMainDlg->OnVaxErrorMsg(sFuncName, sErrorMsg, nErrorCode);
}