//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

#pragma once

class CVaxUserAgentSIP;


#define VAX_ACCOUNT_TYPE_UDP			0
#define VAX_ACCOUNT_TYPE_TCP			1
#define VAX_ACCOUNT_TYPE_TLS			2

#define VAX_CAPTURE_SOUND_DEVICE_NONE	-2

#define VAX_VIDEO_QUALITY_LOW			0
#define VAX_VIDEO_QUALITY_STANDARD		1
#define VAX_VIDEO_QUALITY_MEDIUM		2
#define VAX_VIDEO_QUALITY_HIGH			3
#define VAX_VIDEO_QUALITY_MAX			4

#define VAX_AUDIO_CODEC_G711U			0
#define VAX_AUDIO_CODEC_G711A			1
#define VAX_AUDIO_CODEC_GSM610			2
#define VAX_AUDIO_CODEC_ILBC			3
#define VAX_AUDIO_CODEC_G729			4

#define VAX_VIDEO_CODEC_VP8				0

#define VAX_DTMF_TYPE_AUTO				0
#define VAX_DTMF_TYPE_RFC2833			1
#define VAX_DTMF_TYPE_SIP_INFO			2
#define VAX_DTMF_TYPE_INBAND			3

#define VAX_CONTACT_STATUS_ONLINE		0
#define VAX_CONTACT_STATUS_OFFLINE		1
#define VAX_CONTACT_STATUS_AWAY			2
#define VAX_CONTACT_STATUS_ON_PHONE		3
#define VAX_CONTACT_STATUS_BUSY			4
#define VAX_CONTACT_STATUS_UNKNOWN		5

#define VAX_BUSY_LAMP_STATUS_FREE		0
#define VAX_BUSY_LAMP_STATUS_OFFLINE	1
#define VAX_BUSY_LAMP_STATUS_BUSY		2
#define VAX_BUSY_LAMP_STATUS_UNKNOWN	3
#define VAX_BUSY_LAMP_STATUS_CONNECTING	4

#define VAX_INCOMING_CALL_ACCEPTED		0
#define VAX_INCOMING_CALL_REJECTED		1
#define VAX_INCOMING_CALL_CANCELED		2

class CVaxSIPUserAgentLib
{

public:

	CVaxSIPUserAgentLib();
	~CVaxSIPUserAgentLib();

private:

	CVaxUserAgentSIP* m_pUserAgentSIP;

public:

	LPCTSTR GetVersionFile();
	LPCTSTR GetVersionSDK();

	BOOL SetLicenceKey(LPCTSTR sLicenceKey);

	BOOL Initialize();
	void UnInitialize();
		
	BOOL AddAccountSIP(LPCTSTR sAccountName, int nAccountType, LPCTSTR sListenIP, UINT nListenPort, LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sAuthLogin, LPCTSTR sAuthPwd, LPCTSTR sDomainRealm, LPCTSTR sServerAddr, UINT nServerPort);
	void RemoveAccountSIP(LPCTSTR sAccountName);

	BOOL RegisterAccountSIP(LPCTSTR sAccountName, int nExpire);
	BOOL UnRegisterAccountSIP(LPCTSTR sAccountName);

	BOOL OpenLine(int nLineNo, LPCTSTR sRTPRxIP, int nRxAudioPortRTP, int nRxVideoPortRTP);
	BOOL OpenLineREC(int nLineNo, LPCTSTR sRTPRxIP, int nAudioPortRTP);
	BOOL CloseLine(int nLineNo);

	BOOL CryptoMediaNONE(BOOL bForced);
	BOOL CryptoMediaSDP(BOOL bForced);

	int GetVaxErrorCode();
	LPCTSTR GetVaxErrorMsg();

	LPCTSTR GetCallId(int nLineNo);
	BOOL AudioDeviceVU(BOOL bActivate, BOOL bMicVU, BOOL bSpkVU);

	int GetAudioInDevTotal();
	int GetAudioOutDevTotal();

	LPCTSTR GetAudioInDevName(int nDeviceId);
	LPCTSTR GetAudioOutDevName(int nDeviceId);

	BOOL DialCall(LPCTSTR sAccountName, int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, int nInputDeviceId, int nOutputDeviceId);
	BOOL DialCallToREC(LPCTSTR sAccountName, int nLineNo, LPCTSTR sDialNo);
	BOOL DisconnectCall(int nLineNo);

	BOOL AcceptCall(int nLineNo, LPCTSTR sCallId, int nInputDeviceId, int nOutputDeviceId);
	BOOL RejectCall(LPCTSTR sCallId);

	BOOL TransferCallBlind(int nLineNo, LPCTSTR sToUserName);
	BOOL TransferCallConsult(int nLineNoA, int nLineNoB);

	BOOL HoldLine(int nLineNo);
	BOOL UnHoldLine(int nLineNo);
	BOOL RefreshLine(int nLineNo);

	BOOL IsLineOpen(int nLineNo);
	BOOL IsLineHold(int nLineNo);
	BOOL IsLineBusy(int nLineNo);
	BOOL IsLineConnected(int nLineNo);

	BOOL EnableKeepAlive(LPCTSTR sAccountName, int nSeconds);
	void DisableKeepAlive(LPCTSTR sAccountName);

	void DeselectAllAudioCodec();
	void SelectAllAudioCodec();
	BOOL SelectAudioCodec(int nCodecNo);
	BOOL DeselectAudioCodec(int nCodecNo);

	void DeselectAllVideoCodec();
	void SelectAllVideoCodec();
	BOOL SelectVideoCodec(int nCodecNo);
	BOOL DeselectVideoCodec(int nCodecNo);

	BOOL DigitDTMF(int nLineNo, LPCTSTR sDigit, int nTypeDTMF);
	BOOL SetVolumeDTMF(int nVolume);
	int GetVolumeDTMF();

	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////

	BOOL MuteMic(BOOL bMute);
	BOOL MuteSpk(BOOL bMute);

	BOOL MuteLineSpk(int nLineNo, BOOL bMute);
	BOOL MuteLineMic(int nLineNo, BOOL bMute);

	BOOL AutoGainMic(BOOL bEnable, int nVolume);
	BOOL AutoGainSpk(BOOL bEnable, int nVolume);

	BOOL SetVolumeMic(int nVolume);
	int GetVolumeMic();

	BOOL SetVolumeSpk(int nVolume);
	int GetVolumeSpk();

	BOOL SetLineVolumeSpk(int nLineNo, int nVolume);
	int GetLineVolumeSpk(int nLineNo);

	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////

	BOOL EchoCancellation(BOOL bEnable);
	BOOL DonotDisturb(BOOL bEnable);

	BOOL IsLineRecording(int nLineNo);
	BOOL StartRecording(int nLineNo, LPCTSTR sFileName, int nTypeRecord, int nTypePCM);
	BOOL StopRecording(int nLineNo);
	BOOL ResetRecording(int nLineNo);

	BOOL IsLinePlaying(int nLineNo);

	BOOL PlayWaveOpen(int nLineNo, LPCTSTR sFileName);
	BOOL PlayWaveClose(int nLineNo);

	BOOL PlayWaveSkipTo(int nLineNo, int nMilliSeconds);
	int PlayWaveTotalTime(int nLineNo);
	BOOL PlayWavePause(int nLineNo);
	BOOL PlayWaveStart(int nLineNo, BOOL bListen);
	BOOL PlayWaveStop(int nLineNo);
	int PlayWavePosition(int nLineNo);

	int GetOutboundCodec(int nLineNo);
	int GetInboundCodec(int nLineNo);

	BOOL AudioSessionLost(int nSeconds);

	BOOL SetUserAgentSIP(LPCTSTR sUserAgentName);
	LPCTSTR GetUserAgentSIP();

	BOOL SetSubjectSDP(LPCTSTR sSubjectSDP);
	LPCTSTR GetSubjectSDP();

	BOOL ConfAllowLine(int nLineNo, BOOL bAllowListen, BOOL bAllowSpeak);
	BOOL LineVoiceChannelSpk(int nLineNo, int nChannel);

	BOOL ChatFindContact(LPCTSTR sAccountName, LPCTSTR sUserName);
	BOOL ChatAddContact(LPCTSTR sAccountName, LPCTSTR sUserName, BOOL bPresence);
	BOOL ChatRemoveContact(LPCTSTR sAccountName, LPCTSTR sUserName);

	BOOL ChatSendMessageTyping(LPCTSTR sAccountName, LPCTSTR sUserName, UINT64 nUserValue);
	BOOL ChatSendMessageText(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, BOOL bMsgTypeHtml, UINT64 nUserValue);

	BOOL ChatSubscribeContactAll(LPCTSTR sAccountName);
	BOOL ChatSetMyStatus(LPCTSTR sAccountName, int nStatusId);

	BOOL VoiceChanger(int nPitch);
	BOOL ForwardCall(BOOL bEnable, LPCTSTR sToUserName);

	BOOL PlayAddPCM(int nLineNo, char* pDataPCM, int nSizePCM);
	BOOL PlayResetPCM(int nLineNo);

	BOOL DetectAMD(int nLineNo, BOOL bEnable, int nAnalysisTime, int nSilenceTime, int nSilenceCount);

	BOOL AddCustomHeader(int nLineNo, int nReqId, LPCTSTR sName, LPCTSTR sValue);
	BOOL RemoveCustomHeader(int nLineNo, int nReqId, LPCTSTR sName);
	BOOL RemoveCustomHeaderAll(int nLineNo, int nReqId);

	BOOL AddCustomHeaderReferToURI(LPCTSTR sName, LPCTSTR sValue);
	BOOL RemoveCustomHeaderReferToURI(LPCTSTR sName);
	BOOL RemoveCustomHeaderAllReferToURI();

	BOOL ActivateQosSIP(int nPriorityQos);
	void DeactivateQosSIP();

	BOOL ActivateQosRTP(int nLineNo, int nPriorityQos);
	void DeactivateQosRTP(int nLineNo);

	int GetCountPacketLost(int nLineNo);
	int GetSizeJitterBuffer(int nLineNo);

	BOOL OpenMediaSecondry(int nInputDeviceId, int nOutputDeviceId);
	BOOL CloseMediaSecondry();

	BOOL ChangeMEDIA(int nLineNo, int nInputDeviceId, int nOutputDeviceId);

	int GetVideoDevTotal();
	LPCTSTR GetVideoDevName(int nDeviceId);

	BOOL OpenVideoDev(int nDeviceId, int nQuality);
	void CloseVideoDev();

	BOOL DialRingEnable(LPCTSTR sFileName);
	BOOL DialRingDisable();

	BOOL BusyRingEnable(LPCTSTR sFileName);
	BOOL BusyRingDisable();

	BOOL EnableVideo(int nLineNo, BOOL bOutbound, BOOL bInbound);

	BOOL IsNetworkAvailable();
	BOOL NetworkReachability(BOOL bEnable);

	BOOL AutoRegistration(LPCTSTR sAccountName, BOOL bEnable, int nTryCount, int nTryAfterSeconds);
	BOOL VideoCodecBitRate(int nCodecNo, int nQuality);

	int BusyLampGetContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName);
	BOOL BusyLampFindContact(LPCTSTR sAccountName, LPCTSTR sUserName);
	BOOL BusyLampAddContact(LPCTSTR sAccountName, LPCTSTR sUserName);
	BOOL BusyLampRemoveContact(LPCTSTR sAccountName, LPCTSTR sUserName);
	BOOL BusyLampSubscribeContactAll(LPCTSTR sAccountName);
	
	BOOL AudioVAD(int nLineNo, BOOL bEnable);

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	BOOL DiagnosticLogSIP(LPCTSTR sAccountName, BOOL bInbound, BOOL bOutbound);

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	virtual void OnInitialized();
	virtual void OnUnInitialized();

	virtual void OnConnectingToRegister(LPCTSTR sAccountName);
	virtual void OnTryingToRegister(LPCTSTR sAccountName);

	virtual void OnFailToRegister(LPCTSTR sAccountName, int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnSuccessToRegister(LPCTSTR sAccountName);

	virtual void OnConnectingToReRegister(LPCTSTR sAccountName);
	virtual void OnTryingToReRegister(LPCTSTR sAccountName);

	virtual void OnFailToReRegister(LPCTSTR sAccountName, int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnSuccessToReRegister(LPCTSTR sAccountName);

	virtual void OnTryingToUnRegister(LPCTSTR sAccountName);
	virtual void OnFailToUnRegister(LPCTSTR sAccountName);
	virtual void OnSuccessToUnRegister(LPCTSTR sAccountName);

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	virtual void OnDialCallStarted(LPCTSTR sAccountName, int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	virtual void OnDialingCall(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnDialCallFailed(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sContact);

	virtual void OnConnectedCall(LPCTSTR sAccountName, int nLineNo, LPCTSTR sToAddrRTP, int nToPortRTP);
	virtual void OnHungupCall(LPCTSTR sAccountName, int nLineNo);

	virtual void OnIncomingCallStarted(LPCTSTR sAccountName, LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, LPCTSTR sFromURI, LPCTSTR sToURI);
	virtual void OnIncomingCallEnded(LPCTSTR sAccountName, LPCTSTR sCallId, int nReasonCode);

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	virtual void OnTransferCallFailed(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnTransferCallAccepted(LPCTSTR sAccountName, int nLineNo);

	virtual void OnPlayWaveDone(LPCTSTR sAccountName, int nLineNo);
	virtual void OnDigitDTMF(LPCTSTR sAccountName, int nLineNo, LPCTSTR sDigit);

	virtual void OnMsgNOTIFY(LPCTSTR sAccountName, LPCTSTR sMsg);
	virtual void OnVoiceMailMsg(LPCTSTR sAccountName, BOOL bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, LPCTSTR sMsgAccount);

	virtual void OnRingToneStarted(LPCTSTR sAccountName, LPCTSTR sCallId);
	virtual void OnRingToneEnded(LPCTSTR sAccountName, LPCTSTR sCallId);

	virtual void OnIncomingDiagnostic(LPCTSTR sAccountName, LPCTSTR sMsgSIP, LPCTSTR sFromIP, int nFromPort);
	virtual void OnOutgoingDiagnostic(LPCTSTR sAccountName, LPCTSTR sMsgSIP, LPCTSTR sToIP, int nToPort);

	virtual void OnAudioSessionLost(LPCTSTR sAccountName, int nLineNo);

	virtual void OnSuccessToHold(LPCTSTR sAccountName, int nLineNo);
	virtual void OnTryingToHold(LPCTSTR sAccountName, int nLineNo);
	virtual void OnFailToHold(LPCTSTR sAccountName, int nLineNo);

	virtual void OnSuccessToUnHold(LPCTSTR sAccountName, int nLineNo);
	virtual void OnTryingToUnHold(LPCTSTR sAccountName, int nLineNo);
	virtual void OnFailToUnHold(LPCTSTR sAccountName, int nLineNo);

	virtual void OnTryingToRefresh(LPCTSTR sAccountName, int nLineNo);
	virtual void OnFailToRefresh(LPCTSTR sAccountName, int nLineNo);
	virtual void OnSuccessToRefresh(LPCTSTR sAccountName, int nLineNo);

	virtual void OnChatSubscribeSuccess(LPCTSTR sAccountName, LPCTSTR sUserName);
	virtual void OnChatSubscribeFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);

	virtual void OnChatContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusId);

	virtual void OnChatSendMsgTextSuccess(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue);
	virtual void OnChatSendMsgTextFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue);

	virtual void OnChatSendMsgTypingSuccess(LPCTSTR sAccountName, LPCTSTR sUserName, UINT64 nUserValue);
	virtual void OnChatSendMsgTypingFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue);

	virtual void OnChatRecvMsgText(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, BOOL bIsChatContact);
	virtual void OnChatRecvMsgTypingStart(LPCTSTR sAccountName, LPCTSTR sUserName);
	virtual void OnChatRecvMsgTypingStop(LPCTSTR sAccountName, LPCTSTR sUserName);

	virtual void OnAudioRecordedPCM(LPCTSTR sAccountName, int nLineNo, char* pDataPCM, int nSizePCM, int nTypePCM);
	virtual void OnDetectedAMD(LPCTSTR sAccountName, int nLineNo, BOOL bIsHuman);

	virtual void OnHoldCall(LPCTSTR sAccountName, int nLineNo);
	virtual void OnUnHoldCall(LPCTSTR sAccountName, int nLineNo);

	virtual void OnVideoRemoteStarted(LPCTSTR sAccountName, int nLineNo);
	virtual void OnVideoRemoteEnded(LPCTSTR sAccountName, int nLineNo);

	virtual void OnVideoDeviceFrameRGB(int nDeviceId, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);
	virtual void OnVideoRemoteFrameRGB(LPCTSTR sAccountName, int nLineNo, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);

	virtual void OnAddCallHistory(LPCTSTR sAccountName, BOOL bOutboundCallType, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, UINT64 nStartTime, UINT64 nEndTime, UINT64 nDuration, UINT64 nDayNo, int nHistoryTypeId);
	virtual void OnNetworkReachability(BOOL bAvailable);

	virtual void OnAudioDeviceMicVU(int nLevelVU);
	virtual void OnAudioDeviceSpkVU(int nLevelVU);

	virtual void OnBusyLampSubscribeSuccess(LPCTSTR sAccountName, LPCTSTR sUserName);
	virtual void OnBusyLampSubscribeFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnBusyLampContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusId);

	virtual void OnVaxErrorMsg(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode);
};


