// SettingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "MainSettingDlg.h"
#include "afxdialogex.h"
#include "VaxSIPUserAgentLibEx.h"

// CMainSettingDlg dialog

IMPLEMENT_DYNAMIC(CMainSettingDlg, CPropertyPage)

CMainSettingDlg::CMainSettingDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent): CPropertyPage(CMainSettingDlg::IDD)
{
	m_psp.dwFlags &= ~PSP_HASHELP; 
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;
		
	m_nRadioSelIndexDTMF = 0;
	m_bCheckEchoCancellation = TRUE;

	m_bCheckG711U_LAW = TRUE;
	m_bCheckG729 = TRUE;
	m_bCheckG711A_LAW = TRUE;
	m_bCheckGSM610 = FALSE;
	m_bCheckILBC = FALSE;

	m_bCheckAGC = FALSE;
	m_bCheckMicBoost = FALSE;
									
	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana");                    
}

CMainSettingDlg::~CMainSettingDlg()
{

}

void CMainSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_VOICE_CODEC_GSM610, m_bCheckGSM610);
	DDX_Check(pDX, IDC_CHECK_VOICE_CODEC_ILBC, m_bCheckILBC);
	DDX_Check(pDX, IDC_CHECK_VOICE_CODEC_G729, m_bCheckG729);
	DDX_Check(pDX, IDC_CHECK_VOICE_CODEC_G711A , m_bCheckG711A_LAW);
	DDX_Check(pDX, IDC_CHECK_VOICE_CODEC_G711U, m_bCheckG711U_LAW);
	DDX_Check(pDX, IDC_CHECK_NOISE_CANCEL, m_bCheckEchoCancellation);
	DDX_Check(pDX, IDC_CHECK_AGC, m_bCheckAGC);
	
	DDX_Check(pDX, IDC_CHECK_MIC_BOOST, m_bCheckMicBoost);
	
	DDX_Control(pDX, IDC_LIST_AUDIO_IN, m_ctrlListAudioIn);
	DDX_Control(pDX, IDC_LIST_AUDIO_OUT, m_ctrlListAudioOut);
	DDX_Control(pDX, IDC_LIST_VIDEO, m_ctrlListVideo);

	GetDlgItem(IDC_GROUP_VOICE_CODECS)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_OTHER_SETTINGS)->SetFont(&m_objFont);

	GetDlgItem(IDC_GROUP_AUDIO_IN)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_AUDIO_OUT)->SetFont(&m_objFont);

	GetDlgItem(IDC_GROUP_VIDEO)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_VIDEO_QUALITY)->SetFont(&m_objFont);
		
	DDX_Radio(pDX, IDC_RADIO_FORCE_NONE, m_nRadioSelIndexDTMF);
	DDX_Control(pDX, IDC_COMBO_VIDEO_QUALITY, m_ctrlVideoQuality);
}

BEGIN_MESSAGE_MAP(CMainSettingDlg, CPropertyPage)
	
	ON_BN_CLICKED(IDC_CHECK_VOICE_CODEC_GSM610, &CMainSettingDlg::OnCheckCodecGsm610_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_VOICE_CODEC_ILBC, &CMainSettingDlg::OnCheckCodecILBC_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_VOICE_CODEC_G729, &CMainSettingDlg::OnCheckCodecG729_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_VOICE_CODEC_G711A, &CMainSettingDlg::OnCheckCodecG711A_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_VOICE_CODEC_G711U, &CMainSettingDlg::OnCheckCodecG711U_CheckChanged)
			
	ON_BN_CLICKED(IDC_CHECK_NOISE_CANCEL, &CMainSettingDlg::OnCheckNoiseCancel_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_AGC, &CMainSettingDlg::OnCheckAGC_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_MIC_BOOST, &CMainSettingDlg::OnCheckBoostMic_CheckChanged)
		
	ON_LBN_SELCHANGE(IDC_LIST_AUDIO_IN, &CMainSettingDlg::On_SelChangeAudioIn)
	ON_LBN_SELCHANGE(IDC_LIST_AUDIO_OUT, &CMainSettingDlg::On_SelChangeAudioOut)
	ON_LBN_SELCHANGE(IDC_LIST_VIDEO, &CMainSettingDlg::On_SelChangeVideo)
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_QUALITY, &CMainSettingDlg::OnSelChangeComboVideoQuality)
	
	ON_BN_CLICKED(IDC_RADIO_FORCE_NONE, &CMainSettingDlg::OnBnClickedRadioForceNone)
	ON_BN_CLICKED(IDC_RADIO_FORCE_INBAND_DTMF, &CMainSettingDlg::OnBnClickedRadioForceInbandDtmf)
	ON_BN_CLICKED(IDC_RADIO_FORCE_RFC_2833_DTMF, &CMainSettingDlg::OnBnClickedRadioForceRfc2833Dtmf)
	ON_BN_CLICKED(IDC_RADIO_FORCE_INFO_DTMF, &CMainSettingDlg::OnBnClickedRadioForceInfoDtmf)
END_MESSAGE_MAP()


BOOL CMainSettingDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlVideoQuality.AddString("Low");
	m_ctrlVideoQuality.AddString("Standard");
	m_ctrlVideoQuality.AddString("Medium");
	m_ctrlVideoQuality.AddString("High");
	m_ctrlVideoQuality.AddString("Max");
	
	m_ctrlVideoQuality.SetWindowPos(NULL, 0, 0, 180, 100, SWP_NOMOVE);
	m_ctrlVideoQuality.SetCurSel(VAX_VIDEO_QUALITY_MEDIUM);
		
	return TRUE; 
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::OnVaxOnline()
{
	UpdateAudioIn();
    UpdateAudioOut();
	UpdateVideo();
	
	ActivateVideoQuality();

	ActivateAudioCodecs();
	ActivateVideoCodecs();

	ActivateOtherSettings();
	ActivateDigitDTMF();
}

void CMainSettingDlg::OnVaxOffline()
{
	
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::UpdateAudioIn()
{
	m_ctrlListAudioIn.ResetContent();
	
	m_ctrlListAudioIn.InsertString(0,"Default Device");
	m_ctrlListAudioIn.SetItemData(0, -1);

	int nDeviceId = 0;
	CString sDeviceName;

    for(nDeviceId = 0; nDeviceId < m_pVaxUserAgentSIP->GetAudioInDevTotal(); nDeviceId++)
    {
        sDeviceName = m_pVaxUserAgentSIP->GetAudioInDevName(nDeviceId);

		int nIndexInsertedItem = m_ctrlListAudioIn.AddString(sDeviceName);
		m_ctrlListAudioIn.SetItemData(nIndexInsertedItem, nDeviceId);
    }

	m_ctrlListAudioIn.SetCurSel(0);
 
	int nIndex = m_ctrlListAudioIn.GetTopIndex();
	nDeviceId = m_ctrlListAudioIn.GetItemData(nIndex);

    m_pVaxUserAgentSIP->SetActiveAudioInDevice(nDeviceId);
}

void CMainSettingDlg::UpdateAudioOut()
{
	m_ctrlListAudioOut.ResetContent();

	int nDeviceId;
    CString sDeviceName;

	int nTest = m_ctrlListAudioOut.InsertString(0, "Default Device");
	m_ctrlListAudioOut.SetItemData(0, -1);

    for(int nDeviceId = 0; nDeviceId < m_pVaxUserAgentSIP->GetAudioOutDevTotal(); nDeviceId++)
    {
        sDeviceName = m_pVaxUserAgentSIP->GetAudioOutDevName(nDeviceId);

		int nIndexInsertedItem = m_ctrlListAudioOut.AddString(sDeviceName);
		m_ctrlListAudioOut.SetItemData(nIndexInsertedItem, nDeviceId);
    }

	m_ctrlListAudioOut.SetCurSel(0);
 
	int nIndex = m_ctrlListAudioOut.GetTopIndex();
	nDeviceId = m_ctrlListAudioOut.GetItemData(nIndex);
    m_pVaxUserAgentSIP->SetActiveAudioOutDevice(nDeviceId);
}

void CMainSettingDlg::UpdateVideo()
{
	m_ctrlListVideo.ResetContent();

	if(m_pVaxUserAgentSIP->GetVideoDevTotal() == 0)
		return;
    
	for(int nDeviceIndex = 0; nDeviceIndex < m_pVaxUserAgentSIP->GetVideoDevTotal(); nDeviceIndex++)
    {
        CString sDeviceName = m_pVaxUserAgentSIP->GetVideoDevName(nDeviceIndex);
		
		int nIndexInsertedItem = m_ctrlListVideo.AddString(sDeviceName);
		m_ctrlListVideo.SetItemData(nIndexInsertedItem, nDeviceIndex);
    }

	m_ctrlListVideo.SetCurSel(0);
		
	int nDeviceId = m_ctrlListVideo.GetItemData(0);
    m_pVaxUserAgentSIP->SetActiveVideoDevice(nDeviceId);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort)
{
	m_bCheckMicBoost = m_pVaxUserAgentSIP->IsVolumeBoostMic();
	UpdateData(FALSE);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::OnCheckCodecGsm610_CheckChanged()
{
	UpdateData(TRUE);

	if(m_bCheckGSM610)
		m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_GSM610);
	else
		m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_GSM610);
}

void CMainSettingDlg::OnCheckCodecILBC_CheckChanged()
{
    UpdateData(TRUE);

    if(m_bCheckILBC)
        m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_ILBC);
    else
        m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_ILBC);
}

void CMainSettingDlg::OnCheckCodecG729_CheckChanged()
{
    UpdateData(TRUE);

	if(m_bCheckG729)
        m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_G729);
    else
        m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_G729);
}

void CMainSettingDlg::OnCheckCodecG711A_CheckChanged()
{
    UpdateData(TRUE);

    if(m_bCheckG711A_LAW)
        m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_G711A);
    else
        m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_G711A); 
}

void CMainSettingDlg::OnCheckCodecG711U_CheckChanged()
{
	UpdateData(TRUE);

	if(m_bCheckG711U_LAW)
        m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_G711U);
    else
        m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_G711U);	
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::OnCheckNoiseCancel_CheckChanged()
{
	UpdateData(TRUE);
	m_pVaxUserAgentSIP->EchoCancellation(m_bCheckEchoCancellation);
}

void CMainSettingDlg::OnCheckAGC_CheckChanged()
{
	UpdateData(TRUE);
	m_pVaxUserAgentSIP->AutoGainMic(m_bCheckAGC, 8000);
}

void CMainSettingDlg::OnCheckBoostMic_CheckChanged()
{
	UpdateData(TRUE);
	m_pVaxUserAgentSIP->SetVolumeBoostMic(m_bCheckMicBoost);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::On_SelChangeAudioIn()
{
	int nSelIndex = m_ctrlListAudioIn.GetCurSel();
	int nDeviceId = m_ctrlListAudioIn.GetItemData(nSelIndex);

	m_pVaxUserAgentSIP->SetActiveAudioInDevice(nDeviceId);
}

void CMainSettingDlg::On_SelChangeAudioOut()
{
	int nSelIndex = m_ctrlListAudioOut.GetCurSel();
	int nDeviceId = m_ctrlListAudioOut.GetItemData(nSelIndex);
 
	m_pVaxUserAgentSIP->SetActiveAudioOutDevice(nDeviceId);
}

void CMainSettingDlg::On_SelChangeVideo()
{
	int nSelIndex = m_ctrlListVideo.GetCurSel();
	if(nSelIndex == -1) return;

	int nDeviceId = m_ctrlListVideo.GetItemData(nSelIndex);
	m_pVaxUserAgentSIP->SetActiveVideoDevice(nDeviceId);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::OnSelChangeComboVideoQuality()
{
	ActivateVideoQuality();
}

void CMainSettingDlg::ActivateVideoQuality()
{
	int nSelIndex = m_ctrlVideoQuality.GetCurSel();
	if(nSelIndex == -1) return;

	m_pVaxUserAgentSIP->SetVideoQuality(nSelIndex);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::ActivateAudioCodecs()
{
	UpdateData();

	m_pVaxUserAgentSIP->DeselectAllAudioCodec();
	
	if(m_bCheckG711U_LAW)
		m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_G711U);
	else
		m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_G711U);
		

	if(m_bCheckG711A_LAW)
		m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_G711A);
	else
		m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_G711A);


	if(m_bCheckGSM610)
		m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_GSM610);
	else
		m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_GSM610);


	if(m_bCheckG729)
		m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_G729);
	else
		m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_G729);


	if(m_bCheckILBC)
		m_pVaxUserAgentSIP->SelectAudioCodec(VAX_AUDIO_CODEC_ILBC);
	else
		m_pVaxUserAgentSIP->DeselectAudioCodec(VAX_AUDIO_CODEC_ILBC);
}

void CMainSettingDlg::ActivateVideoCodecs()
{
	m_pVaxUserAgentSIP->DeselectAllVideoCodec();
	m_pVaxUserAgentSIP->SelectVideoCodec(VAX_VIDEO_CODEC_VP8);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::ActivateOtherSettings()
{
	UpdateData();
	
	m_pVaxUserAgentSIP->EchoCancellation(m_bCheckEchoCancellation);
	m_pVaxUserAgentSIP->AutoGainMic(m_bCheckAGC, 8000);
		
	m_pVaxUserAgentSIP->SetVolumeBoostMic(m_bCheckMicBoost);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::ActivateDigitDTMF()
{
	UpdateData();

	switch(m_nRadioSelIndexDTMF)
	{
		case 0:
			m_pVaxUserAgentSIP->ForceDigitDTMF(VAX_DTMF_TYPE_AUTO);
		break;

		case 1:
			
			//Enable Inband DTMF and VaxVoIP sends DTMF tones in the form of voice. Inband DTMF is not recommended
            //by IP-Telephony standards, because Inband DTMF only works if there is voice session with G711u or G711a codecs.
			
			m_pVaxUserAgentSIP->ForceDigitDTMF(VAX_DTMF_TYPE_INBAND);
		break;

		case 2:
			m_pVaxUserAgentSIP->ForceDigitDTMF(VAX_DTMF_TYPE_RFC2833);
		break;

		case 3:
			m_pVaxUserAgentSIP->ForceDigitDTMF(VAX_DTMF_TYPE_SIP_INFO);
		break;
	}
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

void CMainSettingDlg::OnBnClickedRadioForceNone()
{
	ActivateDigitDTMF();
}


void CMainSettingDlg::OnBnClickedRadioForceInbandDtmf()
{
	ActivateDigitDTMF();
}


void CMainSettingDlg::OnBnClickedRadioForceRfc2833Dtmf()
{
	ActivateDigitDTMF();
}


void CMainSettingDlg::OnBnClickedRadioForceInfoDtmf()
{
	ActivateDigitDTMF();
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

BOOL CMainSettingDlg::OnApply()
{
	return FALSE;
}
