#include "StdAfx.h"
#include "Define.h"
#include "PhoneTone.h"
#include "VaxSIPUserAgentLibEx.h"
#include <MMSystem.h>

CPhoneTone::CPhoneTone(void)
{
	m_bActivateRingTone = FALSE;
}

CPhoneTone::~CPhoneTone(void)
{
}

void CPhoneTone::OnVaxInit(BOOL bPlayDialTone, BOOL bPlayRingTone)
{
	ActivateDialTone(bPlayDialTone);
	ActivateRingTone(bPlayRingTone);
	
	m_pVaxUserAgentSIP->BusyRingEnable();
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneTone::ActivateDialTone(BOOL bActivate)
{
	if(bActivate)
	{
		m_pVaxUserAgentSIP->DialRingEnable();
	}
	else
	{
		m_pVaxUserAgentSIP->DialRingDisable();
	}
}

void CPhoneTone::ActivateRingTone(BOOL bActivate)
{
	m_bActivateRingTone = bActivate;

	if(!bActivate)
		PlaySound(NULL, 0, 0);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneTone::OnRingToneStarted(LPCTSTR sCallId)
{   
	if(!m_bActivateRingTone) return;
	
	PlaySound(VAX_INBOUND_RING_WAVE_FILE, 0, SND_ASYNC | SND_FILENAME | SND_LOOP | SND_NODEFAULT);
}

void CPhoneTone::OnRingToneEnded(LPCTSTR sCallId)
{
	if(!m_bActivateRingTone) return;
	
	PlaySound(NULL, 0, 0);
}

