#include "StdAfx.h"
#include "VaxSIPUserAgentLibEx.h"
#include "PhoneLineStatus.h"

CPhoneLineStatus::CPhoneLineStatus(void)
{
	
}

CPhoneLineStatus::~CPhoneLineStatus(void)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CPhoneLineStatus::OnVaxInit(int nTotalLines)
{
	m_nTotalLines = nTotalLines;
}

void CPhoneLineStatus::OnVaxUnInit()
{
	
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CPhoneLineStatus::OnLineStatusTick(int nSelectedLineNo)
{
	for (int nLineNo = 0; nLineNo < m_nTotalLines; nLineNo++)
	{
		if (m_pVaxUserAgentSIP->IsLineBusy(nLineNo))
		{
			if (m_pVaxUserAgentSIP->IsLinePlaying(nLineNo))
			{
				OnChangeLineStatus(nLineNo, "playing");
			}
			else if (m_pVaxUserAgentSIP->IsLineHold(nLineNo))
			{
				OnChangeLineStatus(nLineNo, "hold");
			}
			else
			{
				OnChangeLineStatus(nLineNo, "busy");
			}
		}
		else
		{
			OnChangeLineStatus(nLineNo, "free");
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CPhoneLineStatus::OnChangeLineStatus(int nLineNo, LPCTSTR sStatus)
{
	
}