// CallAlert.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "PhoneIncomingCallForm.h"
#include "afxdialogex.h"
#include "VaxVoIPDlg.h"


#define PHONE_TAB_PAGE_INDEX	1

// CPhoneIncomingCallForm dialog

IMPLEMENT_DYNAMIC(CPhoneIncomingCallForm, CDialogEx)

CPhoneIncomingCallForm::CPhoneIncomingCallForm(CWnd* pParent /*=NULL*/)	: CDialogEx(CPhoneIncomingCallForm::IDD, pParent)
{
	m_bCreatedWnd = FALSE;
}

CPhoneIncomingCallForm::~CPhoneIncomingCallForm()
{
}

void CPhoneIncomingCallForm::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);

	CFont objFont;
	objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana"); 
	GetDlgItem(IDC_LBLCALLALERT)->SetFont(&objFont);
}


BEGIN_MESSAGE_MAP(CPhoneIncomingCallForm, CDialogEx)
	ON_BN_CLICKED(IDC_BTNOK, &CPhoneIncomingCallForm::OnBnClickedBtnok)
	ON_BN_CLICKED(IDC_BTNCANCEL, &CPhoneIncomingCallForm::OnBnClickedBtncancel)
END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCallForm::OnVaxInit(CVaxVoIPDlg* pMainDlg)
{
	if(m_bCreatedWnd)
		return;
	
	m_pMainDlg = pMainDlg;
	
	m_bCreatedWnd = Create(IDD, pMainDlg); 
	ShowWindow(SW_HIDE);
}

void CPhoneIncomingCallForm::OnVaxUnInit()
{
	
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCallForm::OnRingToneStarted(LPCTSTR sCallId)
{   
	int nTabIndex = m_pMainDlg->GetActiveIndex();

    if(nTabIndex != PHONE_TAB_PAGE_INDEX)
    {
		ShowWindow(SW_SHOW);
    }

	if(m_objListCallId.Find(sCallId) == NULL)
		m_objListCallId.AddTail(sCallId);
}

void CPhoneIncomingCallForm::OnRingToneEnded(LPCTSTR sCallId)
{
	POSITION Pos = m_objListCallId.Find(sCallId);
	if(Pos == NULL) return;

	m_objListCallId.RemoveAt(Pos);
		
	if(m_objListCallId.GetCount() <= 0)
	{
		ShowWindow(SW_HIDE);
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCallForm::OnBnClickedBtnok()
{
	ShowWindow(SW_HIDE);
	m_pMainDlg->SetActivePage(PHONE_TAB_PAGE_INDEX);
}

void CPhoneIncomingCallForm::OnBnClickedBtncancel()
{
	ShowWindow(SW_HIDE);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////