// PhoneDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "MainPhoneDlg.h"
#include "afxdialogex.h"
#include "VaxSIPUserAgentLibEx.h"
#include "VaxVoIPDlg.h"
#include "StorePhoneNo.h"

#define PHONE_DLG_TIMER_GENERAL         200

IMPLEMENT_DYNAMIC(CMainPhoneDlg, CPropertyPage)

CMainPhoneDlg::CMainPhoneDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent, CVaxVoIPDlg* pMainDlg): CPropertyPage(CMainPhoneDlg::IDD)
{
    m_psp.dwFlags &= ~PSP_HASHELP; 
	
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	m_pMainDlg = pMainDlg;
	
	m_bCheckPlayDialTone = TRUE;
	m_bCheckPlayRingTone = TRUE;

	m_bCheckLeftSpkListen = TRUE;
	m_bCheckRightSpkListen = TRUE;

	m_bCheckAllowListenConf = TRUE;
	m_bCheckAllowSpeakConf = TRUE;

	m_bCheckDonotDisturb = FALSE;
	m_bCheckMuteLineSPK = FALSE;
	m_bCheckMuteLineMIC = FALSE;

    m_sEditForwardCallPhoneNo = "";
	m_bCheckForwardCall  = FALSE;
	m_sEditDialPhoneNo = "";
	m_bCheckDetectAMD = FALSE;
		
	m_sEditTransferCall = "";
	m_sEditFileRecord = "";
    m_sEditFileWave = "";
    m_bCheckPlayWaveListen = FALSE;
	
	m_bCheckMuteSPK = FALSE;
    m_bCheckMuteMIC = FALSE;
		
	CPhoneVoice::m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	CPhoneLineStatus::m_pVaxUserAgentSIP = pVaxSIPUserAgent;

	CPhoneIncomingCall::m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	CPhoneIncomingCall::m_pMainDlg = pMainDlg;

	CPhoneTone::m_pVaxUserAgentSIP = pVaxSIPUserAgent;

	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana"); 
}

CMainPhoneDlg::~CMainPhoneDlg()
{
	
}

void CMainPhoneDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_PLAY_TONE, m_bCheckPlayDialTone);
	DDX_Check(pDX, IDC_CHECK_PLAY_RING_TONE, m_bCheckPlayRingTone);

	DDX_Control(pDX, IDC_COMBO_LINE_A, m_ctrlComboConsultLineA);
	DDX_Control(pDX, IDC_COMBO_LINE_B, m_ctrlComboConsultLineB);
	DDX_Check(pDX, IDC_CHECK_LEFT_SPEAKER, m_bCheckLeftSpkListen);
	DDX_Check(pDX, IDC_CHECK_RIGHT_SPK, m_bCheckRightSpkListen);
	DDX_Check(pDX, IDC_CHECK_ALLOWLISTEN_CONFERENCE, m_bCheckAllowListenConf);
	DDX_Check(pDX, IDC_CHECK_ALLOW_TO_SPEAK_CONFERENCE, m_bCheckAllowSpeakConf);
	DDX_Check(pDX, IDC_CHECK_MUTE_LINESPK, m_bCheckMuteLineSPK);
	DDX_Check(pDX, IDC_CHECK_MUTE_LINEMIC, m_bCheckMuteLineMIC);
	DDX_Text(pDX, IDC_EDIT_CALLFORWORD_NUMBER, m_sEditForwardCallPhoneNo);
	DDX_Check(pDX, IDC_CHECK_CALL_FORWARDING, m_bCheckForwardCall);
	DDX_Text(pDX, IDC_EDIT_DIAL_PHONE_NO, m_sEditDialPhoneNo);
	DDX_Control(pDX, IDC_LIST_STATUS_LOG, m_ctrListStatusLog);
	DDX_Check(pDX, IDC_CHECK_ANSWERING_MACHINE_DETECT, m_bCheckDetectAMD);
	DDX_Control(pDX, IDC_LIST_INCOMINGCALLS, m_ctrlListIncomingCalls);
	DDX_Control(pDX, IDC_SLIDER_SPEAKER, m_ctrlSliderSpkVol);
	DDX_Control(pDX, IDC_SLIDER_MICROPHONE, m_ctrlSliderMicVol);

	DDX_Control(pDX, IDC_PROGRESS_SPEAKER, m_ctrlProgressSpk);
	DDX_Control(pDX, IDC_PROGRESS_MICROPHONE, m_ctrlProgressMic);
		
	DDX_Text(pDX, IDC_EDIT_BLIND_TRANSFER, m_sEditTransferCall);
	DDX_Text(pDX, IDC_EDIT_RECORD_FILE_NAME, m_sEditFileRecord);
	DDX_Text(pDX, IDC_EDIT_FILE_TO_PLAY, m_sEditFileWave);
	DDX_Check(pDX, IDC_CHECK_WAVELISTEN, m_bCheckPlayWaveListen);

	DDX_Check(pDX, IDC_CHECK_SPEKER_MUTE, m_bCheckMuteSPK);
	DDX_Check(pDX, IDC_CHECK_MICROPHONE_MUTE, m_bCheckMuteMIC);
	DDX_Control(pDX, IDC_LIST_LINES, m_ctrlListBoxLines);

	GetDlgItem(IDC_GROUP_STATUS_LOG)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_ANSWERING_MACHINE)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_LINES)->SetFont( &m_objFont);

	GetDlgItem(IDC_GROUP_CALLFORWORD)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_VOLUME_SETTING)->SetFont( &m_objFont);

	GetDlgItem(IDC_GROUP_VOLUME)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_INCOMINGCALLS)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_CONSULT_TRANFER)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_PLAYWAV)->SetFont( &m_objFont);

	GetDlgItem(IDC_GROUP_MULTI_CALL_CONFRENCE)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_BLIND_TRANSFER)->SetFont( &m_objFont);
	GetDlgItem(IDC_GROUP_RECORDCALL)->SetFont( &m_objFont);

	DDX_Control(pDX, IDC_COMBO_DIAL_CALL_SECURE_MEDIA, m_ctrlComboDialCallSecureMediaSRTP);
	DDX_Control(pDX, IDC_COMBO_ACCEPT_CALL_SECURE_MEDIA, m_ctrlComboAcceptCallSecureMediaSRTP);
	DDX_Control(pDX, IDC_COMBO_VOICE_CHANGER, m_ctrlComboVoiceChanger);

	GetDlgItem(IDC_GROUP_VOICE_CHANGER)->SetFont( &m_objFont);
	DDX_Check(pDX, IDC_CHECK_DO_NOT_DISTURB, m_bCheckDonotDisturb);
	DDX_Control(pDX, IDC_BTN_DIAL, m_ctrlBtnDial);
	DDX_Control(pDX, IDC_BTN_HOLD, m_ctrlBtnHold);
	DDX_Control(pDX, IDC_BTN_RECORD_START, m_ctrlBtnStartRecording);
}


BEGIN_MESSAGE_MAP(CMainPhoneDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_1, &CMainPhoneDlg::OnBtnClicked1)
	ON_BN_CLICKED(IDC_BTN_2, &CMainPhoneDlg::OnBtnClicked2)
	ON_BN_CLICKED(IDC_BTN_3, &CMainPhoneDlg::OnBtnClicked3)
	ON_BN_CLICKED(IDC_BTN_4, &CMainPhoneDlg::OnBtnClicked4)
	ON_BN_CLICKED(IDC_BTN_5, &CMainPhoneDlg::OnBtnClicked5)
	ON_BN_CLICKED(IDC_BTN_6, &CMainPhoneDlg::OnBtnClicked6)
	ON_BN_CLICKED(IDC_BTN_7, &CMainPhoneDlg::OnBtnClicked7)
	ON_BN_CLICKED(IDC_BTN_8, &CMainPhoneDlg::OnBtnClicked8)
	ON_BN_CLICKED(IDC_BTN_9, &CMainPhoneDlg::OnBtnClicked9)
	ON_BN_CLICKED(IDC_BTN_ZERO, &CMainPhoneDlg::OnBtnClicked0)
	ON_BN_CLICKED(IDC_BTN_STAR, &CMainPhoneDlg::OnBtnClickedStar)
	ON_BN_CLICKED(IDC_BTN_HASH, &CMainPhoneDlg::OnBtnClickedHash)
	ON_BN_CLICKED(IDC_BTN_DIAL, &CMainPhoneDlg::OnBtnClickedDial)
	
	ON_BN_CLICKED(IDC_BTN_ACCEPTCALL, &CMainPhoneDlg::OnBtnClickedAcceptCall)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BTN_PHONE_CLEAR, &CMainPhoneDlg::OnBtnClickedClear)
	ON_BN_CLICKED(IDC_BTN_REJECTCALL, &CMainPhoneDlg::OnBtnClickedRejectCall)
	ON_BN_CLICKED(IDC_BTN_TRANSFERCALL, &CMainPhoneDlg::OnBtnClickedTransferCall)
	ON_BN_CLICKED(IDC_BTN_JOIN_BOTH_LINES, &CMainPhoneDlg::OnBtnClickedJoinBothLines)
	
	ON_BN_CLICKED(IDC_BTN_RESET, &CMainPhoneDlg::OnBtnClickedReset)

	ON_BN_CLICKED(IDC_BTN_PLAY_OPEN, &CMainPhoneDlg::OnBtnClickedPlayOpen)
	ON_BN_CLICKED(IDC_BTN_PLAY_REWIND, &CMainPhoneDlg::OnBtnClickedPlayRewind)
	ON_BN_CLICKED(IDC_BTN_PLAY_FORWARD, &CMainPhoneDlg::OnBtnClickedPlayForward)
	ON_BN_CLICKED(IDC_BTN_PLAY_START, &CMainPhoneDlg::OnBtnClickedPlayStart)
	ON_BN_CLICKED(IDC_BTN_PLAY_PAUSE, &CMainPhoneDlg::OnBtnClickedPlayPause)
	ON_BN_CLICKED(IDC_BTN_PLAY_STOP, &CMainPhoneDlg::OnBtnClickedPlayStop)

	ON_BN_CLICKED(IDC_CHECK_CALL_FORWARDING, &CMainPhoneDlg::OnCheckForward_CheckChanged)
		
	ON_BN_CLICKED(IDC_CHECK_MUTE_LINESPK, &CMainPhoneDlg::OnCheckMuteLineSPK_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_LEFT_SPEAKER, &CMainPhoneDlg::OnCheckLeftSPK_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_MUTE_LINEMIC, &CMainPhoneDlg::OnCheckMuteLineMIC_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_RIGHT_SPK, &CMainPhoneDlg::OnCheckRightSPK_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_ALLOWLISTEN_CONFERENCE, &CMainPhoneDlg::OnCheckAllowListenConference_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_ALLOW_TO_SPEAK_CONFERENCE, &CMainPhoneDlg::OnCheckAllowSpeakConference_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_SPEKER_MUTE, &CMainPhoneDlg::OnCheckSpeakerMute_CheckChanged)
	ON_BN_CLICKED(IDC_CHECK_MICROPHONE_MUTE, &CMainPhoneDlg::OnCheckMicrophoneMute_CheckChanged)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_LINES, &CMainPhoneDlg::OnLvnItemchangedListlines)
	ON_BN_CLICKED(IDC_CHECK_PLAY_RING_TONE, &CMainPhoneDlg::OnBnClickedCheckPlayRingTone)
	ON_BN_CLICKED(IDC_CHECK_PLAY_DIAL_TONE, &CMainPhoneDlg::OnBnClickedCheckPlayDialTone)
			
	ON_CBN_SELCHANGE(IDC_COMBO_VOICE_CHANGER, &CMainPhoneDlg::OnCbnSelchangeComboVoiceChanger)
	ON_BN_CLICKED(IDC_CHECK_DO_NOT_DISTURB, &CMainPhoneDlg::OnBnClickedCheckDoNotDisturb)

	ON_BN_CLICKED(IDC_BTN_HOLD, &CMainPhoneDlg::OnBnClickedBtnHold)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_BTN_RECORD_START, &CMainPhoneDlg::OnBnClickedBtnRecordStart)
END_MESSAGE_MAP()


BOOL CMainPhoneDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlListBoxLines.SetExtendedStyle(m_ctrlListBoxLines.GetExtendedStyle()|LVS_EX_FULLROWSELECT| LVS_NOCOLUMNHEADER); 
	m_ctrlListBoxLines.InsertColumn(0, "Lines List", 0, 218);
	
	CPhoneTone::ActivateRingTone(m_bCheckPlayRingTone);
	CPhoneIncomingCall::SetListIncomingCall(&m_ctrlListIncomingCalls);
	
	CStorePhoneNo::GetPhoneNo(m_sEditDialPhoneNo);
	UpdateData(FALSE);

	return TRUE;
}

void CMainPhoneDlg::FillComboBoxes(int nTotalLines)
{
	m_ctrlComboConsultLineA.ResetContent();
	m_ctrlComboConsultLineB.ResetContent();

	m_ctrlComboDialCallSecureMediaSRTP.ResetContent();
	m_ctrlComboDialCallSecureMediaSRTP.InsertString(0, "Secure Media None");
	m_ctrlComboDialCallSecureMediaSRTP.InsertString(1, "Secure Media Forced");
	m_ctrlComboDialCallSecureMediaSRTP.SetCurSel(0);

	m_ctrlComboAcceptCallSecureMediaSRTP.ResetContent();
	m_ctrlComboAcceptCallSecureMediaSRTP.InsertString(0, "Secure Media Auto");
	m_ctrlComboAcceptCallSecureMediaSRTP.InsertString(1, "Secure Media None");
	m_ctrlComboAcceptCallSecureMediaSRTP.InsertString(2, "Secure Media Forced");
	m_ctrlComboAcceptCallSecureMediaSRTP.SetCurSel(0);

	m_ctrlComboVoiceChanger.ResetContent();
	m_ctrlComboVoiceChanger.InsertString(0, "Disable");
	m_ctrlComboVoiceChanger.InsertString(1, "Grandpa drunk");
	m_ctrlComboVoiceChanger.InsertString(2, "Teen boy");
	m_ctrlComboVoiceChanger.InsertString(3, "Household robot");
	m_ctrlComboVoiceChanger.InsertString(4, "Helium inhaled");
	m_ctrlComboVoiceChanger.InsertString(5, "Chipmunk");
	m_ctrlComboVoiceChanger.SetCurSel(0);

	CString sLineNo;

    for (int nLineNo = 0; nLineNo < nTotalLines; nLineNo++)
    {
		sLineNo.Format("Line-%d", nLineNo + 1); 

		m_ctrlComboConsultLineA.InsertString(nLineNo, sLineNo);
		m_ctrlComboConsultLineB.InsertString(nLineNo, sLineNo);
    }
}

void CMainPhoneDlg::OnVaxOnline()
{
    m_bCheckLeftSpkListen = TRUE;
	m_bCheckRightSpkListen = TRUE;

	m_bCheckAllowListenConf = TRUE;
	m_bCheckAllowSpeakConf = TRUE;

	m_bCheckMuteLineSPK = FALSE;
	m_bCheckMuteLineMIC = FALSE;

	m_bCheckPlayDialTone = TRUE;
	m_bCheckPlayRingTone = TRUE;
		
	m_sEditForwardCallPhoneNo = "";
	m_bCheckForwardCall = FALSE;
		
	m_bCheckDetectAMD = FALSE;
	m_bCheckPlayWaveListen = FALSE;

	m_bCheckMuteSPK = FALSE;
	m_bCheckMuteMIC = FALSE;
	
	UpdateData(FALSE);

	int nTotalLines = m_pVaxUserAgentSIP->GetTotalLine();

	FillComboBoxes(nTotalLines);
	FillListLines(nTotalLines); 

	CPhoneVoice::OnVaxInit(nTotalLines);
	CPhoneLineStatus::OnVaxInit(nTotalLines);

	CPhoneIncomingCall::OnVaxInit();
	CPhoneTone::OnVaxInit(m_bCheckPlayDialTone, m_bCheckPlayRingTone);
			
	SetTimer(PHONE_DLG_TIMER_GENERAL, 2000, NULL);

	m_ctrlSliderSpkVol.SetRangeMin(0);
	m_ctrlSliderSpkVol.SetRangeMax(200);

	m_ctrlSliderMicVol.SetRangeMin(0);
	m_ctrlSliderMicVol.SetRangeMax(200);

	m_ctrlSliderMicVol.SetPos(100);
	m_ctrlSliderSpkVol.SetPos(100);
}

void CMainPhoneDlg::OnVaxOffline()
{
	KillTimer(PHONE_DLG_TIMER_GENERAL);

    CPhoneVoice::OnVaxUnInit();
	CPhoneLineStatus::OnVaxUnInit();
	CPhoneIncomingCall::OnVaxUnInit();

	m_ctrlListBoxLines.DeleteAllItems();
	m_ctrListStatusLog.ResetContent();
	m_ctrlListIncomingCalls.ResetStringContent();

	m_ctrlComboConsultLineA.ResetContent();
	m_ctrlComboConsultLineB.ResetContent();

	m_ctrlSliderMicVol.SetPos(0);
	m_ctrlSliderMicVol.SetPos(0);
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBtnClicked1()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "1";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "1");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked2()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "2";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "2");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked3()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "3";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "3");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked4()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "4";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "4");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked5()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "5";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "5");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked6()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "6";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "6");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked7()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "7";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "7");
	UpdateData(FALSE);
}

void CMainPhoneDlg::OnBtnClicked8()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "8";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "8");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked9()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "9";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "9");
	UpdateData(FALSE);
}
void CMainPhoneDlg::OnBtnClicked0()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "0";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "0");
	UpdateData(FALSE);
}

void CMainPhoneDlg::OnBtnClickedStar()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "*";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "*");
	UpdateData(FALSE);
}

void CMainPhoneDlg::OnBtnClickedHash()
{
	UpdateData(TRUE);
	m_sEditDialPhoneNo += "#";
	m_pVaxUserAgentSIP->DigitDTMF(m_ctrlListBoxLines.GetCurSelItem(), "#");
	UpdateData(FALSE);
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBtnClickedDial()
{
	UpdateData(TRUE);

	if(m_sEditDialPhoneNo.IsEmpty())
		return;
    
	CString sBtnText;
	m_ctrlBtnDial.GetWindowText(sBtnText);

	int nLineNo = 0;

	if(sBtnText == "Hangup")
	{
		nLineNo = m_ctrlListBoxLines.GetCurSelItem();
		if (nLineNo == -1) return;

		m_pVaxUserAgentSIP->DisconnectCall(nLineNo);

		m_ctrlBtnDial.SetWindowText("Dial");
		m_ctrlBtnHold.SetWindowText("Hold");

		return;
	}

    nLineNo = FindLine();

    if(nLineNo == -1)
    {
		MessageBox("No line is free.", "VaxVoIP SDK", MB_OK);
        return;
    }
		
	AdjustSecureMediaSRTP(TRUE);

	m_pVaxUserAgentSIP->DetectAMD(m_bCheckDetectAMD);

    if(!m_pVaxUserAgentSIP->DialCall(nLineNo, "", "", m_sEditDialPhoneNo))
		return; 

	m_ctrlListBoxLines.SetItemStateSel(nLineNo);
		
	CStorePhoneNo::AddPhoneNo(m_sEditDialPhoneNo);
	m_ctrlBtnDial.SetWindowText("Hangup");
}

void CMainPhoneDlg::OnBnClickedBtnHold()
{
	int nLineNo = 0;

	CString sBtnText;
	m_ctrlBtnHold.GetWindowText(sBtnText);

	if(sBtnText == "UnHold")
	{
		nLineNo = m_ctrlListBoxLines.GetCurSelItem();
		if (nLineNo == -1) return;

		m_pVaxUserAgentSIP->UnHoldLine(nLineNo);
		m_ctrlBtnHold.SetWindowText("Hold");

		return;
	}

	if (!m_pVaxUserAgentSIP->HoldLine(nLineNo))
		return;

	m_ctrlBtnHold.SetWindowText("UnHold");
}

int CMainPhoneDlg::FindLine()
{
    int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	if (nLineNo == -1) return -1;

    if (m_pVaxUserAgentSIP->IsLineBusy(nLineNo) == false)
		return nLineNo;
            
    int nTotalLine = m_pVaxUserAgentSIP->GetTotalLine();
	
	for(nLineNo = 0; nLineNo < nTotalLine; nLineNo++)
    {
        if (m_pVaxUserAgentSIP->IsLineBusy(nLineNo) == false)
            return nLineNo;
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::FillListLines(int nTotalLines)
{
	m_ctrlListBoxLines.DeleteAllItems();

	for (int nLineNo = 0; nLineNo < nTotalLines; nLineNo++)
	{
		m_ctrlListBoxLines.InsertItemRow(nLineNo, "");
		ShowListBoxLineStatus(nLineNo, "free");
	}
}

void CMainPhoneDlg::AddToStatusLog(LPCTSTR sStatusLog)
{
	m_ctrListStatusLog.AddString(sStatusLog);     
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBtnClickedAcceptCall()
{
    int nLineNo = FindLine();

    if(nLineNo == -1)
    {
		MessageBox("No line is free.", "VaxVoIP SDK", MB_OK);
        return;
    }
		
	AdjustSecureMediaSRTP(FALSE);

	if(!CPhoneIncomingCall::AcceptCall(nLineNo))
		return;

	m_ctrlListBoxLines.SetItemStateSel(nLineNo);
	m_pVaxUserAgentSIP->DetectAMD(m_bCheckDetectAMD);
}

void CMainPhoneDlg::OnBtnClickedRejectCall()
{
	CPhoneIncomingCall::RejectCall();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnDigitDTMF(int nLineNo, LPCTSTR sDigit)
{
	CString sStatus;
	sStatus.Format("Line-%d: Key-pressed: %s", nLineNo + 1, sDigit);

    AddToStatusLog(sStatus);
}

void CMainPhoneDlg::OnPlayWaveDone(int nLineNo)
{
	CString sStatus;
	sStatus.Format("Line-%d: Play wave done.", nLineNo + 1);
	
	AddToStatusLog(sStatus);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnDialCallStarted(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo)
{
	ShowListBoxLineStatus(nLineNo, "CONNECTING");
	
	CString sStatus;
	sStatus.Format("Line-%d: Dialing.", nLineNo + 1);
	
	AddToStatusLog(sStatus);
}

void CMainPhoneDlg::OnDialingCall(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	CString sStatus;
	sStatus.Format("Line-%d: Response: %s", nLineNo + 1 , sReasonPhrase); 
	
	AddToStatusLog(sStatus);
}

void CMainPhoneDlg::OnDialCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	CString sStatus;
	sStatus.Format("Line-%d: Response: %s", nLineNo + 1 , sReasonPhrase); 
	
	AddToStatusLog(sStatus);
}

void CMainPhoneDlg::OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort)
{
	CString sStatus;
	sStatus.Format("Line-%d: Success to connect.", nLineNo + 1);
    
	AddToStatusLog(sStatus);
}

void CMainPhoneDlg::OnHungupCall(int nLineNo)
{
	m_ctrlBtnDial.SetWindowText("Dial");
	m_ctrlBtnHold.SetWindowText("Hold");
	
	CString sStatus;
	sStatus.Format("Line-%d: Hung up.", nLineNo + 1);
	AddToStatusLog(sStatus);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnIncomingCallStarted(LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId)
{
	CPhoneIncomingCall::OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
}

void CMainPhoneDlg::OnIncomingCallEnded(LPCTSTR sCallId)
{
	CPhoneIncomingCall::OnIncomingCallEnded(sCallId);
}

void CMainPhoneDlg::OnRingToneStarted(LPCTSTR sCallId)
{   
   CPhoneTone::OnRingToneStarted(sCallId);
   CPhoneIncomingCall::OnRingToneStarted(sCallId);
}

void CMainPhoneDlg::OnRingToneEnded(LPCTSTR sCallId)
{
	CPhoneTone::OnRingToneEnded(sCallId);
	CPhoneIncomingCall::OnRingToneEnded(sCallId);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnTransferCallAccepted(int nLineNo)
{
	CString sStatus;
	sStatus.Format("Line-%d: Transfer accepted.", nLineNo + 1);
    AddToStatusLog( sStatus);
}

void CMainPhoneDlg::OnTransferCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	CString sStatus;
	sStatus.Format("Line-%d: Transfer Failed.", nLineNo + 1);
    AddToStatusLog( sStatus);
}

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnNetworkReachability(BOOL bAvailable)
{
	if(bAvailable)
		AddToStatusLog("Network is available");
	else
		AddToStatusLog("Network is not available");
}

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnAudioDeviceMicVU(int nLevelVU)
{
	m_ctrlProgressMic.SetPos(nLevelVU);
}

void CMainPhoneDlg::OnAudioDeviceSpkVU(int nLevelVU)
{
	m_ctrlProgressSpk.SetPos(nLevelVU);
}

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnAudioSessionLost(int nLineNo)
{
            
}

void CMainPhoneDlg::OnMsgNOTIFY(LPCTSTR sMsg)
{
            
}

void CMainPhoneDlg::OnDetectedAMD(int nLineNo, BOOL bIsHuman)
{

}

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnSuccessToHold(int nLineNo)
{
            
}

void CMainPhoneDlg::OnTryingToHold(int nLineNo)
{
            
}

void CMainPhoneDlg::OnFailToHold(int nLineNo)
{
            
}

void CMainPhoneDlg::OnSuccessToUnHold(int nLineNo)
{
            
}

void CMainPhoneDlg::OnTryingToUnHold(int nLineNo)
{
            
}

void CMainPhoneDlg::OnFailToUnHold(int nLineNo)
{
            
}

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

BOOL CMainPhoneDlg::FindCallId(LPCTSTR sCallId)
{
	for(int nListIndex = 0; nListIndex < m_ctrlListIncomingCalls.GetCount(); nListIndex++)
    {
		CString sCallIdStored = m_ctrlListIncomingCalls.GetStringData(nListIndex);

        if(sCallIdStored == sCallId)
            return true;
    }
            
    return false;
}
        
void CMainPhoneDlg::RemoveCallIdFromList(LPCTSTR sCallId)
{
    for (int nListIndex = 0; nListIndex < m_ctrlListIncomingCalls.GetCount(); nListIndex++)
    {
		CString sCallIdStored = m_ctrlListIncomingCalls.GetStringData(nListIndex);

        if (sCallIdStored == sCallId)
        {
			m_ctrlListIncomingCalls.DeleteStringData(nListIndex);
            break;
        }
    }
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::ShowListBoxLineStatus(int nLineNo, LPCTSTR sStatus)
{
	CString sLineStatus = m_ctrlListBoxLines.GetItemText(nLineNo, 0);

	if (sLineStatus.Find(sStatus) == -1)
	{
		CString sLineText;
		sLineText.Format("Line-%d : %s", nLineNo + 1, sStatus);

		m_ctrlListBoxLines.SetItemText(nLineNo, 0, sLineText);
	}
}

void CMainPhoneDlg::OnChangeLineStatus(int nLineNo, LPCTSTR sStatus)
{
	ShowListBoxLineStatus(nLineNo, sStatus);
}

void CMainPhoneDlg::OnTimer(UINT_PTR nIDEvent)
{
	if(PHONE_DLG_TIMER_GENERAL == nIDEvent)
	{
		int nSelectedLineNo = m_ctrlListBoxLines.GetCurSelItem();
		
		CPhoneLineStatus::OnLineStatusTick(nSelectedLineNo);
		UpdateBtnStatus();
	}

	CPropertyPage::OnTimer(nIDEvent);
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBtnClickedClear()
{
   m_ctrListStatusLog.ResetContent();
}

void CMainPhoneDlg::OnBtnClickedTransferCall()
{
	UpdateData(TRUE);
	
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	m_pVaxUserAgentSIP->TransferCallBlind(nLineNo, m_sEditTransferCall); 
}

void CMainPhoneDlg::OnBtnClickedJoinBothLines()
{
	int nLineA = m_ctrlComboConsultLineA.GetCurSel();
	int nLineB = m_ctrlComboConsultLineB.GetCurSel();

	if (m_ctrlComboConsultLineA.GetCurSel() == m_ctrlComboConsultLineB.GetCurSel())
	{
		MessageBox("Please select two different lines.", "VaxVoIP SIP SDK");
		return;
	}

	m_pVaxUserAgentSIP->TransferCallConsult(m_ctrlComboConsultLineA.GetCurSel(), m_ctrlComboConsultLineB.GetCurSel());
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBtnClickedPlayOpen()
{
	UpdateData(TRUE);
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	BOOL bResult = m_pVaxUserAgentSIP->PlayWaveOpen(nLineNo, m_sEditFileWave);

    if(!bResult)
	    return;
}

void CMainPhoneDlg::OnBtnClickedPlayRewind()
{
	UpdateData(TRUE);
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	m_pVaxUserAgentSIP->PlayWaveSkipTo(nLineNo, m_pVaxUserAgentSIP->PlayWavePosition(nLineNo) - 1000);    
}

void CMainPhoneDlg::OnBtnClickedPlayForward()
{
	UpdateData(TRUE);

	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	m_pVaxUserAgentSIP->PlayWaveSkipTo(nLineNo, m_pVaxUserAgentSIP->PlayWavePosition(nLineNo) + 1000); 
}

void CMainPhoneDlg::OnBtnClickedPlayStart()
{
	UpdateData(TRUE);

	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
    m_pVaxUserAgentSIP->PlayWaveStart(nLineNo, m_bCheckPlayWaveListen);   
}

void CMainPhoneDlg::OnBtnClickedPlayPause()
{
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	m_pVaxUserAgentSIP->PlayWavePause(nLineNo);   
}

void CMainPhoneDlg::OnBtnClickedPlayStop()
{
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	m_pVaxUserAgentSIP->PlayWaveStop(nLineNo);  
}

void CMainPhoneDlg::OnCheckForward_CheckChanged()
{
	UpdateData(TRUE);

	if (m_sEditForwardCallPhoneNo.IsEmpty() && m_bCheckForwardCall) 
	{
		MessageBox("Please enter a phone number.");
		m_bCheckForwardCall = FALSE;
		UpdateData(FALSE);
		return;
	}

	m_pVaxUserAgentSIP->ForwardCall(m_bCheckForwardCall, m_sEditForwardCallPhoneNo);
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBtnClickedReset()
{
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

	m_pVaxUserAgentSIP->ResetRecording(nLineNo);
}

void CMainPhoneDlg::OnBnClickedBtnRecordStart()
{
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	if (nLineNo == -1) return;
		
	UpdateData();

	CString sBtnText;
	m_ctrlBtnStartRecording.GetWindowText(sBtnText);

	if(sBtnText == "Start")
	{
		if(m_sEditFileRecord.IsEmpty())
		{
			MessageBox("File name is not valid.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			return;
		}

		m_pVaxUserAgentSIP->StartRecording(nLineNo, m_sEditFileRecord, 2, 0);
		m_ctrlBtnStartRecording.SetWindowText("Stop");
	}
	else
	{
		m_pVaxUserAgentSIP->StopRecording(nLineNo);
		m_ctrlBtnStartRecording.SetWindowText("Start");
	}
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnCheckMuteLineSPK_CheckChanged()
{
	UpdateData(TRUE);
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	
    CPhoneVoice::MuteLineSpk(nLineNo, m_bCheckMuteLineSPK);
}

void CMainPhoneDlg::OnCheckMuteLineMIC_CheckChanged()
{
	UpdateData(TRUE);
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
   
   CPhoneVoice::MuteLineMic(nLineNo, m_bCheckMuteLineMIC);
}

void CMainPhoneDlg::OnCheckLeftSPK_CheckChanged()
{
	UpdateData(TRUE);
    int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	
    if (m_bCheckLeftSpkListen == FALSE && m_bCheckRightSpkListen == FALSE)
        m_bCheckRightSpkListen = TRUE;

	CPhoneVoice::LineVoiceChannelSpk(nLineNo, m_bCheckLeftSpkListen, m_bCheckRightSpkListen);
	UpdateData(FALSE);
}

void CMainPhoneDlg::OnCheckRightSPK_CheckChanged()
{
	UpdateData(TRUE);
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	
    if (m_bCheckLeftSpkListen == FALSE && m_bCheckRightSpkListen == FALSE)
        m_bCheckLeftSpkListen = TRUE;

    CPhoneVoice::LineVoiceChannelSpk(nLineNo, m_bCheckLeftSpkListen, m_bCheckRightSpkListen);
	UpdateData(FALSE);
}

void CMainPhoneDlg::OnCheckAllowListenConference_CheckChanged()
{
	UpdateData(TRUE);
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	
	CPhoneVoice::ConfAllowLine(nLineNo, m_bCheckAllowListenConf, m_bCheckAllowSpeakConf);
}

void CMainPhoneDlg::OnCheckAllowSpeakConference_CheckChanged()
{
	UpdateData(TRUE);
    int nLineNo = m_ctrlListBoxLines.GetCurSelItem();

    CPhoneVoice::ConfAllowLine(nLineNo, m_bCheckAllowListenConf, m_bCheckAllowSpeakConf);
}

void CMainPhoneDlg::OnCheckSpeakerMute_CheckChanged()
{
	UpdateData(TRUE);
	m_pVaxUserAgentSIP->MuteSpk(m_bCheckMuteSPK);    
}

void CMainPhoneDlg::OnCheckMicrophoneMute_CheckChanged()
{
	UpdateData(TRUE);
	m_pVaxUserAgentSIP->MuteMic(m_bCheckMuteMIC);
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnLvnItemchangedListlines(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	if (nLineNo == -1) return;

	CPhoneVoice::LineSelected(nLineNo);
	UpdateBtnStatus();
		
	*pResult = 0;
}

void CMainPhoneDlg::OnBnClickedCheckPlayRingTone()
{
	UpdateData(TRUE);
	CPhoneTone::ActivateRingTone(m_bCheckPlayRingTone);
}

void CMainPhoneDlg::OnBnClickedCheckPlayDialTone()
{
	UpdateData(TRUE);
	CPhoneTone::ActivateDialTone(m_bCheckPlayDialTone);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnChangeVoiceSetting(BOOL bMuteLineMIC, BOOL bMuteLineSPK, BOOL bAllowListenConf, BOOL bAllowSpeakConf, BOOL bListenLeftSpk, BOOL bListenRightSpk)
{
	m_bCheckMuteLineMIC = bMuteLineMIC;
	m_bCheckMuteLineSPK = bMuteLineSPK;

	m_bCheckAllowListenConf = bAllowListenConf;
	m_bCheckAllowSpeakConf = bAllowSpeakConf; 

	m_bCheckLeftSpkListen = bListenLeftSpk;
	m_bCheckRightSpkListen = bListenRightSpk;

	UpdateData(FALSE);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::AdjustSecureMediaSRTP(BOOL bDialCall)
{
	int nSecureIndex = -1;

	if(bDialCall)
	{
		nSecureIndex = m_ctrlComboDialCallSecureMediaSRTP.GetCurSel();

		if(nSecureIndex == -1 || nSecureIndex == 0)
		{
			m_pVaxUserAgentSIP->CryptoMediaNONE(FALSE);
			return;
		}
				
		if(nSecureIndex == 1)
		{
			m_pVaxUserAgentSIP->CryptoMediaSDP(TRUE);
			return;
		}

		return;
	}

	nSecureIndex = m_ctrlComboAcceptCallSecureMediaSRTP.GetCurSel();

	if(nSecureIndex == -1 || nSecureIndex == 0)
	{
		m_pVaxUserAgentSIP->CryptoMediaNONE(FALSE);
		return;
	}

	if(nSecureIndex == 1)
	{
		m_pVaxUserAgentSIP->CryptoMediaNONE(TRUE);
		return;
	}

	if(nSecureIndex == 2)
	{
		m_pVaxUserAgentSIP->CryptoMediaSDP(TRUE);
		return;
	}
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnCbnSelchangeComboVoiceChanger()
{
	int nVoiceChangerType = m_ctrlComboVoiceChanger.GetCurSel();
	if(nVoiceChangerType == -1) return;

	switch(nVoiceChangerType)
	{
		case 0:
			m_pVaxUserAgentSIP->VoiceChanger(-1);
		break;

		case 1:
			m_pVaxUserAgentSIP->VoiceChanger(4);
		break;

		case 2:
			m_pVaxUserAgentSIP->VoiceChanger(8);
		break;

		case 3:
			m_pVaxUserAgentSIP->VoiceChanger(12);
		break;

		case 4:
			m_pVaxUserAgentSIP->VoiceChanger(16);
		break;

		case 5:
			m_pVaxUserAgentSIP->VoiceChanger(20);
		break;
	}
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::UpdateBtnStatus()
{
	int nLineNo = m_ctrlListBoxLines.GetCurSelItem();
	if (nLineNo == -1) return;
	
	////////////////////////////////////////////////////////////////////////

	CString sBtnText;
	m_ctrlBtnStartRecording.GetWindowText(sBtnText);

	if (!m_pVaxUserAgentSIP->IsLineRecording(nLineNo) && sBtnText != "Start")
		m_ctrlBtnStartRecording.SetWindowText("Start");

	else if (m_pVaxUserAgentSIP->IsLineRecording(nLineNo) && sBtnText != "Stop")
		m_ctrlBtnStartRecording.SetWindowText("Stop");

	////////////////////////////////////////////////////////////////////////

	m_ctrlBtnDial.GetWindowText(sBtnText);

	if (!m_pVaxUserAgentSIP->IsLineBusy(nLineNo) && sBtnText != "Dial")
		m_ctrlBtnDial.SetWindowText("Dial");

	else if (m_pVaxUserAgentSIP->IsLineBusy(nLineNo) && sBtnText != "Hangup")
		m_ctrlBtnDial.SetWindowText("Hangup");

	////////////////////////////////////////////////////////////////////////

	m_ctrlBtnHold.GetWindowText(sBtnText);

	if (!m_pVaxUserAgentSIP->IsLineHold(nLineNo) && sBtnText != "Hold")
		m_ctrlBtnHold.SetWindowText("Hold");

	else if (m_pVaxUserAgentSIP->IsLineHold(nLineNo) && sBtnText != "UnHold")
		m_ctrlBtnHold.SetWindowText("UnHold");
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnBnClickedCheckDoNotDisturb()
{
	UpdateData(TRUE);

	m_pVaxUserAgentSIP->DonotDisturb(m_bCheckDonotDisturb);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void CMainPhoneDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if(pScrollBar == (CScrollBar*) &m_ctrlSliderSpkVol)
	{		
		// Value range (-100) --- 0 --- (+100)
		
		m_pVaxUserAgentSIP->SetVolumeSpk(m_ctrlSliderSpkVol.GetPos() - 100);
	}

	else if(pScrollBar == (CScrollBar*) &m_ctrlSliderMicVol)
	{
		// Value range (-100) --- 0 --- (+100)

		m_pVaxUserAgentSIP->SetVolumeMic(m_ctrlSliderMicVol.GetPos() - 100);
	}

	__super::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CMainPhoneDlg::OnApply()
{
	return FALSE;
}


