#pragma once

#include"MySheet.h"
#include"resource.h"

class CMainAccountDlg;
class CChatDlg;
class CMainSettingDlg;
class CMainPhoneDlg;
class CVaxSIPUserAgentLibEx;
class CMainVideoDlg;
class CMainAccountRecDlg;
class CMainBusyLampDlg;

class CVaxVoIPDlg : public CMySheet
{
	DECLARE_DYNAMIC(CVaxVoIPDlg);
// Construction
public:
	CVaxVoIPDlg(UINT nIDCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);	// standard constructor
	CVaxVoIPDlg(LPCTSTR pszCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	
	 
// Dialog Data
	enum { IDD = IDD_VAXVOIP_DIALOG};

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

private:

	CMainAccountDlg* m_pAccountDlg;
	CMainPhoneDlg* m_pPhoneDlg;
	CMainVideoDlg* m_pVideoDlg;

	CChatDlg* m_pChatDlg;
	CMainBusyLampDlg* m_pBusyLampDlg;
	
	CMainSettingDlg* m_pSettingDlg;
	CMainAccountRecDlg* m_pRecAccountDlg;

	CFont m_objFont;
private:

 	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;


	//Events to Called of other tabs
public:

	void OnVaxOnline();
	void OnVaxOffline();

	void OnConnectingToRegister();
	void OnTryingToRegister();
    void OnFailToRegister(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToRegister();
	
	void OnConnectingToReRegister();
	void OnTryingToReRegister();
	void OnFailToReRegister(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToReRegister();

	void OnTryingToUnRegister();
	void OnFailToUnRegister();
	void OnSuccessToUnRegister();
	
	void OnDialCallStarted(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	void OnDialingCall(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnDialCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	
	void OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort);
	void OnHungupCall(int nLineNo);

	void OnTransferCallAccepted(int nLineNo);
	void OnTransferCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);

	void OnPlayWaveDone(int nLineNo);
	void OnDigitDTMF(int nLineNo, LPCTSTR sDigit);
	void OnMsgNOTIFY(LPCTSTR sMsg);

	void OnIncomingCallStarted(LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId);
	void OnIncomingCallEnded(LPCTSTR sCallId);
	void OnRingToneStarted(LPCTSTR sCallId);
	void OnRingToneEnded(LPCTSTR sCallId);
		
	void OnAudioSessionLost(int nLineNo);

	void OnChatSubscribeSuccess(LPCTSTR sUserName);
	void OnChatSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);

	void OnChatContactStatus(LPCTSTR sUserName, int nStatusId);
	void OnChatSendMsgTextSuccess(LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue);
	
	void OnChatSendMsgTextFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue);
	void OnChatSendMsgTypingSuccess(LPCTSTR sUserName, UINT64 nUserValue);

	void OnChatSendMsgTypingFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue);
	void OnChatRecvMsgText(LPCTSTR sUserName, LPCTSTR sMsgText);

	void OnChatRecvMsgTypingStart(LPCTSTR sUserName);
	void OnChatRecvMsgTypingStop(LPCTSTR sUserName);
		
	void OnBusyLampSubscribeSuccess(LPCTSTR sUserName);
	void OnBusyLampSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnBusyLampContactStatus(LPCTSTR sUserName, int nStatusId);

	void OnVoiceMailMsg(BOOL bIsMsgWaiting, DWORD dwNewMsgCount, DWORD dwOldMsgCount, DWORD dwNewUrgentMsgCount, DWORD dwOldUrgentMsgCount, LPCTSTR sMsgAccount);
	void OnDetectedAMD(int nLineNo, BOOL bIsHuman);

    void OnSuccessToHold(int nLineNo);
    void OnTryingToHold(int nLineNo);
    void OnFailToHold(int nLineNo);

    void OnSuccessToUnHold(int nLineNo);
    void OnTryingToUnHold(int nLineNo);
    void OnFailToUnHold(int nLineNo);

	void OnVideoRemoteStarted(int nLineNo);
	void OnVideoRemoteEnded(int nLineNo);

	void OnVideoDeviceFrameRGB(int nDeviceId, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);
	void OnVideoRemoteFrameRGB(int nLineNo, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);

	/////////////////////////////////////////////////////////////////////////////////////////
	
	void OnConnectingToRegisterREC();
	void OnTryingToRegisterREC();
	void OnFailToRegisterREC(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToRegisterREC();

	void OnTryingToReRegisterREC();
	void OnFailToReRegisterREC(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToReRegisterREC();
	
	void OnTryingToUnRegisterREC();
	void OnFailToUnRegisterREC();
	void OnSuccessToUnRegisterREC();
		
	void OnDialCallStartedREC(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	void OnDialingCallREC(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnDialCallFailedREC(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnConnectedCallREC(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort);
	void OnHungupCallREC(int nLineNo);

	void OnNetworkReachability(BOOL bAvailable);

	void OnAudioDeviceMicVU(int nLevelVU);
	void OnAudioDeviceSpkVU(int nLevelVU);

	void OnVaxErrorMsg(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode);
	void OnStatusMsgREC(int nLineNo, DWORD dwErrorCode, LPCTSTR sErrorMsg);
	
	virtual BOOL CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, LPVOID lpParam = NULL);
	afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();

};
