#pragma once

#include "afxwin.h"
#include "afxcmn.h"

#include "ListCtrlEx.h"
#include "ListBoxEx.h"

class CVaxSIPUserAgentLibEx;

class CChatDlg : public CPropertyPage
{
	DECLARE_DYNAMIC(CChatDlg)

public:

	CChatDlg(CVaxSIPUserAgentLibEx*);
	virtual ~CChatDlg();

	enum { IDD = IDD_CHAT_DLG };

protected:

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

public:

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();

public:

	void OnVaxOnline();
	void OnVaxOffline();

private:

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;
	CFont m_objFont;

public:

	CComboBox m_ctrlComboMyChatStatus;

private:

	void LoadContactAll();
	void LoadContactMsgAll(LPCTSTR sContactName);

	void UpdateStatusCombo();
	void AddToStatusLog(LPCTSTR sChatLog);

	BOOL GetSelectedContact(CString& sContactName, int* pContactIndex);
	CString GetStatusText(int nStatusId);
		
	void AdjustTypingState();
	
private:

	BOOL m_bTyping;

public:

	void OnChatSubscribeSuccess(LPCTSTR sUserName);
	void OnChatSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);

	void OnChatContactStatus(LPCTSTR sUserName, int nStatusId);
    void OnChatSendMsgTextSuccess(LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue);
    void OnChatSendMsgTextFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue);
    
	void OnChatSendMsgTypingSuccess(LPCTSTR sUserName, UINT64 nUserValue);
    void OnChatSendMsgTypingFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue);
    
	void OnChatRecvMsgText(CString sUserName, CString sMsgText);
    
	void OnChatRecvMsgTypingStart(CString sUserName);
    void OnChatRecvMsgTypingStop();

private:

	CListBoxEx m_ctrlListStatusLog;
	CListBoxEx m_ctrlListMessage;

	CListCtrlEx m_ctrlListContact;
		
	CString m_sEditContactName;
	CString m_sEditSendChatMessage;

public:
	afx_msg void OnBtnClickedAddContact();
	afx_msg void OnBtnClickedRemoveContact();
	afx_msg void OnBtnClickedClearChat();
	afx_msg void OnBtnClickedSendMessage();
	afx_msg void OnBtnClickedClearLog();
	afx_msg void OnTimer(UINT_PTR nIDEvent);

	afx_msg void OnChangeEditMessage();
	afx_msg void ComboMyChatStatus_SelectedIndexChanged();
	afx_msg void OnListClickedContact(NMHDR *pNMHDR, LRESULT *pResult);
};
