#pragma once

#include "ListCtrlEx.h"
#include "ListBoxEx.h"

class CVaxSIPUserAgentLibEx;

// CMainBusyLampDlg dialog

class CMainBusyLampDlg : public CPropertyPage
{
	DECLARE_DYNAMIC(CMainBusyLampDlg)

public:

	CMainBusyLampDlg(CVaxSIPUserAgentLibEx*);
	virtual ~CMainBusyLampDlg();

// Dialog Data
	enum { IDD = IDD_BUSY_LAMP_DLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

private:

	CFont m_objFont;
	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;

	CListBoxEx m_ctrlListStatusLog;
	CListCtrlEx m_ctrlListContact;

	CString m_sEditContactName;

private:
	BOOL OnApply();
	void LoadContactAll();

	BOOL GetSelectedContact(CString& sContactName, int* pContactIndex);
	
	void AddToStatusLog(LPCTSTR sLog);
	CString GetStatusText(int nStatusId);

public:

	void OnVaxOnline();
	void OnVaxOffline();

	void OnBusyLampSubscribeSuccess(LPCTSTR sUserName);
	void OnBusyLampSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnBusyLampContactStatus(LPCTSTR sUserName, int nStatusId);

private:

	afx_msg void OnBnClickedBtnStatusLogClear();
	afx_msg void OnBnClickedBtnAddContact();
	afx_msg void OnBnClickedBtnRemoveContact();

	virtual BOOL OnInitDialog();
};
