// BusyLampDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "MainBusyLampDlg.h"
#include "StoreBusyLamp.h"
#include "afxdialogex.h"
#include "VaxSIPUserAgentLibEx.h"


// CMainBusyLampDlg dialog

IMPLEMENT_DYNAMIC(CMainBusyLampDlg, CPropertyPage)

CMainBusyLampDlg::CMainBusyLampDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent): CPropertyPage(CMainBusyLampDlg::IDD)
{
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana"); 
}

CMainBusyLampDlg::~CMainBusyLampDlg()
{
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CMainBusyLampDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_LIST_STATUS_LOG , m_ctrlListStatusLog);
	DDX_Control(pDX, IDC_LIST_CONTACTS, m_ctrlListContact);
	
	DDX_Text(pDX, IDC_EDIT_CONTACT, m_sEditContactName);
	
	GetDlgItem(IDC_GROUP_CONTACTS)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_STATUS_LOG)->SetFont(&m_objFont);
}

BEGIN_MESSAGE_MAP(CMainBusyLampDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_STATUS_LOG_CLEAR, &CMainBusyLampDlg::OnBnClickedBtnStatusLogClear)
	ON_BN_CLICKED(IDC_BTN_ADD_CONTACT, &CMainBusyLampDlg::OnBnClickedBtnAddContact)
	ON_BN_CLICKED(IDC_BTN_REMOVE_CONTACT, &CMainBusyLampDlg::OnBnClickedBtnRemoveContact)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL CMainBusyLampDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlListContact.InsertColumn(0, "Contact", 0, 80);
	m_ctrlListContact.InsertColumn(1, "Status", 0, 160);

	m_ctrlListContact.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_AUTOSIZECOLUMNS);
		
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CMainBusyLampDlg::LoadContactAll()
{
	m_ctrlListContact.DeleteAllItems();

	CStringList objList;
	CStoreBusyLamp::GetContactAll(objList);

	while(!objList.IsEmpty())
	{
		CString sContactName = objList.RemoveHead();
		
		m_pVaxUserAgentSIP->BusyLampAddContact(sContactName);
		m_ctrlListContact.InsertItemRow(m_ctrlListContact.GetItemCount(), sContactName);
	}

	if(m_ctrlListContact.GetSelectedCount() == 0 && m_ctrlListContact.GetItemCount() != 0)
		m_ctrlListContact.SetItemStateSel(0);
}

void CMainBusyLampDlg::OnVaxOnline()
{
	LoadContactAll();
}

void CMainBusyLampDlg::OnVaxOffline()
{
	m_ctrlListStatusLog.ResetContent();
	m_ctrlListContact.DeleteAllItems();
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CMainBusyLampDlg::OnBnClickedBtnStatusLogClear()
{
	m_ctrlListStatusLog.ResetContent();
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CMainBusyLampDlg::OnBnClickedBtnAddContact()
{
	UpdateData(TRUE);

	BOOL bResult = m_pVaxUserAgentSIP->BusyLampAddContact(m_sEditContactName);

    if (!bResult) 
	{
	    return;
	}

	m_ctrlListContact.InsertItemRow(m_ctrlListContact.GetItemCount(), m_sEditContactName);
	CStoreBusyLamp::AddContact(m_sEditContactName);

    if(m_ctrlListContact.GetSelectedCount() == 0 && m_ctrlListContact.GetItemCount() != 0)
		m_ctrlListContact.SetItemStateSel(0);
	
	m_sEditContactName = "";
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CMainBusyLampDlg::OnBnClickedBtnRemoveContact()
{
	CString sContactName; int nContactIndex;
	if(!GetSelectedContact(sContactName, &nContactIndex)) return;
	
	int nResult = MessageBox("Do you really want to remove this Contact?", "Caution", MB_ICONQUESTION|MB_YESNO);
	if(nResult == IDNO) return;

	m_pVaxUserAgentSIP->BusyLampRemoveContact(sContactName);

	m_ctrlListContact.DeleteItem(nContactIndex);
	CStoreBusyLamp::RemoveContact(sContactName);

	if(m_ctrlListContact.GetSelectedCount() == 0 && m_ctrlListContact.GetItemCount() != 0)
		m_ctrlListContact.SetItemStateSel(0);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL CMainBusyLampDlg::GetSelectedContact(CString& sContactName, int* pContactIndex)
{
	int nIndex = m_ctrlListContact.GetCurSelItem();
	if(nIndex == -1) return FALSE;
	
	if(pContactIndex != NULL)
		*pContactIndex = nIndex;

	sContactName = m_ctrlListContact.GetItemText(nIndex, 0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
                
void CMainBusyLampDlg::AddToStatusLog(LPCTSTR sLog)
{
	m_ctrlListStatusLog.AddString(sLog);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CMainBusyLampDlg::OnBusyLampSubscribeSuccess(LPCTSTR sUserName)
{
	AddToStatusLog("BusyLamp Subscribe " + CString(sUserName) + " Success.");
}

void CMainBusyLampDlg::OnBusyLampSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	AddToStatusLog("BusyLamp Subscribe " + CString(sUserName) + " Failed.");
}

void CMainBusyLampDlg::OnBusyLampContactStatus(LPCTSTR sUserName, int nStatusId)
{
	int nIndex = m_ctrlListContact.FindItemIndex(sUserName);
	if(nIndex == -1) return;

	m_ctrlListContact.SetItemText(nIndex, 1, GetStatusText(nStatusId));
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

CString CMainBusyLampDlg::GetStatusText(int nStatusId)
{
    CString sStatus = "";

    switch (nStatusId)
    {
        case VAX_BUSY_LAMP_STATUS_FREE:
            sStatus = "Free";
            break;

        case VAX_BUSY_LAMP_STATUS_OFFLINE:
			sStatus = "Offline";
            break;
			        
        case VAX_BUSY_LAMP_STATUS_BUSY:
            sStatus = "Busy";
            break;

        case VAX_BUSY_LAMP_STATUS_UNKNOWN:
            sStatus = "UnKnown";
            break;

		case VAX_BUSY_LAMP_STATUS_CONNECTING:
            sStatus = "Busy";
            break;
    }

    return sStatus;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL CMainBusyLampDlg::OnApply()
{
	return FALSE;
}