#pragma once
#include "afxwin.h"


// CMainAccountRecDlg dialog
class CVaxSIPUserAgentLibEx;

class CMainAccountRecDlg : public CPropertyPage
{
	DECLARE_DYNAMIC(CMainAccountRecDlg)

public:
	CMainAccountRecDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent);
	virtual ~CMainAccountRecDlg();

// Dialog Data
	enum { IDD = IDD_ACCOUNT_REC_DLG };

private:

	BOOL m_bBtnAdvanceShow; 

private:

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;

	CFont m_objFont;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

private:
	
	CButton m_ctrlBtnOnline;
	CButton m_ctrlBtnAdvance;
	
	CListBox m_ctrlListBoxStatusStatus;
	CListBox m_ctrlListBoxCallLog;

public:

	CString m_sEditAuthLogin;
	CString m_sEditAuthPwd;

	CString m_sEditUserName;
	CString m_sEditDisplayName;
	
	CString m_sEditDomainRealm;

	CString m_sEditServerAddr;
	CString m_sEditServerPort;
		
	BOOL m_bCheckRegisterToServerREC;

private:

	void AddToStatusLog(LPCTSTR sStatus);
	void AddToCallLog(LPCTSTR sStatus);

	void ShowAdvance(BOOL bShow);

public:
		
	/////////////////////////////////////////////////////////////////////////////////////////

	void OnConnectingToRegister();
	void OnTryingToRegister();
	void OnFailToRegister(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToRegister();

	void OnTryingToReRegister();
	void OnFailToReRegister(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToReRegister();
	
	void OnTryingToUnRegister();
	void OnFailToUnRegister();
	void OnSuccessToUnRegister();
		
	void OnDialCallStarted(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	void OnDialingCall(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnDialCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort);
	void OnHungupCall(int nLineNo);
	
	void OnStatusMsg(int nLineNo, DWORD dwErrorCode, CString sErrorMsg);
	
private:

	afx_msg void OnBtnOnlineClicked();
	afx_msg void OnBtnAdvanceClicked();
	afx_msg void OnBtnClearStatusStatusClicked();
	afx_msg void OnBtnClearCallLogClicked();
public:
	virtual BOOL OnInitDialog();
};
