#pragma once

#include "afxwin.h"
#include"ListBoxEx.h"

class CVaxSIPUserAgentLibEx;

class CMainAccountDlg : public CPropertyPage
{
	DECLARE_DYNAMIC(CMainAccountDlg)

private:

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;

	CFont m_objFont;

public:

	CMainAccountDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent);
	virtual ~CMainAccountDlg();

	enum { IDD = IDD_ACCOUNT_DLG };

protected:

	BOOL OnInitDialog();

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnApply();

	DECLARE_MESSAGE_MAP()

public:

	CButton m_ctrlBtnOnline;
	CButton m_ctrlBtnAdvance;
			
private:
	
	CString m_sEditUserName;
	CString m_sEditDisplayName;
	
	CString m_sEditAuthLogin;
	CString m_sEditAuthPwd;
	
	CString m_sEditDomainRealm;
	
	CString m_sEditServerAddr;
	CString m_sEditServerPort;
	CString m_sLabelServerPort;

	CString m_sLabelIsMsgWaiting;
	CString m_sLabelNewMsgs;
	CString m_sLabelOldMsgs;
		
	BOOL m_bCheckRegisterToServerSIP;
	BOOL m_bCheckCaptureSoundDevice;

	CListBoxEx m_ctrlListBoxStatusLog;
	
private:

	BOOL m_bBtnAdvanceShow;
	CComboBox m_ctrlComboServerType;

private:
	
	void AddToStatusLog(LPCTSTR sStatus);
	void ShowAdvance(BOOL bShow);

	void UpdateServerType(int nServerType);
	int GetServerType();

public:

	void OnNetworkReachability(BOOL bAvailable);

	void OnConnectingToRegister();
	void OnTryingToRegister();
	void OnFailToRegister(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToRegister();

	void OnConnectingToReRegister();
	void OnTryingToReRegister();
	void OnFailToReRegister(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToReRegister();

	void OnTryingToUnRegister();
	void OnFailToUnRegister();
	void OnSuccessToUnRegister();

	void OnVoiceMailMsg(int bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, LPCTSTR sMsgAccount);
	
private:

	afx_msg void OnBtnOnlineClicked();
	afx_msg void OnBtnDemoAccountClicked();
	afx_msg void OnBtnAdvanceClicked();
		
	afx_msg void OnBtnClearStatusLogClicked();
	afx_msg void OnCbnSelchangeComboServerType();

};
