#include "StdAfx.h"
#include "StoreRegistry.h"
#include "StoreUser.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

#define SUB_KEY_BUFFER_SIZE		2048
#define USER_ROOT_PATH			"Users\\"

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreUser::AddUser(LPCTSTR sUserName, LPCTSTR sPassword, LPCTSTR sAudioCodecList, BOOL bBlocked, LONG nVoiceTypeId, LPCTSTR sUserPrefix, LPCTSTR sDialPrefix, LPCTSTR sToPeerName)
{
	if(CString(sUserName).IsEmpty())
		return FALSE;

	CString sKeyPath;
	sKeyPath.Format("%s%s", USER_ROOT_PATH, sUserName);

	CStoreRegistry objStore;

	objStore.SetTEXT(sKeyPath, "UserName", sUserName);
	objStore.SetTEXT(sKeyPath, "Password", sPassword);

	objStore.SetTEXT(sKeyPath, "AudioCodecList", sAudioCodecList);

	objStore.SetBOOL(sKeyPath, "Blocked", bBlocked);
	objStore.SetINT(sKeyPath , "VoiceTypeId", nVoiceTypeId);

	CStoreUser::AddUserRoute(sUserName, sUserPrefix, sDialPrefix, sToPeerName);
	return TRUE;
}

void CStoreUser::GetUser(LPCTSTR sUserName, CString& sPassword, CString& sAudioCodecList, BOOL& bBlocked, LONG& nVoiceTypeId, CString& sUserPrefix, CString& sDialPrefix, CString& sToPeerName)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", USER_ROOT_PATH, sUserName);

	CStoreRegistry objStore;
		
	objStore.GetTEXT(sKeyPath, "Password", sPassword, "");
	objStore.GetTEXT(sKeyPath, "AudioCodecList", sAudioCodecList, "");

	objStore.GetBOOL(sKeyPath, "Blocked", bBlocked, FALSE);
	objStore.GetINT(sKeyPath, "VoiceTypeId", nVoiceTypeId, VAX_VOICE_TYPE_NORMAL);
		
	CStoreUser::GetUserRoute(sUserName, sUserPrefix, sDialPrefix, sToPeerName);
}

void CStoreUser::RemoveUser(LPCTSTR sUserName )
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", USER_ROOT_PATH, sUserName);

	CStoreRegistry objStore;
	objStore.DeleteSubKey(sKeyPath);
}

void CStoreUser::GetUserAll(CStringList& objList)
{
	objList.RemoveAll();

	CString sKeyPath;
	sKeyPath =  USER_ROOT_PATH;

	CStoreRegistry objStore;
	objStore.EnumSubKeys(sKeyPath, objList);
}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreUser::AddUserRoute(LPCTSTR sUserName, LPCTSTR sUserPrefix, LPCTSTR sDialPrefix, LPCTSTR sToPeerName)
{
	if(CString(sUserName).IsEmpty())
		return FALSE;

	CString sKeyPath;
	sKeyPath.Format("%s%s", USER_ROOT_PATH, sUserName);

	CStoreRegistry objStore;

	objStore.SetTEXT(sKeyPath, "UserPrefix", sUserPrefix);
	objStore.SetTEXT(sKeyPath, "DialPrefix ", sDialPrefix);
	objStore.SetTEXT(sKeyPath, "ToPeerName", sToPeerName);
	
	return TRUE;
}

void CStoreUser::GetUserRoute(LPCTSTR sUserName, CString& sUserPrefix, CString& sDialPrefix, CString& sToPeerName)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", USER_ROOT_PATH, sUserName);

	CStoreRegistry objStore;

	objStore.GetTEXT(sKeyPath, "UserPrefix", sUserPrefix, "");
	objStore.GetTEXT(sKeyPath, "DialPrefix ",  sDialPrefix, "");
	objStore.GetTEXT(sKeyPath, "ToPeerName", sToPeerName, "");
}

void CStoreUser::RemoveUserRoute(LPCTSTR sUserName)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", USER_ROOT_PATH, sUserName);

	CStoreRegistry objStore;

	objStore.DeleteValue(sKeyPath, "UserPrefix");
	objStore.DeleteValue(sKeyPath, "DialPrefix");

	objStore.DeleteValue(sKeyPath, "ToPeerName");
}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreUser::IsDataStored()
{
	CStoreRegistry objStore;
    return objStore.IsKeyExist(USER_ROOT_PATH);
}
