#pragma once

class CStoreRegistry
{

public:

	CStoreRegistry(void);
	~CStoreRegistry(void);

private:

	HKEY m_hKey;

private:

	BOOL Open();
	void Close();
	
	HKEY CreateKey(CString sKeyName);
	HKEY OpenKey(CString sKeyName);

public:
   
   BOOL SetTEXT(LPCTSTR sKeyName, LPCTSTR sValueName, LPCTSTR sValueData);
   BOOL SetINT(LPCTSTR sKeyName, LPCTSTR sValueName, int nValueData);
   BOOL SetBOOL(LPCTSTR sKeyName, LPCTSTR sValueName, BOOL bValueData);

   void GetTEXT(LPCTSTR sKeyName, LPCTSTR sValueName, CString& sValueData, LPCTSTR sValueDefault);
   void GetINT(LPCTSTR sKeyName, LPCTSTR sValueName, int& nValueData, int nValueDefault);
   void GetBOOL(LPCTSTR sKeyName, LPCTSTR sValueName, BOOL& bValueData, BOOL bValueDefault);

   BOOL DeleteSubKey(LPCTSTR sKeyName);
   BOOL EnumSubKeys(LPCTSTR sKeyRootName, CStringList& objList);

   BOOL EnumValueNames(LPCTSTR sKeyRootName, CStringList& objList);
   BOOL IsKeyExist(LPCTSTR sSubKeyName);
   BOOL DeleteValue(LPCTSTR sKeyRootName, LPCTSTR sValueName);
	   
};

