#include "StdAfx.h"
#include "StoreRegistry.h"
#include "StoreLine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

#define SUB_KEY_BUFFER_SIZE		2048
#define LINE_ROOT_PATH			"Lines\\"

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreLine::AddLine(LPCTSTR sLineName, LONG nLineType, LPCTSTR sAuthUser, LPCTSTR sAuthPwd, LPCTSTR sServerAddr, LONG nServerPort, LPCTSTR sAudioCodecList, BOOL bRegister, LPCTSTR sToPeerName, BOOL bRejected, LPCTSTR sRoomName)
{
	if(CString(sLineName).IsEmpty())
		return FALSE;

	CString sKeyPath;
	sKeyPath.Format("%s%s", LINE_ROOT_PATH, sLineName);

	CStoreRegistry objStore;

	objStore.SetTEXT(sKeyPath, "LineName", sLineName);
	objStore.SetINT(sKeyPath, "LineType", nLineType);

	objStore.SetTEXT(sKeyPath, "AuthUser", sAuthUser);
	objStore.SetTEXT(sKeyPath, "Authpwd", sAuthPwd);

	objStore.SetTEXT(sKeyPath, "ServerAddr", sServerAddr);
	objStore.SetINT(sKeyPath, "ServerPort", nServerPort);
	    
	objStore.SetTEXT(sKeyPath, "AudioCodecList", sAudioCodecList);
	objStore.SetBOOL(sKeyPath, "Register", bRegister);
		
	CStoreLine::AddLineRoute(sLineName, sToPeerName, bRejected, sRoomName);
	return TRUE; 
}

void CStoreLine::RemoveLine(LPCTSTR sLineName)
{
	if(CString(sLineName).IsEmpty())
		return;

	CString sKeyPath;
	sKeyPath.Format("%s%s", LINE_ROOT_PATH, sLineName);

	CStoreRegistry objStore;
	objStore.DeleteSubKey(sKeyPath);

	CStoreLine::RemoveLineRoute(sLineName);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

BOOL CStoreLine::GetLine(LPCTSTR sLineName, LONG& nLineType, CString& sAuthUser, CString& sAuthPwd, CString& sServerAddr, LONG& nServerPort, CString& sAudioCodecList, BOOL& bRegister, CString& sToPeerName, BOOL& bRejected, CString& sRoomName)
{
	if(CString(sLineName).IsEmpty())
		return FALSE;

	CString sKeyPath;
	sKeyPath.Format("%s%s", LINE_ROOT_PATH, sLineName);
	
	CStoreRegistry objStore;

	objStore.GetINT(sKeyPath, "LineType", nLineType, VAX_LINE_TYPE_UDP);
		
	objStore.GetTEXT(sKeyPath, "AuthUser", sAuthUser, "");
    objStore.GetTEXT(sKeyPath, "Authpwd", sAuthPwd, "");

	objStore.GetTEXT(sKeyPath, "ServerAddr", sServerAddr, "");
    objStore.GetINT(sKeyPath, "ServerPort", nServerPort, SIP_DEFAULT_PORT);

    objStore.GetTEXT(sKeyPath, "AudioCodecList", sAudioCodecList, "");
	objStore.GetBOOL(sKeyPath, "Register", bRegister, FALSE);

	CStoreLine::GetLineRoute(sLineName, sToPeerName, bRejected, sRoomName);
	return TRUE; 
}

void CStoreLine::GetLineNameAll(CStringList& objList)
{
	objList.RemoveAll();

	CString sKeyPath = LINE_ROOT_PATH;
	 
	CStoreRegistry objStore;
	objStore.EnumSubKeys(sKeyPath, objList);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

BOOL CStoreLine::AddLineRoute(LPCTSTR sLineName, LPCTSTR sToPeerName, BOOL bRejected, LPCTSTR sRoomName)
{
	if(CString(sLineName).IsEmpty())
		return FALSE;

	CString sKeyPath;
	sKeyPath.Format("%s%s", LINE_ROOT_PATH, sLineName);

	CStoreRegistry objStore;
		
	objStore.SetTEXT(sKeyPath, "ToPeerName", sToPeerName);
	objStore.SetBOOL(sKeyPath, "Rejected", bRejected);
	objStore.SetTEXT(sKeyPath, "RoomName", sRoomName);
    
	return TRUE;
}

BOOL CStoreLine::GetLineRoute(LPCTSTR sLineName, CString& sToPeerName, BOOL& bRejected, CString& sRoomName)
{
	if(CString(sLineName).IsEmpty())
		return FALSE;

	CString sKeyPath;
	sKeyPath.Format("%s%s", LINE_ROOT_PATH, sLineName);

	CStoreRegistry objStore;
		
	objStore.GetTEXT(sKeyPath, "ToPeerName", sToPeerName, "");
	objStore.GetBOOL(sKeyPath, "Rejected", bRejected, FALSE);
	objStore.GetTEXT(sKeyPath, "RoomName", sRoomName, "");

	return TRUE;
}

void CStoreLine::RemoveLineRoute(LPCTSTR sLineName)
{
	if(CString(sLineName).IsEmpty())
		return;

    CString sKeyPath;
	sKeyPath.Format("%s%s", LINE_ROOT_PATH, sLineName);

	CStoreRegistry objStore;
		
	objStore.DeleteValue(sKeyPath, "Rejected");
	objStore.DeleteValue(sKeyPath, "ToPeerName");
	objStore.DeleteValue(sKeyPath, "RoomName");
}

BOOL CStoreLine::IsDataStored()
{
	CStoreRegistry objStore;
	return objStore.IsKeyExist(LINE_ROOT_PATH);
}

