#pragma once
#include "afxwin.h"

#include"ListBoxEx.h"

class CVaxSIPUserAgentLibEx;

class CMainSettingDlg : public CPropertyPage
{
	DECLARE_DYNAMIC(CMainSettingDlg)

public:

	CMainSettingDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent);
	virtual ~CMainSettingDlg();

	enum { IDD = IDD_SETTING_DLG };

public:

	virtual BOOL OnApply();
	virtual BOOL OnInitDialog();

protected:

	virtual void DoDataExchange(CDataExchange* pDX);  
	DECLARE_MESSAGE_MAP()

public:

	void OnVaxOnline();
	void OnVaxOffline();

	void OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort);
	
private:

	void UpdateAudioIn();
	void UpdateAudioOut();
		
	void ActivateAudioCodecs();
	
	void ActivateOtherSettings();
	void ActivateDigitDTMF();
	
private:

	int m_nRadioSelIndexDTMF;

	BOOL m_bCheckG711A_LAW;
	BOOL m_bCheckG711U_LAW;
	BOOL m_bCheckG729;

	BOOL m_bCheckGSM610;
	BOOL m_bCheckILBC;
		
	BOOL m_bCheckAGC;
	BOOL m_bCheckMicBoost;
			
	CListBoxEx m_ctrlListAudioIn;
	CListBoxEx m_ctrlListAudioOut;
			
private:

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;
	CFont m_objFont;

public:

	afx_msg void OnCheckCodecGsm610_CheckChanged();
	afx_msg void OnCheckCodecILBC_CheckChanged();

	afx_msg void OnCheckCodecG729_CheckChanged();
	afx_msg void OnCheckCodecG711A_CheckChanged();
	afx_msg void OnCheckCodecG711U_CheckChanged();

	afx_msg void OnCheckAGC_CheckChanged();
	afx_msg void OnCheckBoostMic_CheckChanged();
		
	afx_msg void On_SelChangeAudioIn();
	afx_msg void On_SelChangeAudioOut();
	
	afx_msg void OnBnClickedRadioForceNone();
	afx_msg void OnBnClickedRadioForceInbandDtmf();
	afx_msg void OnBnClickedRadioForceRfc2833Dtmf();
	afx_msg void OnBnClickedRadioForceInfoDtmf();
};


