#pragma once

class CVaxSIPUserAgentLibEx;

class CPhoneVoiceData
{

public:

	CPhoneVoiceData(void);
	~CPhoneVoiceData(void);

public:

	BOOL m_bMuteLineMIC;
    BOOL m_bMuteLineSPK;
    
	BOOL m_bAllowListenConf;
    BOOL m_bAllowSpeakConf;
    
	BOOL m_bListenRightSpk;
	BOOL m_bListenLeftSpk;

private:

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;
};

class CPhoneVoice
{

public:

	CPhoneVoice(void);
	~CPhoneVoice(void);

private:

	CPhoneVoiceData** m_pLineData;
	int m_nTotalLines;

public:

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;

private:

	int SpkListenChannel(BOOL bListenLeft, BOOL bListenRight);

	void AllocMEM(int nTotalLines);
	void DeAllocMEM();

public:

	void OnVaxInit(int nTotalLines);
	void OnVaxUnInit();

	void MuteLineMic(int nLineNo, BOOL bMute);
	void MuteLineSpk(int nLineNo, BOOL bMute);

	void LineVoiceChannelSpk(int nLineNo, BOOL bLeftSpkListen, BOOL bRightSpkListen);
	void ConfAllowLine(int nLineNo, BOOL bAllowListen, BOOL bAllowSpeak);

	void LineSelected(int nLineNo);

protected:

	virtual void OnChangeVoiceSetting(BOOL bMuteLineMIC, BOOL bMuteLineSPK,BOOL bAllowListenConf, BOOL bAllowSpeakConf, BOOL bListenLeftSpk, BOOL bListenRightSpk);

};

