#include "StdAfx.h"
#include "PhoneVoice.h"
#include "VaxSIPUserAgentLibEx.h"

CPhoneVoiceData::CPhoneVoiceData(void)
{
	m_bMuteLineSPK = FALSE;
	m_bMuteLineMIC = FALSE;

	m_bAllowListenConf = TRUE;
    m_bAllowSpeakConf = TRUE;
    
	m_bListenRightSpk = TRUE;
	m_bListenLeftSpk = TRUE;
}

CPhoneVoiceData::~CPhoneVoiceData(void)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

CPhoneVoice::CPhoneVoice(void)
{
	m_pLineData = NULL;
}

CPhoneVoice::~CPhoneVoice(void)
{
	DeAllocMEM();
}

void CPhoneVoice::OnVaxInit(int nTotalLines)
{
	m_nTotalLines = nTotalLines;
	AllocMEM(nTotalLines);

	m_pVaxUserAgentSIP->AudioDeviceVU(TRUE, TRUE, TRUE);
}

void CPhoneVoice::OnVaxUnInit()
{
	DeAllocMEM();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CPhoneVoice::AllocMEM(int nTotalLines)
{
	DeAllocMEM(); 
	
	m_pLineData = new CPhoneVoiceData*[nTotalLines];

	for(int nLineNo = 0; nLineNo < nTotalLines; nLineNo++)
	{
		m_pLineData[nLineNo] = new CPhoneVoiceData();
	}
}

void CPhoneVoice::DeAllocMEM()
{
	if(m_pLineData)
	{
		for(int nLineNo = 0; nLineNo < m_nTotalLines; nLineNo++)
		{
			delete m_pLineData[nLineNo];
			m_pLineData[nLineNo] = NULL;
		}

		delete[] m_pLineData;
		m_pLineData = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CPhoneVoice::MuteLineSpk(int nLineNo, BOOL bMute)
{
	if(!m_pVaxUserAgentSIP->MuteLineSpk(nLineNo, bMute))
		return;
	
    m_pLineData[nLineNo]->m_bMuteLineSPK = bMute;
}


void CPhoneVoice::MuteLineMic(int nLineNo, BOOL bMute)
{
	if(!m_pVaxUserAgentSIP->MuteLineMic(nLineNo, bMute))
		return;
	
    m_pLineData[nLineNo]->m_bMuteLineMIC = bMute;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CPhoneVoice::SpkListenChannel(BOOL bListenLeft, BOOL bListenRight)
{
    if (bListenLeft == TRUE && bListenRight == FALSE)
        return 0;

    if (bListenLeft == FALSE && bListenRight == TRUE)
        return 1;

    return 2;
}

void CPhoneVoice::LineVoiceChannelSpk(int nLineNo, BOOL bLeftSpkListen, BOOL bRightSpkListen)
{
	if(!m_pVaxUserAgentSIP->LineVoiceChannelSpk(nLineNo, SpkListenChannel(bLeftSpkListen, bRightSpkListen)))
		return;
	
    m_pLineData[nLineNo]->m_bListenRightSpk = bRightSpkListen;
}

void CPhoneVoice::ConfAllowLine(int nLineNo, BOOL bAllowListen, BOOL bAllowSpeak)
{
	if(!m_pVaxUserAgentSIP->ConfAllowLine(nLineNo, bAllowListen, bAllowSpeak))
	    return;
	            
    m_pLineData[nLineNo]->m_bAllowListenConf = bAllowListen;
	m_pLineData[nLineNo]->m_bAllowSpeakConf  = bAllowSpeak;
}

void CPhoneVoice::LineSelected(int nLineNo)
{
	if(m_pLineData == NULL) return;
	
	BOOL bMuteLineMIC = m_pLineData[nLineNo]->m_bMuteLineMIC;
	BOOL bMuteLineSPK = m_pLineData[nLineNo]->m_bMuteLineSPK;

	BOOL bAllowListenConf = m_pLineData[nLineNo]->m_bAllowListenConf;
	BOOL bAllowSpeakConf = m_pLineData[nLineNo]->m_bAllowSpeakConf; 

	BOOL bListenLeftSpk = m_pLineData[nLineNo]->m_bListenLeftSpk;
	BOOL bListenRightSpk = m_pLineData[nLineNo]->m_bListenRightSpk;

	OnChangeVoiceSetting(bMuteLineMIC, bMuteLineSPK, bAllowListenConf, bAllowSpeakConf, bListenLeftSpk, bListenRightSpk);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CPhoneVoice::OnChangeVoiceSetting(BOOL bMuteLineMIC, BOOL bMuteLineSPK,BOOL bAllowListenConf, BOOL bAllowSpeakConf, BOOL bListenLeftSpk, BOOL bListenRightSpk)
{

}