#include "StdAfx.h"
#include "VaxVoIP.h"
#include "VaxSIPUserAgentLibEx.h"
#include "VaxVoIPDlg.h"
#include "ListBoxEx.h"
#include "PhoneIncomingCallForm.h"
#include "PhoneIncomingCall.h"

CPhoneIncomingCall::CPhoneIncomingCall(void)
{
	m_pCallAlert = new CPhoneIncomingCallForm(m_pMainDlg);
}

CPhoneIncomingCall::~CPhoneIncomingCall(void)
{
	delete m_pCallAlert;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCall::OnVaxInit()
{
	m_pCallAlert->OnVaxInit(m_pMainDlg);
}

void CPhoneIncomingCall::OnVaxUnInit()
{
	m_pCallAlert->OnVaxUnInit();
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCall::SetListIncomingCall(CListBoxEx* ctrlList)
{
	m_ctrlListIncomingCalls = ctrlList;
}

CString CPhoneIncomingCall::GenCallerInfo(LPCTSTR sCallerName, LPCTSTR sCallerId)
{
	CString sCallerInfo;
	
	if(!CString(sCallerName).IsEmpty())
		sCallerInfo.Format("NAME: %s, CLI: %s", sCallerName, sCallerId);
	else
		sCallerInfo.Format("NAME: Unknown, CLI: %s", sCallerId);
            
	return sCallerInfo;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCall::OnIncomingCallStarted(LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId)
{
	if(FindCall(sCallId))
		return;
	
	CString sCallerInfo = GenCallerInfo(sCallerName, sCallerId);

	int nIndex = m_ctrlListIncomingCalls->AddStringData(sCallerInfo, sCallId);
	
	if ((m_ctrlListIncomingCalls->GetCurSel() == -1) && ( m_ctrlListIncomingCalls->GetCount() > 0))
		m_ctrlListIncomingCalls->SetCurSel(0);    
}

void CPhoneIncomingCall::OnIncomingCallEnded(LPCTSTR sCallId)
{
	RemoveCall(sCallId);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CPhoneIncomingCall::OnRingToneStarted(LPCTSTR sCallId)
{   
	m_pCallAlert->OnRingToneStarted(sCallId);
}

void CPhoneIncomingCall::OnRingToneEnded(LPCTSTR sCallId)
{
	m_pCallAlert->OnRingToneEnded(sCallId);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

BOOL CPhoneIncomingCall::AcceptCall(int nLineNo)
{
    int nSelectedItemIndex = m_ctrlListIncomingCalls->GetCurSel();
    if (nSelectedItemIndex == -1) return FALSE;
    		
	CString sCallId = m_ctrlListIncomingCalls->GetStringData(nSelectedItemIndex);

	if(!m_pVaxUserAgentSIP->AcceptCall(nLineNo, sCallId))
	    return FALSE;
         
	m_ctrlListIncomingCalls->DeleteStringData(nSelectedItemIndex);
    
	if (m_ctrlListIncomingCalls->GetCount() > 0)
    {
		int nSelectedItemIndex = m_ctrlListIncomingCalls->GetCurSel();

        if(nSelectedItemIndex == -1)
			m_ctrlListIncomingCalls->SetCurSel(0);
    }

	return TRUE;
}

void CPhoneIncomingCall::RejectCall()
{
	int nSelectedIndex = m_ctrlListIncomingCalls->GetCurSel();
	if(nSelectedIndex == -1) return;

	CString sCallId = m_ctrlListIncomingCalls->GetStringData(nSelectedIndex);
	if(sCallId.IsEmpty()) return;
			
	if(!m_pVaxUserAgentSIP->RejectCall(sCallId))
       return;
	
	m_ctrlListIncomingCalls->DeleteStringData(nSelectedIndex);
		
	if(m_ctrlListIncomingCalls->GetCurSel() == -1)
		m_ctrlListIncomingCalls->SetCurSel(0);	
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

BOOL CPhoneIncomingCall::FindCall(CString sCallId)
{
	for(int nListIndex = 0; nListIndex < m_ctrlListIncomingCalls->GetCount(); nListIndex++)
    {
		CString sCallIdStored = m_ctrlListIncomingCalls->GetStringData(nListIndex);

        if(sCallIdStored == sCallId)
            return TRUE;
    }
            
    return FALSE;
}

void CPhoneIncomingCall::RemoveCall(CString sCallId)
{
    for (int nListIndex = 0; nListIndex < m_ctrlListIncomingCalls->GetCount(); nListIndex++)
    {
		CString sCallIdStored = m_ctrlListIncomingCalls->GetStringData(nListIndex);

        if(sCallIdStored == sCallId)
        {
			m_ctrlListIncomingCalls->DeleteStringData(nListIndex);
            return;
        }
    }
}