#pragma once

#include "afxwin.h"
#include "afxcmn.h"

#include "ListBoxEx.h"
#include "ListCtrlEx.h"

#include "PhoneTone.h"
#include "PhoneVoice.h"
#include "PhoneLineStatus.h"
#include "PhoneIncomingCall.h"

class CVaxSIPUserAgentLibEx;
class CVaxVoIPDlg;

class CMainPhoneDlg : public CPropertyPage, public CPhoneTone, public CPhoneVoice, public CPhoneIncomingCall, public CPhoneLineStatus
{
	DECLARE_DYNAMIC(CMainPhoneDlg)

public:
	
	CMainPhoneDlg(CVaxSIPUserAgentLibEx*, CVaxVoIPDlg*);
	virtual ~CMainPhoneDlg();
		
	enum { IDD = IDD_PHONE_DLG };

protected:

	virtual void DoDataExchange(CDataExchange* pDX);

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();

	DECLARE_MESSAGE_MAP()

public:

	void OnVaxOnline();
	void OnVaxOffline();

private:

	CFont m_objFont;

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;
	CVaxVoIPDlg* m_pMainDlg;

private:

	void AdjustSecureMediaSRTP(BOOL bDialCall);

	void FillComboBoxes(int nTotalLines);
	void FillListLines(int nTotalLines);

	void AddToStatusLog(LPCTSTR sStatusLog);
	int FindLine();
	
	BOOL FindCallId(LPCTSTR sCallId);
	void RemoveCallIdFromList(LPCTSTR sCallId);
		
	void ShowListBoxLineStatus(int nLineNo, LPCTSTR sStatus);
	void UpdateBtnStatus();

private:

	BOOL m_bCheckDonotDisturb;

	CComboBox m_ctrlComboConsultLineA;
	CComboBox m_ctrlComboConsultLineB;

	CComboBox m_ctrlComboDialCallSecureMediaSRTP;
	CComboBox m_ctrlComboAcceptCallSecureMediaSRTP;

	BOOL m_bCheckLeftSpkListen;
	BOOL m_bCheckRightSpkListen;

	BOOL m_bCheckAllowListenConf;
	BOOL m_bCheckAllowSpeakConf;

	BOOL m_bCheckMuteLineSPK;
	BOOL m_bCheckMuteLineMIC;

	BOOL m_bCheckForwardCall;
	BOOL m_bCheckDetectAMD;
	
	BOOL m_bCheckPlayRingTone;
	BOOL m_bCheckPlayDialTone;

	BOOL m_bCheckPlayWaveListen;
		
	BOOL m_bCheckMuteSPK;
	BOOL m_bCheckMuteMIC;

	CString m_sEditFileWave;
	CString m_sEditForwardCallPhoneNo;

	CString m_sEditDialPhoneNo;
	
	CString m_sEditTransferCall;
	CString m_sEditFileRecord;

	CListBoxEx m_ctrListStatusLog;
	CListBoxEx m_ctrlListIncomingCalls;

	CListCtrlEx m_ctrlListBoxLines;

	CSliderCtrl m_ctrlSliderSpkVol;
	CSliderCtrl m_ctrlSliderMicVol;
	
	CProgressCtrl m_ctrlProgressSpk;
	CProgressCtrl m_ctrlProgressMic;

	CComboBox m_ctrlComboVoiceChanger;
	
public:

    void OnDigitDTMF(int nLineNo, LPCTSTR sDigit);
    void OnPlayWaveDone(int nLineNo);
	
	void OnDialCallStarted(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	void OnDialingCall(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnDialCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
    
	void OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort);
	void OnHungupCall(int nLineNo);
   
    void OnIncomingCallStarted(LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId);
	void OnIncomingCallEnded(LPCTSTR sCallId);

    void OnRingToneStarted(LPCTSTR sCallId);
    void OnRingToneEnded(LPCTSTR sCallId);

    void OnTransferCallAccepted(int nLineNo);
	void OnTransferCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	    
    void OnAudioSessionLost(int nLineNo);
    void OnMsgNOTIFY(LPCTSTR sMsg);
    
    void OnSuccessToHold(int nLineNo);
    void OnTryingToHold(int nLineNo);
    void OnFailToHold(int nLineNo);

    void OnSuccessToUnHold(int nLineNo);
    void OnTryingToUnHold(int nLineNo);
    void OnFailToUnHold(int nLineNo);
	
	void OnDetectedAMD(int nLineNo, BOOL bIsHuman);

	void OnChangeVoiceSetting(BOOL bMuteLineMIC, BOOL bMuteLineSPK,BOOL bAllowListenConf, BOOL bAllowSpeakConf, BOOL bListenLeftSpk, BOOL bListenRightSpk);
	void OnChangeLineStatus(int nLineNo, LPCTSTR sStatus);

	void OnNetworkReachability(BOOL bAvailable);

	void OnAudioDeviceMicVU(int nLevelVU);
	void OnAudioDeviceSpkVU(int nLevelVU);

	

public:

	afx_msg void OnTimer(UINT_PTR nIDEvent);

	afx_msg void OnBtnClickedClear();
	afx_msg void OnBtnClickedRejectCall();
	afx_msg void OnBtnClickedTransferCall();
	afx_msg void OnBtnClickedJoinBothLines();
	
	afx_msg void OnBtnClickedReset();
	afx_msg void OnBtnClickedPlayOpen();
	afx_msg void OnBtnClickedPlayRewind();
	afx_msg void OnBtnClickedPlayForward();
	afx_msg void OnBtnClickedPlayStart();
	afx_msg void OnBtnClickedPlayPause();
	afx_msg void OnBtnClickedPlayStop();

	afx_msg void OnCheckForward_CheckChanged();
	afx_msg void OnCheckMuteLineSPK_CheckChanged();
	afx_msg void OnCheckLeftSPK_CheckChanged();
	afx_msg void OnCheckMuteLineMIC_CheckChanged();
	afx_msg void OnCheckRightSPK_CheckChanged();
	afx_msg void OnCheckAllowListenConference_CheckChanged();
	afx_msg void OnCheckAllowSpeakConference_CheckChanged();
	afx_msg void OnCheckSpeakerMute_CheckChanged();
	afx_msg void OnCheckMicrophoneMute_CheckChanged();

	afx_msg void OnBtnClicked1();
	afx_msg void OnBtnClicked2();
	afx_msg void OnBtnClicked3();
	afx_msg void OnBtnClicked4();
	afx_msg void OnBtnClicked5();
	afx_msg void OnBtnClicked6();
	afx_msg void OnBtnClicked7();
	afx_msg void OnBtnClicked8();
	afx_msg void OnBtnClicked9();
	afx_msg void OnBtnClicked0();
	afx_msg void OnBtnClickedHash();
	afx_msg void OnBtnClickedStar();

	afx_msg void OnBtnClickedDial();
	afx_msg void OnBtnClickedAcceptCall();
  
	afx_msg void OnLvnItemchangedListlines(NMHDR *pNMHDR, LRESULT *pResult);
	
	afx_msg void OnBnClickedCheckPlayRingTone();
	afx_msg void OnBnClickedCheckPlayDialTone();
		
	
	afx_msg void OnCbnSelchangeComboVoiceChanger();
	afx_msg void OnBnClickedCheckDoNotDisturb();
	
	afx_msg void OnBnClickedBtnHold();
	
	CButton m_ctrlBtnDial;
	CButton m_ctrlBtnHold;
	
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnBnClickedBtnRecordStart();
	CButton m_ctrlBtnStartRecording;
};

