// VaxVoIPDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Define.h"

#include "VaxVoIP.h"
#include "VaxVoIPDlg.h"
#include "afxdialogex.h"

#include "MainAccountDlg.h"
#include "MainChatDlg.h"

#include "MainBusyLampDlg.h"
#include "MainPhoneDlg.h"
#include "MainSettingDlg.h"

#include "VaxSIPUserAgentLibEx.h"
#include "MainAccountRecDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CVaxVoIPDlg, CMySheet)

CVaxVoIPDlg::CVaxVoIPDlg(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	: CMySheet(nIDCaption, pParentWnd, iSelectPage)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CVaxVoIPDlg::CVaxVoIPDlg(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage): CMySheet(pszCaption, pParentWnd, iSelectPage)
{
	m_psh.dwFlags |= PSH_NOAPPLYNOW;
	m_psh.dwFlags &= ~PSH_HASHELP; 

 	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pVaxUserAgentSIP = new CVaxSIPUserAgentLibEx(this);

	//Create instances for tab control

	m_pAccountDlg = new CMainAccountDlg(m_pVaxUserAgentSIP);
	m_pPhoneDlg = new CMainPhoneDlg(m_pVaxUserAgentSIP, this);
	m_pChatDlg = new CChatDlg(m_pVaxUserAgentSIP);
	m_pBusyLampDlg = new CMainBusyLampDlg(m_pVaxUserAgentSIP);
	m_pSettingDlg = new CMainSettingDlg(m_pVaxUserAgentSIP);
	m_pRecAccountDlg = new CMainAccountRecDlg(m_pVaxUserAgentSIP);

	AddPage(m_pAccountDlg);
	AddPage(m_pPhoneDlg);
	
	AddPage(m_pChatDlg);
	AddPage(m_pBusyLampDlg);
	AddPage(m_pSettingDlg);
	AddPage(m_pRecAccountDlg);
}

void CVaxVoIPDlg::DoDataExchange(CDataExchange* pDX)
{
	CMySheet::DoDataExchange(pDX);
	
}

BEGIN_MESSAGE_MAP(CVaxVoIPDlg, CMySheet)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_NCCREATE()
	ON_WM_DESTROY()
//	ON_WM_CLOSE()
END_MESSAGE_MAP()


BOOL CVaxVoIPDlg::OnInitDialog()
{
	CMySheet::OnInitDialog();

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	// Get size in RECT structure
	RECT rcRect;
	
	GetWindowRect (&rcRect);
	ScreenToClient (&rcRect);

	// Decrease it's bottom's size
	rcRect.bottom -= 6;

	// Apply new size to this CPropertySheet
	SetWindowPos(NULL, 0,0, rcRect.right, rcRect.bottom, SWP_SHOWWINDOW | SWP_NOMOVE);

	((CButton*) GetDlgItem(IDOK))->DestroyWindow();
	((CButton*) GetDlgItem(IDCANCEL))->DestroyWindow();
	
	return TRUE; 
}

///////////////// OnPaint Event //////////////////////////

void CVaxVoIPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y - 32, m_hIcon);
	}
	else
	{
		CMySheet::OnPaint();
	}
}

HCURSOR CVaxVoIPDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CVaxVoIPDlg::CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, LPVOID lpParam)
{
	return CMySheet::CreateEx(dwExStyle, lpszClassName, lpszWindowName, dwStyle| WS_MINIMIZEBOX, rect, pParentWnd, nID, lpParam);
}

BOOL CVaxVoIPDlg::OnNcCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (!CMySheet::OnNcCreate(lpCreateStruct))
		return FALSE;

	LONG dwStyle = ::GetWindowLong(m_hWnd, GWL_STYLE);
	::SetWindowLong(m_hWnd, GWL_STYLE, dwStyle | WS_MINIMIZEBOX);

	return TRUE;
}

void CVaxVoIPDlg::OnVaxOnline()
{            
	m_pPhoneDlg->OnVaxOnline();
	m_pChatDlg->OnVaxOnline();
	
	m_pBusyLampDlg->OnVaxOnline();
	m_pSettingDlg->OnVaxOnline();
}

void CVaxVoIPDlg::OnVaxOffline()
{
	m_pPhoneDlg->OnVaxOffline();
	m_pChatDlg->OnVaxOffline();
	
	m_pBusyLampDlg->OnVaxOffline();
	m_pSettingDlg->OnVaxOffline();
}

void CVaxVoIPDlg::OnConnectingToRegister()
{
	m_pAccountDlg->OnConnectingToRegister();
}

void CVaxVoIPDlg::OnTryingToRegister()
{
    m_pAccountDlg->OnTryingToRegister();
}

void CVaxVoIPDlg::OnFailToRegister(int nStatusCode,LPCTSTR sReasonPhrase)
{
    m_pAccountDlg->OnFailToRegister(nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnSuccessToRegister()
{
    m_pAccountDlg->OnSuccessToRegister();
}

void CVaxVoIPDlg::OnConnectingToReRegister()
{
	m_pAccountDlg->OnConnectingToReRegister();
}

void CVaxVoIPDlg::OnTryingToReRegister()
{
    m_pAccountDlg->OnTryingToReRegister();
}

void CVaxVoIPDlg::OnFailToReRegister(int nStatusCode, LPCTSTR sReasonPhrase)
{
    m_pAccountDlg->OnFailToReRegister(nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnSuccessToReRegister()
{
    m_pAccountDlg->OnSuccessToReRegister();
}

void CVaxVoIPDlg::OnTryingToUnRegister()
{
    m_pAccountDlg->OnTryingToUnRegister();
}

void CVaxVoIPDlg::OnFailToUnRegister()
{
    m_pAccountDlg->OnFailToUnRegister();
}

void CVaxVoIPDlg::OnSuccessToUnRegister()
{
    m_pAccountDlg->OnSuccessToUnRegister();
}
       
void CVaxVoIPDlg::OnDigitDTMF(int nLineNo, LPCTSTR sDigit)
{
    m_pPhoneDlg->OnDigitDTMF(nLineNo, sDigit);
}

void CVaxVoIPDlg::OnPlayWaveDone(int nLineNo)
{
    m_pPhoneDlg->OnPlayWaveDone(nLineNo);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnDialCallStarted(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo)
{
	m_pPhoneDlg->OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
}

void CVaxVoIPDlg::OnDialingCall(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pPhoneDlg->OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnDialCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pPhoneDlg->OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort)
{
    m_pPhoneDlg->OnConnectedCall(nLineNo, sToRTPIP, nToRTPPort);
    m_pSettingDlg->OnConnectedCall(nLineNo, sToRTPIP, nToRTPPort);
}

void CVaxVoIPDlg::OnHungupCall(int nLineNo)
{
    m_pPhoneDlg->OnHungupCall(nLineNo);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnIncomingCallStarted(LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId)
{
    m_pPhoneDlg->OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
}

void CVaxVoIPDlg::OnIncomingCallEnded(LPCTSTR sCallId)
{
	m_pPhoneDlg->OnIncomingCallEnded(sCallId);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnRingToneStarted(LPCTSTR sCallId)
{
    m_pPhoneDlg->OnRingToneStarted(sCallId);
}

void CVaxVoIPDlg::OnRingToneEnded(LPCTSTR sCallId)
{
    m_pPhoneDlg->OnRingToneEnded(sCallId);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnTransferCallAccepted(int nLineNo)
{
    m_pPhoneDlg->OnTransferCallAccepted(nLineNo);
}

void CVaxVoIPDlg::OnTransferCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pPhoneDlg->OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnVoiceMailMsg(BOOL bIsMsgWaiting, DWORD dwNewMsgCount, DWORD dwOldMsgCount, DWORD dwNewUrgentMsgCount, DWORD dwOldUrgentMsgCount, LPCTSTR sMsgAccount)
{
    m_pAccountDlg->OnVoiceMailMsg(bIsMsgWaiting, dwNewMsgCount, dwOldMsgCount, dwNewUrgentMsgCount, dwOldUrgentMsgCount, sMsgAccount);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnAudioSessionLost(int nLineNo)
{
    m_pPhoneDlg->OnAudioSessionLost(nLineNo);
}

void CVaxVoIPDlg::OnMsgNOTIFY(LPCTSTR sMsg)
{
    m_pPhoneDlg->OnMsgNOTIFY(sMsg);
}

void CVaxVoIPDlg::OnSuccessToHold(int nLineNo)
{
    m_pPhoneDlg->OnSuccessToHold(nLineNo);
}

void CVaxVoIPDlg::OnTryingToHold(int nLineNo)
{
    m_pPhoneDlg->OnTryingToHold(nLineNo);
}

void CVaxVoIPDlg::OnFailToHold(int nLineNo)
{
    m_pPhoneDlg->OnFailToHold(nLineNo);
}

void CVaxVoIPDlg::OnSuccessToUnHold(int nLineNo)
{
    m_pPhoneDlg->OnSuccessToUnHold(nLineNo);
}

void CVaxVoIPDlg::OnTryingToUnHold(int nLineNo)
{
    m_pPhoneDlg->OnTryingToUnHold(nLineNo);
}

void CVaxVoIPDlg::OnFailToUnHold(int nLineNo)
{
    m_pPhoneDlg->OnFailToUnHold(nLineNo);
}

void CVaxVoIPDlg::OnDetectedAMD(int nLineNo, int bIsHuman)
{
    m_pPhoneDlg->OnDetectedAMD(nLineNo, bIsHuman);
}

void CVaxVoIPDlg::OnChatSubscribeSuccess(LPCTSTR sUserName)
{
	m_pChatDlg->OnChatSubscribeSuccess(sUserName);
}
        
void CVaxVoIPDlg::OnChatSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pChatDlg->OnChatSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnChatContactStatus(LPCTSTR sUserName, int nStatusId)
{
    m_pChatDlg->OnChatContactStatus(sUserName, nStatusId);
}

void CVaxVoIPDlg::OnChatSendMsgTextSuccess(LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue)
{
    m_pChatDlg->OnChatSendMsgTextSuccess(sUserName, sMsgText, nUserValue);
}

void CVaxVoIPDlg::OnChatSendMsgTextFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue)
{
    m_pChatDlg->OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue);
}

void CVaxVoIPDlg::OnChatSendMsgTypingSuccess(LPCTSTR sUserName, UINT64 nUserValue)
{
    m_pChatDlg->OnChatSendMsgTypingSuccess(sUserName, nUserValue);
}

void CVaxVoIPDlg::OnChatSendMsgTypingFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue)
{
    m_pChatDlg->OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase, nUserValue);
}

void CVaxVoIPDlg::OnChatRecvMsgText(LPCTSTR sUserName, LPCTSTR sMsgText)
{
    m_pChatDlg->OnChatRecvMsgText(sUserName, sMsgText);
}

void CVaxVoIPDlg::OnChatRecvMsgTypingStart(LPCTSTR sUserName)
{
    m_pChatDlg->OnChatRecvMsgTypingStart(sUserName);
}

void CVaxVoIPDlg::OnChatRecvMsgTypingStop(LPCTSTR sUserName)
{
    m_pChatDlg->OnChatRecvMsgTypingStop();
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnBusyLampSubscribeSuccess(LPCTSTR sUserName)
{
	m_pBusyLampDlg->OnBusyLampSubscribeSuccess(sUserName);
}

void CVaxVoIPDlg::OnBusyLampSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pBusyLampDlg->OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnBusyLampContactStatus(LPCTSTR sUserName, int nStatusId)
{
	m_pBusyLampDlg->OnBusyLampContactStatus(sUserName, nStatusId);
}

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnNetworkReachability(BOOL bAvailable)
{
	m_pAccountDlg->OnNetworkReachability(bAvailable);
	m_pPhoneDlg->OnNetworkReachability(bAvailable);
}

void CVaxVoIPDlg::OnAudioDeviceMicVU(int nLevelVU)
{
	m_pPhoneDlg->OnAudioDeviceMicVU(nLevelVU);
}

void CVaxVoIPDlg::OnAudioDeviceSpkVU(int nLevelVU)
{
	m_pPhoneDlg->OnAudioDeviceSpkVU(nLevelVU);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnConnectingToRegisterREC()
{
	m_pRecAccountDlg->OnConnectingToRegister();
}

void CVaxVoIPDlg::OnTryingToRegisterREC()
{
	m_pRecAccountDlg->OnTryingToRegister();
}

void CVaxVoIPDlg::OnFailToRegisterREC(int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pRecAccountDlg->OnFailToRegister(nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnSuccessToRegisterREC()
{
	m_pRecAccountDlg->OnSuccessToRegister();
}

void CVaxVoIPDlg::OnTryingToReRegisterREC()
{
	m_pRecAccountDlg->OnTryingToReRegister();
}

void CVaxVoIPDlg::OnFailToReRegisterREC(int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pRecAccountDlg->OnFailToReRegister(nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnSuccessToReRegisterREC()
{
	m_pRecAccountDlg->OnSuccessToReRegister();
}
	
void CVaxVoIPDlg::OnTryingToUnRegisterREC()
{
	m_pRecAccountDlg->OnTryingToUnRegister();
}

void CVaxVoIPDlg::OnFailToUnRegisterREC()
{
	m_pRecAccountDlg->OnFailToUnRegister();
}

void CVaxVoIPDlg::OnSuccessToUnRegisterREC()
{
	m_pRecAccountDlg->OnSuccessToUnRegister();
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnDialCallStartedREC(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo)
{
	m_pRecAccountDlg->OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
}

void CVaxVoIPDlg::OnDialingCallREC(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pRecAccountDlg->OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnDialCallFailedREC(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pRecAccountDlg->OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase);
}

void CVaxVoIPDlg::OnConnectedCallREC(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort)
{
    m_pRecAccountDlg->OnConnectedCall(nLineNo, sToRTPIP, nToRTPPort);
}

void CVaxVoIPDlg::OnHungupCallREC(int nLineNo)
{
    m_pRecAccountDlg->OnHungupCall(nLineNo);
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

void CVaxVoIPDlg::OnStatusMsgREC(int nLineNo, DWORD dwErrorCode, LPCTSTR sErrorMsg)
{
	m_pRecAccountDlg->OnStatusMsg(nLineNo, dwErrorCode, sErrorMsg);
}

void CVaxVoIPDlg::OnVaxErrorMsg(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode)
{
	MessageBox(sErrorMsg, "VaxVoIP SDK", MB_ICONEXCLAMATION);
}

void CVaxVoIPDlg::OnDestroy()
{
	m_pVaxUserAgentSIP->UnInitialize();
	delete m_pVaxUserAgentSIP;

	delete m_pAccountDlg;
	
	delete m_pPhoneDlg;
	delete m_pChatDlg;
	delete m_pBusyLampDlg;

	delete m_pSettingDlg;
	delete m_pRecAccountDlg;

	CMySheet::OnDestroy();
}