// ListBoxEx.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "ListBoxEx.h"


// CListBoxEx

IMPLEMENT_DYNAMIC(CListBoxEx, CListBox)

CListBoxEx::CListBoxEx()
{

}

CListBoxEx::~CListBoxEx()
{
}

BEGIN_MESSAGE_MAP(CListBoxEx, CListBox)
END_MESSAGE_MAP()

int CListBoxEx::AddString(LPCTSTR sItemText)
{
	int nIndex = CListBox::AddString(sItemText);
	
	CListBox::SetItemDataPtr(nIndex, NULL); 
	CListBox::SetTopIndex(GetCount() - 1);
	
	return nIndex;
}

CString CListBoxEx::GetStringData(int nItemIndex)
{
	char* pData = (char*) CListBox::GetItemData(nItemIndex);
	return CString(pData);
}

int CListBoxEx::AddStringData(LPCTSTR sItemText, LPCTSTR sItemData)
{
	int nIndex = CListBox::AddString(sItemText);
	
	int nLength = ::lstrlen(sItemData);
	char* pData = NULL;

	if(nLength != 0)
	{
		pData = new char[nLength + 1];
		::memset(pData, NULL, nLength + 1);
		::memcpy(pData, sItemData, nLength);
	}

	CListBox::SetItemDataPtr(nIndex, pData); 
	CListBox::SetTopIndex(GetCount() - 1);
	
	return nIndex;
}

int CListBoxEx::InsertString(int nItemIndex, LPCTSTR sItemText)
{
	int nErrorCode = CListBox::InsertString(nItemIndex, sItemText);
	
	CListBox::SetItemDataPtr(nItemIndex, NULL); 
	CListBox::SetTopIndex(GetCount() - 1);

	return nErrorCode;
}

void CListBoxEx::DeleteStringData(int nItemIndex)
{
	char* pData = (char*) CListBox::GetItemData(nItemIndex);
	if(pData) delete[] pData;

	CListBox::DeleteString(nItemIndex);
}

void CListBoxEx::ResetStringContent()
{
	for(int nListIndex = 0; nListIndex < GetCount(); nListIndex++)
    {
		char* pData = (char*) CListBox::GetItemData(nListIndex);
		if(pData) delete[] pData;
    }

	CListBox::ResetContent();
}