// ChatDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Define.h"
#include "VaxVoIP.h"
#include "MainChatDlg.h"
#include "StoreChat.h"
#include "afxdialogex.h"
#include "VaxSIPUserAgentLibEx.h"

#define CHAT_TYPING_TIMER   WM_USER + 1

IMPLEMENT_DYNAMIC(CChatDlg, CPropertyPage)

CChatDlg::CChatDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent): CPropertyPage(CChatDlg::IDD)
{
	m_psp.dwFlags &= ~PSP_HASHELP; 
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;

	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana"); 
	    
	m_sEditContactName = "";
    m_sEditSendChatMessage = "";
}

CChatDlg::~CChatDlg()
{
}

void CChatDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_CMBO_STATUS, m_ctrlComboMyChatStatus);
	DDX_Control(pDX, IDC_LIST_STATUS_LOG , m_ctrlListStatusLog);
	DDX_Control(pDX, IDC_LIST_CONTACTS, m_ctrlListContact);
	DDX_Control(pDX, IDC_LIST_CHAT_MESSAGES, m_ctrlListMessage);
		
	DDX_Text(pDX, IDC_EDIT_CONTACT, m_sEditContactName);
	DDX_Text(pDX, IDC_EDIT_CHAT_MESSAGE, m_sEditSendChatMessage);
		
	GetDlgItem(IDC_GROUP_CHAT_MESSAGES)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_STATUS_LOG)->SetFont(&m_objFont);
}

BEGIN_MESSAGE_MAP(CChatDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_ADD_CONTACT, &CChatDlg::OnBtnClickedAddContact)
	ON_BN_CLICKED(IDC_BTN_REMOVE_CONTACT, &CChatDlg::OnBtnClickedRemoveContact)
	ON_BN_CLICKED(IDC_BTN_CLEAR_MESSAGE, &CChatDlg::OnBtnClickedClearChat)
	ON_BN_CLICKED(IDC_BTN_SEND_MESSAGE, &CChatDlg::OnBtnClickedSendMessage)
	ON_BN_CLICKED(IDC_BTN_STATUS_LOG_CLEAR, &CChatDlg::OnBtnClickedClearLog)
	ON_WM_TIMER()
	ON_EN_CHANGE(IDC_EDIT_CHAT_MESSAGE, &CChatDlg::OnChangeEditMessage)
	ON_CBN_SELCHANGE(IDC_CMBO_STATUS, &CChatDlg::ComboMyChatStatus_SelectedIndexChanged)

	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_CONTACTS, &CChatDlg::OnListClickedContact)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL CChatDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlListContact.InsertColumn(0, "Contact", 0, 80);
	m_ctrlListContact.InsertColumn(1, "Status", 0, 160);

	m_ctrlListContact.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_AUTOSIZECOLUMNS);

	return TRUE; 
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::LoadContactAll()
{
	m_ctrlListContact.DeleteAllItems();

	CStringList objList;
	CStoreChat::GetContactAll(objList);

	while(!objList.IsEmpty())
	{
		CString sContactName = objList.RemoveHead();
		
		m_pVaxUserAgentSIP->ChatAddContact(sContactName);
		m_ctrlListContact.InsertItemRow(m_ctrlListContact.GetItemCount(), sContactName);
	}

	if(m_ctrlListContact.GetSelectedCount() == 0 && m_ctrlListContact.GetItemCount() != 0)
		m_ctrlListContact.SetItemStateSel(0);
}

void CChatDlg::OnVaxOnline()
{
	UpdateStatusCombo();
		
	GetDlgItem(IDC_LABEL_CHAT_TYPING)->SetWindowText("");
	m_bTyping = FALSE;

	LoadContactAll();
}

void CChatDlg::OnVaxOffline()
{
	KillTimer(CHAT_TYPING_TIMER); 

	m_ctrlListContact.DeleteAllItems();
	m_ctrlComboMyChatStatus.ResetContent();
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::UpdateStatusCombo()
{
	m_ctrlComboMyChatStatus.ResetContent();
	
	m_ctrlComboMyChatStatus.InsertString(VAX_CONTACT_STATUS_ONLINE, "Online");
	m_ctrlComboMyChatStatus.InsertString(VAX_CONTACT_STATUS_OFFLINE, "Offline");
	m_ctrlComboMyChatStatus.InsertString(VAX_CONTACT_STATUS_AWAY, "Away");
	m_ctrlComboMyChatStatus.InsertString(VAX_CONTACT_STATUS_ON_PHONE, "On the phone");
	m_ctrlComboMyChatStatus.InsertString(VAX_CONTACT_STATUS_BUSY, "Busy");

	m_ctrlComboMyChatStatus.SetCurSel(VAX_CONTACT_STATUS_OFFLINE);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnBtnClickedAddContact()
{
	UpdateData(TRUE);

	if(!m_pVaxUserAgentSIP->ChatAddContact(m_sEditContactName))
		return;
    
	m_ctrlListContact.InsertItemRow(m_ctrlListContact.GetItemCount(), m_sEditContactName);
	CStoreChat::AddContact(m_sEditContactName);

	if(m_ctrlListContact.GetSelectedCount() == 0 && m_ctrlListContact.GetItemCount() != 0)
		m_ctrlListContact.SetItemStateSel(0);

    m_sEditContactName = "";
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnBtnClickedRemoveContact()
{
	CString sContactName; int nContactIndex;
	if(!GetSelectedContact(sContactName, &nContactIndex)) return;
	
	int nResult = MessageBox("Do you really want to remove this Contact?", "Caution", MB_ICONQUESTION|MB_YESNO);
	if(nResult == IDNO) return;

	m_pVaxUserAgentSIP->ChatRemoveContact(sContactName);

	m_ctrlListContact.DeleteItem(nContactIndex);
	CStoreChat::RemoveContact(sContactName);

	if(m_ctrlListContact.GetSelectedCount() == 0 && m_ctrlListContact.GetItemCount() != 0)
		m_ctrlListContact.SetItemStateSel(0);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnListClickedContact(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;

	if ((pNMLV->uChanged & LVIF_STATE) != LVIF_STATE)
		return; 

	if (!(pNMLV->uNewState & LVIS_SELECTED) || (pNMLV->uOldState & LVIS_SELECTED))
		return;

	CString sContactName;
	if(!GetSelectedContact(sContactName, NULL)) return;

	LoadContactMsgAll(sContactName);
}

void CChatDlg::LoadContactMsgAll(LPCTSTR sContactName)
{
	m_ctrlListMessage.ResetContent();

    CStringList objList;
    CStoreChat::GetMsgAll(sContactName, objList);

	while(!objList.IsEmpty())
    {
		CString sMsg = objList.RemoveHead();
		m_ctrlListMessage.AddString(sMsg);
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL CChatDlg::GetSelectedContact(CString& sContactName, int* pContactIndex)
{
	int nIndex = m_ctrlListContact.GetCurSelItem();
	if(nIndex == -1) return FALSE;
	
	if(pContactIndex != NULL)
		*pContactIndex = nIndex;

	sContactName = m_ctrlListContact.GetItemText(nIndex, 0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::ComboMyChatStatus_SelectedIndexChanged()
{
   if(m_ctrlComboMyChatStatus.GetCurSel() == -1) return;

   m_pVaxUserAgentSIP->ChatSetMyStatus(m_ctrlComboMyChatStatus.GetCurSel());
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnBtnClickedSendMessage()
{
	UpdateData(TRUE);
	
	CString sContactName;
	if(!GetSelectedContact(sContactName, NULL)) return;

    if(!m_pVaxUserAgentSIP->ChatSendMessageText(sContactName, m_sEditSendChatMessage))
		return;
    
	CString sMsg = "Me:" + m_sEditSendChatMessage;

	m_ctrlListMessage.AddString(sMsg);
	CStoreChat::AddMsg(sContactName, sMsg);

    m_sEditSendChatMessage = "";
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnChatSendMsgTextSuccess(LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue)
{
    AddToStatusLog("Send Message Success.");
}

void CChatDlg::OnChatSendMsgTextFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue)
{
    AddToStatusLog("Send Message Failed.");
}

void CChatDlg::AddToStatusLog(LPCTSTR sChatLog)
{
	m_ctrlListStatusLog.AddString(sChatLog);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnBtnClickedClearChat()
{
	CString sContactName;
	if(!GetSelectedContact(sContactName, NULL)) return;

	m_ctrlListMessage.ResetContent();
	CStoreChat::RemoveMsgAll(sContactName);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

CString CChatDlg::GetStatusText(int nStatusId)
{
    CString sStatus = "";

    switch (nStatusId)
    {
        case VAX_CONTACT_STATUS_ONLINE:
            sStatus = "Online";
            break;

        case VAX_CONTACT_STATUS_OFFLINE:
			sStatus = "Offline";
            break;

        case VAX_CONTACT_STATUS_AWAY:
            sStatus = "Away";
            break;

        case VAX_CONTACT_STATUS_ON_PHONE:
            sStatus = "On the phone";
            break;

        case VAX_CONTACT_STATUS_BUSY:
            sStatus = "Busy";
            break;

		 case VAX_CONTACT_STATUS_UNKNOWN:
            sStatus = "";
            break;
    }

    return sStatus;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnChatSubscribeSuccess(LPCTSTR sUserName)
{
	AddToStatusLog("Chat Subscribe " + CString(sUserName) + " Success.");
}
        
void CChatDlg::OnChatSubscribeFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase)
{
	AddToStatusLog("Chat Subscribe " + CString(sUserName) + " Failed.");
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnChatContactStatus(LPCTSTR sUserName, int nStatusId)
{
	int nIndex = m_ctrlListContact.FindItemIndex(sUserName);
	if(nIndex == -1) return;

	m_ctrlListContact.SetItemText(nIndex, 1, GetStatusText(nStatusId));
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnChatRecvMsgText(CString sUserName, CString sMsgText)
{
	int nStart = sMsgText.Find(">");

	CString sMessage;

    if(nStart == -1)
    {
		sMessage = sUserName + ": " + sMsgText;
    }
	else
	{
		// Remote softphone is sending HTML based text messages

		nStart = nStart + 1;
		int nEnd = sMsgText.Find("<", nStart);

		sMessage = sUserName + ": " + sMsgText.Mid(nStart, nEnd - nStart);
	}

	m_ctrlListMessage.AddString(sMessage);
	CStoreChat::AddMsg(sUserName, sMessage);
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnChatRecvMsgTypingStart(CString sUserName)
{
    m_bTyping = TRUE;

	GetDlgItem(IDC_LABEL_CHAT_TYPING)->SetWindowText(sUserName + ": Typing");

	KillTimer(CHAT_TYPING_TIMER);
	SetTimer(CHAT_TYPING_TIMER, 2000, NULL); 

    AdjustTypingState();
}

void CChatDlg::OnTimer(UINT_PTR nIDEvent)
{
	AdjustTypingState();
}

void CChatDlg::AdjustTypingState()
{
	if (!m_bTyping)
    {
		KillTimer(CHAT_TYPING_TIMER);
		OnChatRecvMsgTypingStop();
	}
	else
	{
		m_bTyping = false;
	}
}

void CChatDlg::OnChatRecvMsgTypingStop()
{
    GetDlgItem(IDC_LABEL_CHAT_TYPING)->SetWindowText("");
}

////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnChangeEditMessage()
{
	CString sContactName;
	if(!GetSelectedContact(sContactName, NULL)) return;

	m_pVaxUserAgentSIP->ChatSendMessageTyping(sContactName);
}

void CChatDlg::OnChatSendMsgTypingSuccess(LPCTSTR sUserName, UINT64 nUserValue)
{
	AddToStatusLog("Send Typing to " + CString(sUserName) + " Success.");
}
        
void CChatDlg::OnChatSendMsgTypingFailed(LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue)
{
	AddToStatusLog("Send Typing to " + CString(sUserName) + " Failed.");
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

void CChatDlg::OnBtnClickedClearLog()
{
	m_ctrlListStatusLog.ResetContent();
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL CChatDlg::OnApply()
{
	return FALSE;
}

