// RecAccountDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "MainAccountRecDlg.h"
#include "afxdialogex.h"
#include "VaxSIPUserAgentLibEx.h"
#include "StoreAccountREC.h"

// CMainAccountRecDlg dialog

IMPLEMENT_DYNAMIC(CMainAccountRecDlg, CPropertyPage)

CMainAccountRecDlg::CMainAccountRecDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent): CPropertyPage(CMainAccountRecDlg::IDD)
{
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	
	m_sEditUserName = "";
	m_sEditDisplayName = "";

	m_sEditAuthLogin = "";
	m_sEditAuthPwd = "";

	m_sEditDomainRealm = "";

	m_sEditServerAddr = "";
	m_sEditServerPort = "5060";

	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_NULL, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Verdana");
		
	m_bCheckRegisterToServerREC = TRUE;
	m_bBtnAdvanceShow = TRUE;
}

CMainAccountRecDlg::~CMainAccountRecDlg()
{
}

void CMainAccountRecDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_ONLINE, m_ctrlBtnOnline);
	DDX_Control(pDX, IDC_BTN_ADVANCE, m_ctrlBtnAdvance);

	DDX_Text(pDX, IDC_EDIT_USER_NAME, m_sEditUserName);
	DDX_Text(pDX, IDC_EDIT_AUTH_LOGIN, m_sEditAuthLogin);
	DDX_Text(pDX, IDC_EDIT_DISPLAY_NAME, m_sEditDisplayName);
	DDX_Text(pDX, IDC_EDIT_AUTH_PASSWORD, m_sEditAuthPwd);
	DDX_Text(pDX, IDC_EDIT_DOMAIN_REALM, m_sEditDomainRealm);

	DDX_Text(pDX, IDC_EDIT_SERVER_ADDR, m_sEditServerAddr);
	DDX_Text(pDX, IDC_EDIT_SERVER_PORT, m_sEditServerPort);

	DDX_Check(pDX, IDC_CHECK_REGISTER_SIP_PROXY, m_bCheckRegisterToServerREC);
	DDX_Control(pDX, IDC_LIST_STATUS_LOG, m_ctrlListBoxStatusStatus);

	GetDlgItem(IDC_GROUP_SIP_ACCOUNT_REC_SETTING)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_ACCOUNT_REC_STATUS_LOG)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_ACCOUNT_REC_STATUS_LOG2)->SetFont(&m_objFont);

	DDX_Control(pDX, IDC_LIST_CALL_LOG, m_ctrlListBoxCallLog);
}

BEGIN_MESSAGE_MAP(CMainAccountRecDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_ONLINE, &CMainAccountRecDlg::OnBtnOnlineClicked)
	ON_BN_CLICKED(IDC_BTN_CALL_LOG_CLEAR, &CMainAccountRecDlg::OnBtnClearCallLogClicked)
	ON_BN_CLICKED(IDC_BTN_STATUS_LOG_CLEAR, &CMainAccountRecDlg::OnBtnClearStatusStatusClicked)
	ON_BN_CLICKED(IDC_BTN_ADVANCE, &CMainAccountRecDlg::OnBtnAdvanceClicked)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

BOOL CMainAccountRecDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	int nServerPort = 5060;
	
	CStoreAccountREC::GetAccountInfo(m_sEditDisplayName, m_sEditUserName, m_sEditAuthLogin, m_sEditAuthPwd, m_sEditDomainRealm, m_sEditServerAddr, nServerPort, m_bCheckRegisterToServerREC);
	m_sEditServerPort.Format("%d", nServerPort);
		
	UpdateData(FALSE);
	return TRUE;
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnBtnOnlineClicked()
{
	CString sBtnOnlineText;
	m_ctrlBtnOnline.GetWindowText(sBtnOnlineText);

	if(sBtnOnlineText == "Offline")
	{
		m_pVaxUserAgentSIP->UnRegisterAccountREC();
		m_ctrlBtnOnline.SetWindowText("Online");

		return;
    }
       
    UpdateData(TRUE);

	if(m_sEditAuthLogin.IsEmpty())
	{
		MessageBox("Invalid auth Login.", "VaxVoIP SDK", MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	if(m_sEditServerAddr.IsEmpty())
	{
		MessageBox("Invalid SIP server domain or IP address.", "VaxVoIP SDK", MB_OK|MB_ICONEXCLAMATION);
		return;
	}
    
	CStoreAccountREC::AddAccountInfo(m_sEditDisplayName, m_sEditUserName, m_sEditAuthLogin, m_sEditAuthPwd, m_sEditDomainRealm, m_sEditServerAddr, ::atoi(m_sEditServerPort), m_bCheckRegisterToServerREC);

	if(!m_pVaxUserAgentSIP->RegisterAccountREC(m_bCheckRegisterToServerREC, m_sEditDisplayName, m_sEditUserName, m_sEditAuthLogin, m_sEditAuthPwd, m_sEditDomainRealm, m_sEditServerAddr, ::atoi(m_sEditServerPort)))
		return;
			
	if(m_bCheckRegisterToServerREC)
		AddToStatusLog("Registering to SIP Server REC.");

	m_ctrlBtnOnline.SetWindowText("Offline");
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnBtnAdvanceClicked()
{
	if (m_bBtnAdvanceShow)
	{
		m_bBtnAdvanceShow = FALSE;
		m_ctrlBtnAdvance.SetWindowText("Basic");
		
		ShowAdvance(TRUE);
		return;
	}

	m_bBtnAdvanceShow = TRUE;
	m_ctrlBtnAdvance.SetWindowText("Advance");

	ShowAdvance(FALSE);
}

void CMainAccountRecDlg::ShowAdvance(BOOL bShow)
{
	CWnd* pWnd = NULL;
	
	if(bShow)
	{
		pWnd = GetDlgItem(IDC_STATIC_DISPLAY_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_EDIT_DISPLAY_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_STATIC_USER_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_EDIT_USER_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_STATIC_DOMAIN_REALM);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_EDIT_DOMAIN_REALM);
		pWnd->ShowWindow(SW_SHOW);

		return;
	}

	pWnd = GetDlgItem(IDC_STATIC_DISPLAY_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_EDIT_DISPLAY_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_STATIC_USER_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_EDIT_USER_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_STATIC_DOMAIN_REALM);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_EDIT_DOMAIN_REALM);
	pWnd->ShowWindow(SW_HIDE);
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::AddToStatusLog(LPCTSTR sStatus)
{
	m_ctrlListBoxStatusStatus.AddString(sStatus);
}

void CMainAccountRecDlg::AddToCallLog(LPCTSTR sStatus)
{
	m_ctrlListBoxCallLog.AddString(sStatus);
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnBtnClearStatusStatusClicked()
{
	m_ctrlListBoxStatusStatus.ResetContent();
}

void CMainAccountRecDlg::OnBtnClearCallLogClicked()
{
	m_ctrlListBoxCallLog.ResetContent();
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnConnectingToRegister()
{
	AddToStatusLog("Connecting to register.");
}

void CMainAccountRecDlg::OnTryingToRegister()
{
	AddToStatusLog("Trying to register.");
}

void CMainAccountRecDlg::OnFailToRegister(int nStatusCode, LPCTSTR sReasonPhrase)
{
	AddToStatusLog("Failed: " + CString(sReasonPhrase));
}

void CMainAccountRecDlg::OnSuccessToRegister()
{
	AddToStatusLog("Success to register.");
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnTryingToReRegister()
{
	AddToStatusLog("Trying to Re-Register.");
}

void CMainAccountRecDlg::OnFailToReRegister(int nStatusCode, LPCTSTR sReasonPhrase)
{
	AddToStatusLog("Failed: " + CString(sReasonPhrase));
}

void CMainAccountRecDlg::OnSuccessToReRegister()
{
	 AddToStatusLog("Success to Re-Register.");
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnTryingToUnRegister()
{
	AddToStatusLog("Trying to Unregister.");
}

void CMainAccountRecDlg::OnFailToUnRegister()
{
	 AddToStatusLog("Fail to unregister.");
}

void CMainAccountRecDlg::OnSuccessToUnRegister()
{
	AddToStatusLog("Unregistered successfully.");
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
		
void CMainAccountRecDlg::OnDialCallStarted(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo)
{
	CString sStatus;
	sStatus.Format("Line-%d: Dialing.", nLineNo + 1);

	AddToCallLog(sStatus);
}

void CMainAccountRecDlg::OnDialingCall(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	CString sStatus;
	sStatus.Format("Line-%d: Response: %s.", nLineNo + 1, sReasonPhrase);

	AddToCallLog(sStatus);
}

void CMainAccountRecDlg::OnConnectedCall(int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort)
{
	CString sStatus;
	sStatus.Format("Line-%d: Success to connect.", nLineNo + 1);

	AddToCallLog(sStatus);
}

void CMainAccountRecDlg::OnDialCallFailed(int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase)
{
	CString sStatus;
	sStatus.Format("Line-%d: Response: %s.", nLineNo + 1, sReasonPhrase);

	AddToCallLog(sStatus);
}

void CMainAccountRecDlg::OnHungupCall(int nLineNo)
{
	CString sStatus;
	sStatus.Format("Line-%d: Hang up.", nLineNo + 1);

	AddToCallLog(sStatus);
}

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

void CMainAccountRecDlg::OnStatusMsg(int nLineNo, DWORD dwErrorCode, CString sErrorMsg)
{
	CString sStatus;
	sStatus.Format("Line-%d: %s.", nLineNo + 1, sErrorMsg);

	AddToCallLog(sStatus);
}