// MainAccountDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VaxVoIP.h"
#include "MainAccountDlg.h"
#include "afxdialogex.h"
#include "VaxSIPUserAgentLibEx.h"
#include "StoreAccount.h"

//.\;.\VaxStoreINFO;.\AccountForm;\AccountRecForm;.\BusyLampForm;.\ChatForm;.\MainForm;.\PhoneForm;.\SettingForm;

IMPLEMENT_DYNAMIC(CMainAccountDlg, CPropertyPage)

CMainAccountDlg::CMainAccountDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent) : CPropertyPage(CMainAccountDlg::IDD)
{
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	
	m_sEditUserName = "";
	m_sEditDisplayName = "";

	m_sEditAuthLogin = "";
	m_sEditAuthPwd = "";

	m_sEditDomainRealm = "";
	m_sEditServerAddr = "";

	m_sLabelServerPort = "";
	m_sEditServerPort = "5060";

	m_sLabelIsMsgWaiting = "No";
	m_sLabelNewMsgs = "0";
	m_sLabelOldMsgs = "0";

	m_bCheckRegisterToServerSIP = TRUE;
	m_bCheckCaptureSoundDevice = TRUE;

	m_bBtnAdvanceShow = TRUE;
	m_psp.dwFlags &= ~PSP_HASHELP; 

	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana"); 
}

CMainAccountDlg::~CMainAccountDlg()
{

}

void CMainAccountDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_BTN_ONLINE, m_ctrlBtnOnline);
	DDX_Control(pDX, IDC_BTN_ADVANCE, m_ctrlBtnAdvance);

	DDX_Text(pDX, IDC_EDIT_USER_NAME, m_sEditUserName);
	DDX_Text(pDX, IDC_EDIT_DISPLAY_NAME, m_sEditDisplayName);

	DDX_Text(pDX, IDC_EDIT_AUTH_LOGIN, m_sEditAuthLogin);
	DDX_Text(pDX, IDC_EDIT_AUTH_PASSWORD, m_sEditAuthPwd);
	DDX_Text(pDX, IDC_EDIT_DOMAIN_REALM, m_sEditDomainRealm);

	DDX_Text(pDX, IDC_EDIT_SERVER_ADDR, m_sEditServerAddr);
	DDX_Text(pDX, IDC_EDIT_SERVER_PORT, m_sEditServerPort);

	DDX_Check(pDX, IDC_CHECK_REGISTER_SIP_PROXY, m_bCheckRegisterToServerSIP);
	DDX_Check(pDX, IDC_CHECK_CAPTURE_SOUND_DEVICE, m_bCheckCaptureSoundDevice);
	DDX_Control(pDX, IDC_LIST_STATUS_LOG, m_ctrlListBoxStatusLog);

	DDX_Control(pDX, IDC_COMBO_SERVER_TYPE, m_ctrlComboServerType);
	DDX_Text(pDX, IDC_STATIC_SERVER_PORT, m_sLabelServerPort);

	GetDlgItem(IDC_GROUP_ACCOUNT_SIP)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_STATUS_LOG)->SetFont(&m_objFont);
	GetDlgItem(IDC_GROUP_VOICE_MAIL_BOX)->SetFont(&m_objFont);
	DDX_Text(pDX, IDC_STATIC_MSG_WAITING_YES_NO, m_sLabelIsMsgWaiting);
	DDX_Text(pDX, IDC_STATIC_NEW_MSG_COUNT, m_sLabelNewMsgs);
	DDX_Text(pDX, IDC_STATIC_OLD_MSG_COUNT, m_sLabelOldMsgs);
}

BEGIN_MESSAGE_MAP(CMainAccountDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_ONLINE, &CMainAccountDlg::OnBtnOnlineClicked)
	ON_BN_CLICKED(IDC_BTN_ACCOUNT_CLEAR, &CMainAccountDlg::OnBtnClearStatusLogClicked)
	ON_BN_CLICKED(IDC_BTN_ADVANCE, &CMainAccountDlg::OnBtnAdvanceClicked)
	ON_BN_CLICKED(IDC_BTN_DEMO_ACCOUNT, &CMainAccountDlg::OnBtnDemoAccountClicked)
	ON_CBN_SELCHANGE(IDC_COMBO_SERVER_TYPE, &CMainAccountDlg::OnCbnSelchangeComboServerType)
	ON_WM_HSCROLL()
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

BOOL CMainAccountDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	
	m_ctrlComboServerType.ResetContent();
	m_ctrlComboServerType.InsertString(0, "UDP");
	m_ctrlComboServerType.InsertString(1, "TCP");
	m_ctrlComboServerType.InsertString(2, "TLS");
	
	m_ctrlComboServerType.SetCurSel(0);

	int nServerPort = 5060;
	int nServerType = VAX_ACCOUNT_TYPE_UDP;	

	CStoreAccount::GetAccountInfo(m_sEditDisplayName, m_sEditUserName, m_sEditAuthLogin, m_sEditAuthPwd, m_sEditDomainRealm, m_sEditServerAddr, nServerPort, nServerType, m_bCheckRegisterToServerSIP);
	m_sEditServerPort.Format("%d", nServerPort);
		
	UpdateData(FALSE);
	UpdateServerType(nServerType);

	return TRUE;
}

void CMainAccountDlg::OnBtnOnlineClicked()
{
	CString sBtnOnlineText;
	m_ctrlBtnOnline.GetWindowText(sBtnOnlineText);

	if(sBtnOnlineText == "Offline")
	{
		m_ctrlBtnOnline.SetWindowText("Online");
		m_pVaxUserAgentSIP->UnInitialize();

        return;
    }
       
    UpdateData(TRUE);

	if(m_sEditAuthLogin.IsEmpty())
	{
		MessageBox("Invalid auth Login.", "VaxVoIP SDK", MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	if(m_sEditServerAddr.IsEmpty())
	{
		MessageBox("Invalid SIP server domain or IP address.", "VaxVoIP SDK", MB_OK|MB_ICONEXCLAMATION);
		return;
	}
 
	int nServerType = GetServerType();

    BOOL bResult = m_pVaxUserAgentSIP->Initialize(m_sEditDisplayName, m_sEditUserName, m_sEditAuthLogin, m_sEditAuthPwd, m_sEditDomainRealm, m_sEditServerAddr, ::atoi(m_sEditServerPort), nServerType, m_bCheckRegisterToServerSIP, m_bCheckCaptureSoundDevice);

    if(!bResult)
	{
	    return;
	}

	if(!m_bCheckRegisterToServerSIP)
    {
		AddToStatusLog("Account is online.");
    }

	m_ctrlBtnOnline.SetWindowText("Offline");
		
	CStoreAccount::AddAccountInfo(m_sEditDisplayName, m_sEditUserName, m_sEditAuthLogin, m_sEditAuthPwd, m_sEditDomainRealm, m_sEditServerAddr, ::atoi(m_sEditServerPort), nServerType, m_bCheckRegisterToServerSIP);
}

void CMainAccountDlg::OnBtnClearStatusLogClicked()
{
	m_ctrlListBoxStatusLog.ResetContent();
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::AddToStatusLog(LPCTSTR sStatus)
{
	m_ctrlListBoxStatusLog.AddString(sStatus);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnNetworkReachability(BOOL bAvailable)
{
	if(bAvailable)
		AddToStatusLog("Network is available");
	else
		AddToStatusLog("Network is not available");
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnConnectingToRegister()
{
	AddToStatusLog("Connecting to register.");
}

void CMainAccountDlg::OnTryingToRegister()
{
    AddToStatusLog("Trying to register.");
}

void CMainAccountDlg::OnFailToRegister(int nStatusCode, LPCTSTR sReasonPhrase)
{
    AddToStatusLog("Failed: " + CString(sReasonPhrase));
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnSuccessToRegister()
{
    AddToStatusLog("Success to register.");
}

void CMainAccountDlg::OnConnectingToReRegister()
{
	AddToStatusLog("Connecting to re-register.");
}

void CMainAccountDlg::OnTryingToReRegister()
{
	AddToStatusLog("Trying to Re-Register.");	
}

void CMainAccountDlg::OnFailToReRegister(int nStatusCode, LPCTSTR sReasonPhrase)
{
    AddToStatusLog("Failed: " + CString(sReasonPhrase));
}

void CMainAccountDlg::OnSuccessToReRegister()
{
    AddToStatusLog("Success to Re-Register.");
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnTryingToUnRegister()
{
    AddToStatusLog("Trying to Unregister.");
}

void CMainAccountDlg::OnFailToUnRegister()
{
    AddToStatusLog("Fail to unregister.");
}

void CMainAccountDlg::OnSuccessToUnRegister()
{
    AddToStatusLog("Unregistered successfully.");
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnVoiceMailMsg(int bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, LPCTSTR sMsgAccount)
{
	if (bIsMsgWaiting)
	{
		m_sLabelIsMsgWaiting = "Yes";
    }
    else
	{
		m_sLabelIsMsgWaiting = "No";
	}

	m_sLabelNewMsgs.Format("%d", nNewMsgCount);
	m_sLabelOldMsgs.Format("%d", nOldMsgCount);
			
	UpdateData(FALSE);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnBtnAdvanceClicked()
{
	if(m_bBtnAdvanceShow)
	{
		m_bBtnAdvanceShow = FALSE;
		m_ctrlBtnAdvance.SetWindowText("Basic");

		ShowAdvance(TRUE);
		return;
	}

	m_bBtnAdvanceShow = TRUE;
	m_ctrlBtnAdvance.SetWindowText("Advance");

	ShowAdvance(FALSE);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::ShowAdvance(BOOL bShow)
{
	CWnd* pWnd = NULL;
	
	if(bShow)
	{
		pWnd = GetDlgItem(IDC_STATIC_DISPLAY_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_EDIT_DISPLAY_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_STATIC_USER_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_EDIT_USER_NAME);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_STATIC_DOMAIN_REALM);
		pWnd->ShowWindow(SW_SHOW);

		pWnd = GetDlgItem(IDC_EDIT_DOMAIN_REALM);
		pWnd->ShowWindow(SW_SHOW);

		return;
	}

	pWnd = GetDlgItem(IDC_STATIC_DISPLAY_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_EDIT_DISPLAY_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_STATIC_USER_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_EDIT_USER_NAME);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_STATIC_DOMAIN_REALM);
	pWnd->ShowWindow(SW_HIDE);

	pWnd = GetDlgItem(IDC_EDIT_DOMAIN_REALM);
	pWnd->ShowWindow(SW_HIDE);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnBtnDemoAccountClicked()
{
	UpdateData(TRUE);
	
	time_t nTime;
	time(&nTime);

	nTime = nTime % 9999999;

	CString sAccountDemo;
	sAccountDemo.Format("%d", nTime);

	m_sEditAuthLogin = sAccountDemo;
	m_sEditAuthPwd = sAccountDemo;
	
	m_sEditServerAddr = "demo.vaxvoip.com";
	m_sEditServerPort = "8060";

	m_bCheckRegisterToServerSIP = TRUE;
	UpdateData(FALSE);
	
	UpdateServerType(VAX_ACCOUNT_TYPE_UDP);
		
	CString sDemoMsg;

	sDemoMsg = "\n" + CString("Auth Login: ") + sAccountDemo + "\n";
    sDemoMsg = sDemoMsg + CString("Auth Password: ") + sAccountDemo + "\n";
    sDemoMsg = sDemoMsg + CString("Server Addr: ") + m_sEditServerAddr + "\n";
    sDemoMsg = sDemoMsg + CString("Server Port: ") + m_sEditServerPort + "\n \n";
	
	UpdateData(FALSE);

	MessageBox(sDemoMsg + "Demo accounts are only for account-to-account VoIP calls. Use demo accounts on different devices to dial/receive VoIP calls.\n\nDial 000 for self testing.\n\n[Powered by VaxVoIP Server SDK]", "VaxVoIP SIP SDK", MB_OK|MB_ICONEXCLAMATION);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::UpdateServerType(int nServerType)
{
	UpdateData(TRUE);
	
	if (nServerType == VAX_ACCOUNT_TYPE_UDP)
	{
		m_ctrlComboServerType.SetCurSel(0);
        m_sLabelServerPort = "Server Port UDP (Default: 5060)";
	}
	else if (nServerType == VAX_ACCOUNT_TYPE_TCP)
	{
		m_ctrlComboServerType.SetCurSel(1);
		m_sLabelServerPort = "Server Port TCP (Default: 5060)";
	}
	else if (nServerType == VAX_ACCOUNT_TYPE_TLS)
	{
		m_ctrlComboServerType.SetCurSel(2);
		m_sLabelServerPort = "Server Port TLS (Default: 5061)";
	}

	if (m_sEditServerAddr == "demo.vaxvoip.com")
	{
		if (nServerType == VAX_ACCOUNT_TYPE_TLS)
			m_sEditServerPort = "8061";
		else
			m_sEditServerPort = "8060";
	}
	else if (m_sEditServerPort == "5060" || m_sEditServerPort == "5061" || m_sEditServerPort.IsEmpty())
	{
		if (nServerType == VAX_ACCOUNT_TYPE_TLS)
			m_sEditServerPort = "5061";
		else
			m_sEditServerPort = "5060";
	}

	UpdateData(FALSE);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

int CMainAccountDlg::GetServerType()
{
	int nSelectedIndex = m_ctrlComboServerType.GetCurSel();

	if (nSelectedIndex == 0)
		return VAX_ACCOUNT_TYPE_UDP;

	if (nSelectedIndex == 1)
		return VAX_ACCOUNT_TYPE_TCP;

	if (nSelectedIndex == 2)
		return VAX_ACCOUNT_TYPE_TLS;

	return VAX_ACCOUNT_TYPE_UDP;
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

void CMainAccountDlg::OnCbnSelchangeComboServerType()
{
	int nServerType = GetServerType();
	UpdateServerType(nServerType);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CMainAccountDlg::OnApply()
{
	return FALSE;
	//return CPropertyPage::OnApply();
}