unit MainVideoForm;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
  VaxSIPUserAgentExCOM,
  Vcl.OleCtrls,
  VaxSIPUserAgentShowOCXLib_TLB;

type
  TMainVideoForm = class(TForm)
    GroupBoxPreview: TGroupBox;
    LabelPreview: TLabel;
    LabelScreen1: TLabel;
    GroupBoxScreen1: TGroupBox;
    LabelScreen2: TLabel;
    GroupBoxScreen2: TGroupBox;
    LabelScreen3: TLabel;
    GroupBoxScreen3: TGroupBox;
    LabelScreen4: TLabel;
    GroupBoxScreen4: TGroupBox;
    LabelScreen5: TLabel;
    GroupBoxScreen5: TGroupBox;
    CheckBoxActivate: TCheckBox;

    VaxVideoPreview: TVaxSIPUserAgentShowOCX;
    VaxVideoScreen1: TVaxSIPUserAgentShowOCX;
    VaxVideoScreen2: TVaxSIPUserAgentShowOCX;
    VaxVideoScreen3: TVaxSIPUserAgentShowOCX;
    VaxVideoScreen4: TVaxSIPUserAgentShowOCX;
    VaxVideoScreen5: TVaxSIPUserAgentShowOCX;

    constructor Create(objTabSheetVideo: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);overload;

    procedure OnVaxOnline();
    procedure OnVaxOffline();

    procedure ActivateVideoPreview();
    procedure CheckBoxActivateClick(Sender: TObject);

    procedure OnVideoRemoteStarted(nLineNo: Integer);
    procedure OnVideoRemoteEnded(nLineNo: Integer);

    procedure OnVideoRemoteFrameRGB(nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
    procedure OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);

    procedure FormShow(Sender: TObject);

  private
    { Private declarations }

    m_objVaxCOM : TVaxSIPUserAgentExCOM;

  public
    { Public declarations }
  end;

var
  FormVideo: TMainVideoForm;

implementation

{$R *.dfm}

constructor TMainVideoForm.Create(objTabSheetVideo: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);
var
  onClickHandler : TNotifyEvent;
begin

  inherited Create(objTabSheetVideo);
  m_objVaxCOM := objVaxCOM;

  onClickHandler := CheckBoxActivate.OnClick;
  CheckBoxActivate.OnClick := nil;
  CheckBoxActivate.Checked := True;
  CheckBoxActivate.OnClick := onClickHandler;

end;

procedure TMainVideoForm.FormShow(Sender: TObject);
begin

  VaxVideoPreview.DisplayOpen();

  VaxVideoScreen1.DisplayOpen();
  VaxVideoScreen2.DisplayOpen();
  VaxVideoScreen3.DisplayOpen();
  VaxVideoScreen4.DisplayOpen();
  VaxVideoScreen5.DisplayOpen();

end;

////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

procedure TMainVideoForm.OnVaxOnline();
begin

  ActivateVideoPreview();

end;

procedure TMainVideoForm.OnVaxOffline();
begin

  VaxVideoPreview.DisplayClose();

  VaxVideoScreen1.DisplayClose();
  VaxVideoScreen2.DisplayClose();
  VaxVideoScreen3.DisplayClose();
  VaxVideoScreen4.DisplayClose();
  VaxVideoScreen5.DisplayClose();

end;

////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

procedure TMainVideoForm.ActivateVideoPreview();
begin

  if CheckBoxActivate.Checked = true then
  begin

    VaxVideoPreview.DisplayOpen();
    m_objVaxCOM.ActivateVideoDevice(true);

  end
  else
  begin

    VaxVideoPreview.DisplayClose();
    m_objVaxCOM.CloseVideoDev();

  end;

end;

procedure TMainVideoForm.CheckBoxActivateClick(Sender: TObject);
begin

  ActivateVideoPreview();

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainVideoForm.OnVideoRemoteStarted(nLineNo: Integer);
  begin

    {
    if nLineNo = 0 then
        VaxVideoScreen1.DisplayOpen();

    if nLineNo = 1 then
        VaxVideoScreen2.DisplayOpen();

    if nLineNo = 2 then
        VaxVideoScreen3.DisplayOpen();

    if nLineNo = 3 then
        VaxVideoScreen4.DisplayOpen();

    if nLineNo = 4 then
        VaxVideoScreen5.DisplayOpen();
     }
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainVideoForm.OnVideoRemoteEnded(nLineNo: Integer);
  begin

    {
    if nLineNo = 0 then
        VaxVideoScreen1.DisplayClose();

    if nLineNo = 1 then
        VaxVideoScreen2.DisplayClose();

    if nLineNo = 2 then
        VaxVideoScreen3.DisplayClose();

    if nLineNo = 3 then
        VaxVideoScreen4.DisplayClose();

    if nLineNo = 4 then
        VaxVideoScreen5.DisplayClose();
     }
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainVideoForm.OnVideoRemoteFrameRGB(nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  begin

    if nLineNo = 0 then
      VaxVideoScreen1.DisplayFrameRGB(nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);

    if nLineNo = 1 then
      VaxVideoScreen2.DisplayFrameRGB(nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);

    if nLineNo = 2 then
      VaxVideoScreen3.DisplayFrameRGB(nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);

    if nLineNo = 3 then
      VaxVideoScreen4.DisplayFrameRGB(nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);

    if nLineNo = 4 then
      VaxVideoScreen5.DisplayFrameRGB(nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainVideoForm.OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  begin
    VaxVideoPreview.DisplayFrameRGB(nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
  end;

end.
