unit StorePhoneNo;

interface

uses
StoreRegistry;

type TStorePhoneNo = class

const ROOT_PATH = 'PhoneNo';

public

  class function AddPhoneNo(sPhoneNo: String): Boolean; static;
  class procedure GetPhoneNo(var sPhoneNo: String); static;

end;

implementation

  class function TStorePhoneNo.AddPhoneNo(sPhoneNo: String): Boolean;
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

    sKeyPath := ROOT_PATH;
    objStore := TStoreRegistry.Create();

    Result := objStore.SetTEXT(sKeyPath, 'PhoneNo', sPhoneNo);
    objStore.Destroy();

  end;

  class procedure TStorePhoneNo.GetPhoneNo(var sPhoneNo: String);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

    sKeyPath := ROOT_PATH;
    objStore := TStoreRegistry.Create();

    objStore.GetTEXT(sKeyPath, 'PhoneNo', sPhoneNo, '');
    objStore.Destroy();

  end;

end.
