unit StoreBusyLamp;

interface

uses
System.SysUtils,
System.Classes,
StoreRegistry,
VaxSIPUserAgentCOM;

type TStoreBusyLamp = class

const BUSY_LAMP_ROOT_PATH = 'BusyLamp\\';

public

  class function AddContact(sContactName: String): Boolean; static;
  class procedure RemoveContact(sContactName: String); static;

  class procedure GetContactAll(var objList: TStringList); static;
  class function IsDataStored(): Boolean; static;

end;

implementation

  class function TStoreBusyLamp.AddContact(sContactName: String): Boolean;
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

   sKeyPath := BUSY_LAMP_ROOT_PATH + sContactName;
   objStore := TStoreRegistry.Create();

   objStore.SetTEXT(sKeyPath, 'ContactName', sContactName);

   objStore.Destroy();
   Result := True;

  end;

  class procedure TStoreBusyLamp.RemoveContact(sContactName: String);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

   sKeyPath := BUSY_LAMP_ROOT_PATH + sContactName;
   objStore := TStoreRegistry.Create();

   objStore.DeleteSubKey(sKeyPath);
   objStore.Destroy();

  end;

  class procedure TStoreBusyLamp.GetContactAll(var objList: TStringList);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

    sKeyPath := BUSY_LAMP_ROOT_PATH;
    objStore := TStoreRegistry.Create();

    objStore.EnumSubKeys(sKeyPath, objList);
    objStore.Destroy();

  end;

  class function TStoreBusyLamp.IsDataStored(): Boolean;
  var
    objStore: TStoreRegistry;
  begin
    objStore := TStoreRegistry.Create();
    Result := objStore.IsKeyExist(BUSY_LAMP_ROOT_PATH);
    objStore.Destroy();
  end;

end.
