unit StoreAccount;

interface

uses
StoreRegistry,
VaxSIPUserAgentCOM;

type TStoreAccount = class

const ROOT_PATH = 'AccountInfo\\';

public

  class function AddUser(sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer; nServerType: Integer; bRegSIP: Boolean): Boolean; static;
  class procedure GetUser(var sDisplayName: String; var sUserName: String; var sAuthLogin: String; var sAuthPwd: String; var sDomainRealm: String; var sServerAddr: String; var nServerPort: Integer; var nServerType: Integer; var bRegSIP: Boolean); static;

end;

implementation

  class function TStoreAccount.AddUser(sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer; nServerType: Integer; bRegSIP: Boolean): Boolean;
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

   sKeyPath := ROOT_PATH + sUserName;
   objStore := TStoreRegistry.Create();

   objStore.SetTEXT(sKeyPath, 'VaxDisplayName', sDisplayName);
   objStore.SetTEXT(sKeyPath, 'VaxUserName', sUserName);

   objStore.SetTEXT(sKeyPath, 'VaxAuthLogin', sAuthLogin);
   objStore.SetTEXT(sKeyPath, 'VaxAuthPassword', sAuthPwd);

   objStore.SetTEXT(sKeyPath, 'VaxDomainRealm', sDomainRealm);
   objStore.SetTEXT(sKeyPath, 'VaxServerAddr', sServerAddr);
   objStore.SetINT(sKeyPath, 'VaxServerPort', nServerPort);

   objStore.SetINT(sKeyPath, 'VaxServerType', nServerType);
   objStore.SetBOOL(sKeyPath, 'VaxRegisterSIP', bRegSIP);

   objStore.Destroy();
   Result := True;

  end;

  class procedure TStoreAccount.GetUser(var sDisplayName: String; var sUserName: String; var sAuthLogin: String; var sAuthPwd: String; var sDomainRealm: String; var sServerAddr: String; var nServerPort: Integer; var nServerType: Integer; var bRegSIP: Boolean);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

    sKeyPath := ROOT_PATH + sUserName;
    objStore := TStoreRegistry.Create();

    objStore.GetTEXT(sKeyPath, 'VaxDisplayName', sDisplayName, '');
    objStore.GetTEXT(sKeyPath, 'VaxUserName', sUserName, '');
    objStore.GetTEXT(sKeyPath, 'VaxAuthLogin', sAuthLogin, '');
    objStore.GetTEXT(sKeyPath, 'VaxAuthPassword', sAuthPwd, '');

    objStore.GetTEXT(sKeyPath, 'VaxDomainRealm', sDomainRealm, '');
    objStore.GetTEXT(sKeyPath, 'VaxServerAddr', sServerAddr, '');
    objStore.GetINT(sKeyPath, 'VaxServerPort', nServerPort, 5060);

    objStore.GetINT(sKeyPath, 'VaxServerType', nServerType, TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP);
    objStore.GetBOOL(sKeyPath, 'VaxRegisterSIP', bRegSIP, True);

    objStore.Destroy();

  end;

end.
