unit VaxSIPUserAgentExCOM;

interface

uses
  Winapi.Windows,
  System.Win.StdVCL,
  Vcl.Graphics,
  Winapi.ActiveX,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.OleServer,
  Vcl.Forms,
  VaxSIPUserAgentCOM;

  type

  TVaxSIPUserAgentExCOM = class(TVaxSIPUserAgentCOM)

    public
    constructor Create(objMainForm: TObject);

    function Initialize(sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer; nServerType: Integer; bRegisterSIP: Boolean; bCaptureSoundDevice: Boolean): Boolean;
    function GetTotalLine(): Integer;

    function RegisterAccountSIP(nExpire: Integer): Boolean;
    function EnableKeepAlive(nSeconds: Integer): Boolean;

    function DialCall(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String): Boolean;
    function AcceptCall(nLineNo: Integer; sCallId: String): Boolean;

    function RegisterAccountREC(bRegiter: Boolean; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDisplayName: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer): Boolean;
    procedure UnRegisterAccountREC();

  /////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////////

    procedure SetActiveVideoDevice(nDeviceId: Integer);
    procedure ActivateVideoDevice(bActivate: Boolean);

    procedure SetVideoQuality(nQuality: Integer);
    procedure CaptureVideoDevice();

    procedure SetActiveAudioInDevice(nDeviceId: Integer);
    procedure SetActiveAudioOutDevice(nDeviceId: Integer);

    procedure DialCallToREC(nLineNo: Integer);

    function IsVolumeBoostMic(): Boolean;
    function SetVolumeBoostMic(bEnable: Boolean): Boolean;

    procedure DialRingEnable();
    procedure BusyRingEnable();

    procedure ForceDigitDTMF(nTypeDTMF: Integer);
    function DigitDTMF(nLineNo: Integer; sDigit: String): Boolean;

    procedure DetectAMD(bEnable: Boolean);

    function ChatAddContact(sUserName: String): Boolean;
    function ChatRemoveContact(sUserName: String): Boolean;

    function ChatSendMessageText(sUserName: String; sMsgText: String): Boolean;
    function ChatSendMessageTyping(sUserName: String): Boolean;
    function ChatSetMyStatus(nStatusId: Integer): Boolean;

    function BusyLampAddContact(sUserName: String): Boolean;
    function BusyLampRemoveContact(sUserName: String): Boolean;

    private

    m_nVideoDeviceId: Integer;
    m_nVideoQuality: Integer;

    m_nActiveAudioInDeviceId: Integer;
    m_nActiveAudioOutDeviceId: Integer;

    m_bEnableREC: Boolean;
    m_bBoostMic: Boolean;

    m_bDetectAMD: Boolean;
    m_nTypeDTMF: Integer;

    m_bCaptureSoundDevice: Boolean;
    m_bActivateVideoDevice: Boolean;

    public
    procedure OnVaxOnline();
    procedure OnVaxOffline();

    procedure OnConnectingToRegister(sAccountName: String); override;
    procedure OnTryingToRegister(sAccountName: String); override;

    procedure OnFailToRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String); override;
    procedure OnSuccessToRegister(sAccountName: String); override;

    procedure OnConnectingToReRegister(sAccountName: String); override;
    procedure OnTryingToReRegister(sAccountName: String); override;
    procedure OnFailToReRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String); override;
    procedure OnSuccessToReRegister(sAccountName: String); override;

    procedure OnTryingToUnRegister(sAccountName: String); override;
    procedure OnFailToUnRegister(sAccountName: String); override;
    procedure OnSuccessToUnRegister(sAccountName: String); override;

    procedure OnDialCallStarted(sAccountName: String; nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String); override;
    procedure OnDialingCall(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String); override;
    procedure OnDialCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String); override;

    procedure OnConnectedCall(sAccountName: String; nLineNo: Integer; sToRTPIP: String; ToRTPPort: Integer); override;
    procedure OnHungupCall(sAccountName: String; nLineNo: Integer); override;

    procedure OnIncomingCallStarted(sAccountName: String; sCallId: String; sCallerName: String; sCallerId: String; sDialNo: String; sFromURI: String; sToURI: String); override;
    procedure OnIncomingCallEnded(sAccountName: String; sCallId: String; nReasonCode: Integer); override;

    procedure OnRingToneStarted(sAccountName: String; sCallId: String); override;
    procedure OnRingToneEnded(sAccountName: String; sCallId: String); override;

    procedure OnTransferCallAccepted(sAccountName: String; nLineNo: Integer); override;
    procedure OnTransferCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String); override;

    procedure OnPlayWaveDone(sAccountName: String; nLineNo: Integer); override;

    procedure OnDigitDTMF(sAccountName: String; nLineNo: Integer; sDigit: String); override;
    procedure OnVoiceMailMsg(sAccountName: String; bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String); override;

    procedure OnIncomingDiagnostic(sAccountName: String; sMsgSIP: String; sFromIP: String; nFromPort: Integer); override;
    procedure OnOutgoingDiagnostic(sAccountName: String; sMsgSIP: String; sToIP: String; nToPort: Integer); override;

    procedure OnSuccessToHold(sAccountName: String; nLineNo: Integer); override;
    procedure OnTryingToHold(sAccountName: String; nLineNo: Integer); override;
    procedure OnFailToHold(sAccountName: String; nLineNo: Integer); override;

    procedure OnSuccessToUnHold(sAccountName: String; nLineNo: Integer); override;
    procedure OnTryingToUnHold(sAccountName: String; nLineNo: Integer); override;
    procedure OnFailToUnHold(sAccountName: String; nLineNo: Integer); override;

    procedure OnChatSubscribeSuccess(sAccountName: String; sUserName: String); override;
    procedure OnChatSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String); override;

    procedure OnChatContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer); override;
    procedure OnChatSendMsgTextSuccess(sAccountName: String; sUserName: String; sMsgText: String; nUserValue: Int64); override;
    procedure OnChatSendMsgTextFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; sMsgText: String; UserValue: Int64); override;

    procedure OnChatSendMsgTypingSuccess(sAccountName: String; sUserName: String; nUserValue: Int64); override;
    procedure OnChatSendMsgTypingFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; nUserValue: Int64); override;

    procedure OnChatRecvMsgText(sAccountName: String; sUserName: String; sMsgText: String; bIsChatContact: Boolean); override;

    procedure OnChatRecvMsgTypingStart(sAccountName: String; sUserName: String); override;
    procedure OnChatRecvMsgTypingStop(sAccountName: String; sUserName: String); override;

    procedure OnDetectedAMD(sAccountName: String; nLineNo: Integer; bIsHuman: Boolean); override;

    procedure OnVideoRemoteStarted(sAccountName: String; nLineNo: Integer); override;
    procedure OnVideoRemoteEnded(sAccountName: String; nLineNo: Integer); override;

    procedure OnVideoRemoteFrameRGB(sAccountName: String; nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer); override;
    procedure OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer); override;

    procedure OnAddCallHistory(sAccountName: String; bOutboundCallType: Boolean; sCallerName: String; sCallerId: String; sDialNo: String; nStartTime: Largeuint; nEndTime: Largeuint; nDuration: Largeuint; nDayNo: Largeuint; nHistoryTypeId: Integer); override;
    procedure OnNetworkReachability(bAvailable: Boolean); override;

    procedure OnAudioDeviceMicVU(nLevelVU: Integer); override;
    procedure OnAudioDeviceSpkVU(nLevelVU: Integer); override;

    procedure OnStatusMsgREC(nLineNo: Integer);
    procedure OnVaxErrorMsg(sFuncName: String; sErrorMsg: String; nErrorCode: Integer); override;

    procedure OnBusyLampSubscribeSuccess(sAccountName: String; sUserName: String); override;
    procedure OnBusyLampSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String); override;
    procedure OnBusyLampContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer); override;

    private
    const VAX_ACCOUNT_NAME_PHONE = 'VaxVoIP-PHONE';
    const VAX_ACCOUNT_NAME_REC = 'VaxVoIP-REC';
    const VAX_TOTAL_NO_LINES = 8;

  end;

implementation

uses MainForm;

  var
  m_objMainForm: TMainForm;

  constructor TVaxSIPUserAgentExCOM.Create(objMainForm: TObject);
  begin

    m_objMainForm := TMainForm(objMainForm);

    inherited Create();

    m_bEnableREC := False;
    m_bBoostMic := False;
    m_bDetectAMD := False;

    m_nActiveAudioInDeviceId  := -1;
  	m_nActiveAudioOutDeviceId := -1;

    m_nTypeDTMF := TVaxSIPUserAgentCOM.VAX_DTMF_TYPE_AUTO;

    m_bCaptureSoundDevice := True;
  	m_bActivateVideoDevice := True;

    m_nVideoDeviceId := 0;
  	m_nVideoQuality := TVaxSIPUserAgentCOM.VAX_VIDEO_QUALITY_MEDIUM;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.Initialize(sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer; nServerType: Integer; bRegisterSIP: Boolean; bCaptureSoundDevice: Boolean): Boolean;
  begin

    {****** Use your license key here *******}

      inherited SetLicenceKey('TRIAL-LICENSE-KEY');

    {****************************************}

    if(inherited Initialize() = False) Then
    Begin
      Exit(False);
    End;

    if(inherited AddAccountSIP(VAX_ACCOUNT_NAME_PHONE, nServerType, '', -1, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort) = False) then
    begin
      inherited UnInitialize();
      Exit(False);
    end;

    OnVaxOnline();

    inherited NetworkReachability(True);

    if(bRegisterSIP = True) Then
    begin
      inherited RegisterAccountSIP(VAX_ACCOUNT_NAME_PHONE, 1800);
      inherited AutoRegistration(VAX_ACCOUNT_NAME_PHONE, True, -1, 4);
    end;

    m_bCaptureSoundDevice := bCaptureSoundDevice;
    inherited EnableKeepAlive(VAX_ACCOUNT_NAME_PHONE, 10);

    Result := True;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.SetActiveVideoDevice(nDeviceId: Integer);
  begin
    m_nVideoDeviceId := nDeviceId;
    CaptureVideoDevice();
  end;

  procedure TVaxSIPUserAgentExCOM.ActivateVideoDevice(bActivate: Boolean);
  begin
    m_bActivateVideoDevice := bActivate;
    CaptureVideoDevice();
  end;

  procedure TVaxSIPUserAgentExCOM.SetVideoQuality(nQuality: Integer);
  begin
    m_nVideoQuality := nQuality;
    CaptureVideoDevice();
  end;

  procedure TVaxSIPUserAgentExCOM.CaptureVideoDevice;
  begin

    if(GetVideoDevTotal() = 0) Then
	    Exit();

    CloseVideoDev();

    if m_bActivateVideoDevice = False then
      Exit();

    inherited OpenVideoDev(m_nVideoDeviceId, m_nVideoQuality)

  end;

  Procedure TVaxSIPUserAgentExCOM.SetActiveAudioInDevice(nDeviceId: Integer);
  begin
    m_nActiveAudioInDeviceId := nDeviceId;
  End;

  Procedure TVaxSIPUserAgentExCOM.SetActiveAudioOutDevice(nDeviceId: Integer);
  begin
    m_nActiveAudioOutDeviceId := nDeviceId;
  End;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.GetTotalLine(): Integer;
  begin
    Result := VAX_TOTAL_NO_LINES;
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.RegisterAccountSIP(nExpire: Integer): Boolean;
  begin
    Result := inherited RegisterAccountSIP(VAX_ACCOUNT_NAME_PHONE, nExpire);
  end;

  function TVaxSIPUserAgentExCOM.EnableKeepAlive(nSeconds: Integer): Boolean;
  begin
    Result := inherited EnableKeepAlive(VAX_ACCOUNT_NAME_PHONE, nSeconds);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.DialCall(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String): Boolean;
  var
    nInputDeviceId: Integer;
    nOutputDeviceId: Integer;
  begin

    nInputDeviceId := m_nActiveAudioInDeviceId;
    nOutputDeviceId := m_nActiveAudioOutDeviceId;

    if(m_bCaptureSoundDevice = False) Then
    begin
      nInputDeviceId := TVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
      nOutputDeviceId := TVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
    end;

    if(inherited DialCall(VAX_ACCOUNT_NAME_PHONE, nLineNo, sCallerName, sCallerId, sDialNo, nInputDeviceId, nOutputDeviceId) = False) Then
    Begin
      Exit(False);
    End;

	  DialCallToREC(nLineNo);
  	Result := True;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.AcceptCall(nLineNo: Integer; sCallId: String): Boolean;
  var
    nInputDeviceId: Integer;
    nOutputDeviceId: Integer;
  begin

    nInputDeviceId := m_nActiveAudioInDeviceId;
    nOutputDeviceId := m_nActiveAudioOutDeviceId;

    if(m_bCaptureSoundDevice = False) Then
    begin
      nInputDeviceId := TVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
      nOutputDeviceId := TVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
    end;

    if(inherited AcceptCall(nLineNo, sCallId, nInputDeviceId, nOutputDeviceId) = False) Then
    Begin
      Exit(False);
    End;

  	DialCallToREC(nLineNo);
	  Result := True;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.UnRegisterAccountREC();
  begin
    m_bEnableREC := False;
    inherited UnRegisterAccountSIP(VAX_ACCOUNT_NAME_REC);
  end;

  function TVaxSIPUserAgentExCOM.RegisterAccountREC(bRegiter: Boolean; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDisplayName: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer): Boolean;
  begin

    m_bEnableREC := False;
    inherited RemoveAccountSIP(VAX_ACCOUNT_NAME_REC);

    if(inherited AddAccountSIP(VAX_ACCOUNT_NAME_REC, TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP, '', -1, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort) = False) Then
    begin
      Exit(False);
    end;

    if(bRegiter = True) Then
    begin
      if(inherited RegisterAccountSIP(VAX_ACCOUNT_NAME_REC, 1800) = False) Then
        Exit(False)
    else
       m_bEnableREC := True;
    end;

    Result := True;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.DialCallToREC(nLineNo: Integer);
  begin

    if(m_bEnableREC = False) Then
      Exit;

    if(inherited DialCallToREC(VAX_ACCOUNT_NAME_REC, nLineNo, '000') = False) Then
    begin
       OnStatusMsgREC(nLineNo);
       Exit();
    end;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.IsVolumeBoostMic(): Boolean;
  begin
    Result :=  m_bBoostMic;
  end;

  function TVaxSIPUserAgentExCOM.SetVolumeBoostMic(bEnable: Boolean): Boolean;
  var
    nBoostVol: Integer;
    bResult: Boolean;
  begin

    nBoostVol := 0;

    if bEnable then
      nBoostVol := 20;

    bResult := inherited SetVolumeMic(nBoostVol);

    if not bResult then
    begin
      m_bBoostMic := False;
    end;

    m_bBoostMic := bEnable;
	  Result := bResult;

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnVaxOnline();
  begin
    m_objMainForm.OnVaxOnline();
  end;

  procedure TVaxSIPUserAgentExCOM.OnVaxOffline();
  begin
    m_objMainForm.OnVaxOffline();
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.DialRingEnable();
  begin
    inherited DialRingEnable('DialRing.wav');
  end;

  procedure TVaxSIPUserAgentExCOM.BusyRingEnable();
  begin
    inherited BusyRingEnable('BusyRing.wav');
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.DetectAMD(bEnable: Boolean);
  begin
    m_bDetectAMD := bEnable;
  end;

  procedure TVaxSIPUserAgentExCOM.ForceDigitDTMF(nTypeDTMF: Integer);
  begin
    m_nTypeDTMF := nTypeDTMF;
  end;

  function TVaxSIPUserAgentExCOM.DigitDTMF(nLineNo: Integer; sDigit: String): Boolean;
  begin
    Result := inherited DigitDTMF(nLineNo, sDigit, m_nTypeDTMF);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.ChatAddContact(sUserName: String): Boolean;
  begin
    Result := inherited ChatAddContact(VAX_ACCOUNT_NAME_PHONE, sUserName, True);
  end;

  function TVaxSIPUserAgentExCOM.ChatRemoveContact(sUserName: String): Boolean;
  begin
    Result := inherited ChatRemoveContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
  end;

  function TVaxSIPUserAgentExCOM.ChatSendMessageText(sUserName: String; sMsgText: String): Boolean;
  begin
    Result := inherited ChatSendMessageText(VAX_ACCOUNT_NAME_PHONE, sUserName, sMsgText, False, 0);
  end;

  function TVaxSIPUserAgentExCOM.ChatSendMessageTyping(sUserName: String): Boolean;
  begin
    Result := inherited ChatSendMessageTyping(VAX_ACCOUNT_NAME_PHONE, sUserName, 0);
  end;

  function TVaxSIPUserAgentExCOM.ChatSetMyStatus(nStatusId: Integer): Boolean;
  begin
    Result := inherited ChatSetMyStatus(VAX_ACCOUNT_NAME_PHONE, nStatusId);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  function TVaxSIPUserAgentExCOM.BusyLampAddContact(sUserName: String): Boolean;
  begin
    Result := inherited BusyLampAddContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
  end;

  function TVaxSIPUserAgentExCOM.BusyLampRemoveContact(sUserName: String): Boolean;
  begin
    Result := inherited BusyLampRemoveContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnConnectingToRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnConnectingToRegisterREC();
      Exit();
    end;

    m_objMainForm.OnConnectingToRegister();

  end;

  procedure TVaxSIPUserAgentExCOM.OnTryingToRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnTryingToRegisterREC();
      Exit();
    end;

    m_objMainForm.OnTryingToRegister();

  end;

  procedure TVaxSIPUserAgentExCOM.OnFailToRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_bEnableREC := False;
      m_objMainForm.OnFailToRegisterREC(nStatusCode, sReasonPhrase);
      Exit();
    end;

    m_objMainForm.OnFailToRegister(nStatusCode, sReasonPhrase);

  end;

  procedure TVaxSIPUserAgentExCOM.OnSuccessToRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_bEnableREC := True;
      m_objMainForm.OnSuccessToRegisterREC();
      Exit();
    end;

    m_objMainForm.OnSuccessToRegister();

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnConnectingToReRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnConnectingToReRegisterREC();
      Exit();
    end;

    m_objMainForm.OnConnectingToReRegister();

  end;

  procedure TVaxSIPUserAgentExCOM.OnTryingToReRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnTryingToReRegisterREC();
      Exit();
    end;

    m_objMainForm.OnTryingToReRegister();

  end;

  procedure TVaxSIPUserAgentExCOM.OnFailToReRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_bEnableREC := False;
      m_objMainForm.OnFailToReRegisterREC(nStatusCode, sReasonPhrase);
      Exit();
    end;

    m_objMainForm.OnFailToReRegister(nStatusCode, sReasonPhrase);

  end;

  procedure TVaxSIPUserAgentExCOM.OnSuccessToReRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_bEnableREC := True;
      m_objMainForm.OnSuccessToReRegisterREC();
      Exit();
    end;

    m_objMainForm.OnSuccessToReRegister();

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnTryingToUnRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnTryingToUnRegisterREC();
      Exit();
    end;

    m_objMainForm.OnTryingToUnRegister();

  end;

  procedure TVaxSIPUserAgentExCOM.OnFailToUnRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnFailToUnRegisterREC();
      Exit();
    end;

    m_objMainForm.OnFailToUnRegister();

  end;

  procedure TVaxSIPUserAgentExCOM.OnSuccessToUnRegister(sAccountName: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_bEnableREC := True;
      m_objMainForm.OnSuccessToUnRegisterREC();
      Exit();
    end;

    m_objMainForm.OnSuccessToUnRegister();

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnDialCallStarted(sAccountName: String; nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnDialCallStartedREC(nLineNo, sCallerName, sCallerId, sDialNo);
      Exit();
    end;

    m_objMainForm.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);

  end;

  procedure TVaxSIPUserAgentExCOM.OnDialingCall(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnDialingCallREC(nLineNo, nStatusCode, sReasonPhrase);
      Exit();
    end;

    m_objMainForm.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);

  end;

  procedure TVaxSIPUserAgentExCOM.OnDialCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnDialCallFailedREC(nLineNo, nStatusCode, sReasonPhrase);
      Exit();
    end;

    m_objMainForm.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase, sContact);

  end;

  procedure TVaxSIPUserAgentExCOM.OnConnectedCall(sAccountName: String; nLineNo: Integer; sToRTPIP: String; ToRTPPort: Integer);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnConnectedCallREC(nLineNo);
      Exit();
    end;

    inherited DetectAMD(nLineNo, m_bDetectAMD, 6000, 300, 2);
    m_objMainForm.OnConnectedCall(nLineNo);

  end;

  procedure TVaxSIPUserAgentExCOM.OnHungupCall(sAccountName: String; nLineNo: Integer);
  begin

    if(sAccountName = VAX_ACCOUNT_NAME_REC) Then
    begin
      m_objMainForm.OnHungupCallREC(nLineNo);;
      Exit();
    end;

    m_objMainForm.OnHungupCall(nLineNo);

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnTransferCallAccepted(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnTransferCallAccepted(nLineNo);
  end;

  procedure TVaxSIPUserAgentExCOM.OnTransferCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  begin
    m_objMainForm.OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnPlayWaveDone(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnPlayWaveDone(nLineNo);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnDigitDTMF(sAccountName: String; nLineNo: Integer; sDigit: String);
  begin
    m_objMainForm.OnDigitDTMF(nLineNo, sDigit);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnAddCallHistory(sAccountName: String; bOutboundCallType: Boolean; sCallerName: String; sCallerId: String; sDialNo: String; nStartTime: Largeuint; nEndTime: Largeuint; nDuration: Largeuint; nDayNo: Largeuint; nHistoryTypeId: Integer);
  begin
  //
  end;

  procedure TVaxSIPUserAgentExCOM.OnNetworkReachability(bAvailable: Boolean);
  begin
    m_objMainForm.OnNetworkReachability(bAvailable);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnVoiceMailMsg(sAccountName: String; bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String);
  begin
    m_objMainForm.OnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnIncomingCallStarted(sAccountName: String; sCallId: String; sCallerName: String; sCallerId: String; sDialNo: String; sFromURI: String; sToURI: String);// dispid 22;
  begin
    m_objMainForm.OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
  end;

  procedure TVaxSIPUserAgentExCOM.OnIncomingCallEnded(sAccountName: String; sCallId: String; nReasonCode: Integer);
  begin
    m_objMainForm.OnIncomingCallEnded(sCallId);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnRingToneStarted(sAccountName: String; sCallId: String);
  begin
    m_objMainForm.OnRingToneStarted(sCallId);
  end;

  procedure TVaxSIPUserAgentExCOM.OnRingToneEnded(sAccountName: String; sCallId: String);
  begin
    m_objMainForm.OnRingToneEnded(sCallId);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnIncomingDiagnostic(sAccountName: String; sMsgSIP: String; sFromIP: String; nFromPort: Integer);
  begin
    //
  end;

  procedure TVaxSIPUserAgentExCOM.OnOutgoingDiagnostic(sAccountName: String; sMsgSIP: String; sToIP: String; nToPort: Integer);
  begin
    //
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnSuccessToHold(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnSuccessToHold(nLineNo);
  end;

  procedure TVaxSIPUserAgentExCOM.OnTryingToHold(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnTryingToHold(nLineNo);
  end;

  procedure TVaxSIPUserAgentExCOM.OnFailToHold(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnFailToHold(nLineNo);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnSuccessToUnHold(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnSuccessToUnHold(nLineNo);
  end;

  procedure TVaxSIPUserAgentExCOM.OnTryingToUnHold(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnTryingToUnHold(nLineNo);
  end;

  procedure TVaxSIPUserAgentExCOM.OnFailToUnHold(sAccountName: String; nLineNo: Integer);
  begin
    m_objMainForm.OnFailToUnHold(nLineNo);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnChatSubscribeSuccess(sAccountName: String; sUserName: String);
  begin
    m_objMainForm.OnChatSubscribeSuccess(sUserName);
  end;

  procedure TVaxSIPUserAgentExCOM.OnChatSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
    m_objMainForm.OnChatSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnChatContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer);
  begin
    m_objMainForm.OnChatContactStatus(sUserName, nStatusId);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnChatSendMsgTextSuccess(sAccountName: String; sUserName: String; sMsgText: String; nUserValue: Int64);
  begin
    m_objMainForm.OnChatSendMsgTextSuccess(sUserName, sMsgText);
  end;

  procedure TVaxSIPUserAgentExCOM.OnChatSendMsgTextFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; sMsgText: String; UserValue: Int64);
  begin
    m_objMainForm.OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnChatSendMsgTypingSuccess(sAccountName: String; sUserName: String; nUserValue: Int64);
  begin
    m_objMainForm.OnChatSendMsgTypingSuccess(sUserName);
  end;

  procedure TVaxSIPUserAgentExCOM.OnChatSendMsgTypingFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; nUserValue: Int64);
  begin
    m_objMainForm.OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnChatRecvMsgText(sAccountName: String; sUserName: String; sMsgText: String; bIsChatContact: Boolean);
  begin
    m_objMainForm.OnChatRecvMsgText(sUserName, sMsgText);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnChatRecvMsgTypingStart(sAccountName: String; sUserName: String);
  begin
    m_objMainForm.OnChatRecvMsgTypingStart(sUserName);
  end;

  procedure TVaxSIPUserAgentExCOM.OnChatRecvMsgTypingStop(sAccountName: String; sUserName: String);
  begin
    m_objMainForm.OnChatRecvMsgTypingStop(sUserName);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnDetectedAMD(sAccountName: String; nLineNo: Integer; bIsHuman: Boolean);
  begin
    m_objMainForm.OnDetectedAMD(nLineNo, bIsHuman);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnVideoRemoteStarted(sAccountName: String; nLineNo: Integer);
  begin
     m_objMainForm.OnVideoRemoteStarted(nLineNo);
  end;

  procedure TVaxSIPUserAgentExCOM.OnVideoRemoteEnded(sAccountName: String; nLineNo: Integer);
  begin
     m_objMainForm.OnVideoRemoteEnded(nLineNo)
  end;

  procedure TVaxSIPUserAgentExCOM.OnVideoRemoteFrameRGB(sAccountName: String; nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  begin
    m_objMainForm.OnVideoRemoteFrameRGB(nLineNo, nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
  end;

  procedure TVaxSIPUserAgentExCOM.OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  begin
    m_objMainForm.OnVideoDeviceFrameRGB(nDeviceId, nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnAudioDeviceMicVU(nLevelVU: Integer);
  begin
    m_objMainForm.OnAudioDeviceMicVU(nLevelVU);
  end;

  procedure TVaxSIPUserAgentExCOM.OnAudioDeviceSpkVU(nLevelVU: Integer);
  begin
    m_objMainForm.OnAudioDeviceSpkVU(nLevelVU);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnBusyLampSubscribeSuccess(sAccountName: String; sUserName: String);
  begin
    m_objMainForm.OnBusyLampSubscribeSuccess(sUserName);
  end;

  procedure TVaxSIPUserAgentExCOM.OnBusyLampSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
    m_objMainForm.OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
  end;

  procedure TVaxSIPUserAgentExCOM.OnBusyLampContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer);
  begin
    m_objMainForm.OnBusyLampContactStatus(sUserName, nStatusId);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TVaxSIPUserAgentExCOM.OnStatusMsgREC(nLineNo: Integer);
  var
    nErrorCode: Integer;
    sErrorMsg: String;
  begin

    nErrorCode := inherited GetVaxErrorCode();
    sErrorMsg := inherited GetVaxErrorMsg();

    m_objMainForm.OnStatusMsgREC(nLineNo, nErrorCode, sErrorMsg);

  end;

  procedure TVaxSIPUserAgentExCOM.OnVaxErrorMsg(sFuncName: String; sErrorMsg: String; nErrorCode: Integer);
  begin

    if sFuncName = 'BusyRingEnable' Then
    begin
      Application.MessageBox('Unable to access or find BusyRing.wav file', 'VaxVoIP SIP SDK');
      Exit();
    end;

    if sFuncName = 'DialRingEnable' Then
    begin
      Application.MessageBox('Unable to access or find DialRing.wav file', 'VaxVoIP SIP SDK');
      Exit();
    end;

    if (sFuncName = 'OpenLineREC') or  (sFuncName = 'DialCallToREC') Then Exit();
      Application.MessageBox(PWideChar(sErrorMsg), 'VaxVoIP SIP SDK');

  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

end.
