unit MainSettingForm;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
  VaxSIPUserAgentExCOM, VaxSIPUserAgentCOM,
  ListData;

type
  TMainSettingForm = class(TForm)
    GroupVoiceCodec: TGroupBox;
    CheckGSM610: TCheckBox;
    CheckiLBC: TCheckBox;
    CheckG711A: TCheckBox;
    CheckG711U: TCheckBox;
    CheckG729: TCheckBox;
    GroupOtherSetting: TGroupBox;
    CheckEchoCancel: TCheckBox;
    CheckMicBoost: TCheckBox;
    CheckAGC: TCheckBox;
    GroupAudioIn: TGroupBox;
    ListAudioIn: TListBox;
    GroupAudioOut: TGroupBox;
    ListAudioOut: TListBox;
    GroupVideoDevices: TGroupBox;
    GroupBox1: TGroupBox;
    ComboBoxVideoQuality: TComboBox;
    GroupDigitalDTMF: TGroupBox;
    ListVideoDevices: TListBox;
    RadioForceNone: TRadioButton;
    RadioForceInbandDTMF: TRadioButton;
    RadioForceRfc2833DTMF: TRadioButton;
    RadioForceInfoDTMF: TRadioButton;

    procedure OnVaxOnline();

    constructor Create(objTabSheetSetting: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);overload;

    procedure CheckGSM610Click(Sender: TObject);
    procedure CheckiLBCClick(Sender: TObject);
    procedure CheckG729Click(Sender: TObject);
    procedure CheckG711UClick(Sender: TObject);
    procedure CheckG711AClick(Sender: TObject);

    procedure CheckEchoCancelClick(Sender: TObject);
    procedure CheckAGCClick(Sender: TObject);
    procedure CheckMicBoostClick(Sender: TObject);

    procedure ListAudioInClick(Sender: TObject);
    procedure ListAudioOutClick(Sender: TObject);

    ///////////////////////////////////////////////
    ///
    procedure UpdateVideoDevices();
    procedure UpdateListVideoQuality();

    procedure ActivateAudioCodecs();
    procedure ActivateVideoCodecs();

    procedure ActivateVideoQuality();
    procedure ActivateVideoDevice();
    procedure ActivateOtherSettings();

    procedure ActivateDigitDTMF();

    procedure ListVideoDevicesClick(Sender: TObject);
    procedure ComboBoxVideoQualityChange(Sender: TObject);

    procedure RadioForceNoneClick(Sender: TObject);
    procedure RadioForceInbandDTMFClick(Sender: TObject);
    procedure RadioForceRfc2833DTMFClick(Sender: TObject);
    procedure RadioForceInfoDTMFClick(Sender: TObject);

    ///////////////////////////////////////////////

    private
    m_objVaxCOM : TVaxSIPUserAgentExCOM;
    procedure UpdateAudioIn();
    procedure UpdateAudioOut();


  end;

implementation

{$R *.dfm}

constructor TMainSettingForm.Create(objTabSheetSetting: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);
begin

  inherited Create(objTabSheetSetting);
  m_objVaxCOM := objVaxCOM;

end;

procedure TMainSettingForm.OnVaxOnline();
begin

  CheckEchoCancel.Checked := True;

  CheckG711U.Checked := True;
  CheckG729.Checked := True;
  CheckG711A.Checked := True;
  CheckGSM610.Checked := False;
  CheckiLBC.Checked := False;

  RadioForceNone.Checked := True;

  UpdateAudioIn();
  UpdateAudioOut();
  UpdateVideoDevices();

  UpdateListVideoQuality();

  ActivateVideoDevice();

  ActivateAudioCodecs();
  ActivateVideoCodecs();

  ActivateVideoQuality();

  ActivateOtherSettings();
  ActivateDigitDTMF();

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.UpdateAudioIn();
var
  nDeviceId : Integer;
  sDeviceName : WideString;
  objListData : TListData;
begin

  ListAudioIn.Clear();

  ListAudioIn.AddItem('Default Device', TListData.Create(-1, 'Default Device'));

  for nDeviceId := 0 to m_objVaxCOM.GetAudioInDevTotal() - 1 do
  begin
    sDeviceName := m_objVaxCOM.GetAudioInDevName(nDeviceId);
    ListAudioIn.AddItem(sDeviceName,TListData.Create(nDeviceId, sDeviceName));
  end;

  ListAudioIn.ItemIndex := 0;
  objListData := TListData(ListAudioIn.Items.Objects[0]);
  nDeviceId := objListData.m_nData;
  m_objVaxCOM.SetActiveAudioInDevice(nDeviceId);

end;

procedure TMainSettingForm.UpdateAudioOut();
var
  nDeviceId : Integer;
  sDeviceName : WideString;
  objListData : TListData;
begin

  ListAudioOut.Clear();
  ListAudioOut.AddItem('Default Device', TListData.Create(-1, 'Default Device'));

  for nDeviceId := 0 to m_objVaxCOM.GetAudioOutDevTotal() - 1 do
  begin
    sDeviceName := m_objVaxCOM.GetAudioOutDevName(nDeviceId);
    ListAudioOut.AddItem(sDeviceName,TListData.Create(nDeviceId, sDeviceName));
  end;

  ListAudioOut.ItemIndex := 0;
  objListData := TListData(ListAudioOut.Items.Objects[0]);
  nDeviceId := objListData.m_nData;
  m_objVaxCOM.SetActiveAudioOutDevice(nDeviceId);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.UpdateVideoDevices();
var
  nDeviceIndex : Integer;
  sDeviceName : WideString;
begin

  ListVideoDevices.Clear();

  for nDeviceIndex := 0 to m_objVaxCOM.GetVideoDevTotal() - 1 do
  begin

    sDeviceName := m_objVaxCOM.GetVideoDevName(nDeviceIndex);
    ListVideoDevices.AddItem(sDeviceName, TListData.Create(nDeviceIndex, sDeviceName));

  end;

  if ListVideoDevices.Items.Count > 0 then
    ListVideoDevices.ItemIndex := 0;

end;

procedure TMainSettingForm.UpdateListVideoQuality();
begin

  ComboBoxVideoQuality.Items.Add('Low');
  ComboBoxVideoQuality.Items.Add('Standard');
  ComboBoxVideoQuality.Items.Add('Medium');
  ComboBoxVideoQuality.Items.Add('High');
  ComboBoxVideoQuality.Items.Add('Max');

  ComboBoxVideoQuality.ItemIndex := 1;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.ActivateAudioCodecs();
begin

  m_objVaxCOM.DeselectAllAudioCodec();

  if CheckG711U.Checked = True then
    m_objVaxCOM.SelectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_G711U)
  else
    m_objVaxCOM.DeselectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_G711U);

  if CheckGSM610.Checked = True then
    m_objVaxCOM.SelectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_GSM610)
  else
    m_objVaxCOM.DeselectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_GSM610);


  if CheckG711A.Checked = True then
    m_objVaxCOM.SelectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_G711A)
  else
    m_objVaxCOM.DeselectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_G711A);


  if CheckG729.Checked = True then
    m_objVaxCOM.SelectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_G729)
  else
    m_objVaxCOM.DeselectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_G729);


  if CheckiLBC.Checked = True then
    m_objVaxCOM.SelectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_ILBC)
  else
    m_objVaxCOM.DeselectAudioCodec(TVaxSIPUserAgentExCOM.VAX_AUDIO_CODEC_ILBC);

end;

procedure TMainSettingForm.ActivateVideoCodecs();
begin

  m_objVaxCOM.DeselectAllVideoCodec();
  m_objVaxCOM.SelectVideoCodec(TVaxSIPUserAgentExCOM.VAX_VIDEO_CODEC_VP8)

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.ActivateVideoQuality();
begin
  m_objVaxCOM.SetVideoQuality(ComboBoxVideoQuality.ItemIndex);
end;

procedure TMainSettingForm.ActivateVideoDevice();
begin
  m_objVaxCOM.SetActiveVideoDevice(ListVideoDevices.ItemIndex);
end;

procedure TMainSettingForm.ActivateOtherSettings();
begin
  m_objVaxCOM.EchoCancellation(CheckEchoCancel.Checked);
  m_objVaxCOM.AutoGainMic(CheckAGC.Checked, 8000);

  m_objVaxCOM.SetVolumeBoostMic(CheckMicBoost.Checked);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.ActivateDigitDTMF();
begin

  if RadioForceNone.Checked = True then
  begin

    m_objVaxCOM.ForceDigitDTMF(TVaxSIPUserAgentCOM.VAX_DTMF_TYPE_AUTO);

  end

  else if RadioForceInbandDTMF.Checked = True then
  begin

    m_objVaxCOM.ForceDigitDTMF(TVaxSIPUserAgentExCOM.VAX_DTMF_TYPE_INBAND);

  end

  else if RadioForceRfc2833DTMF.Checked = True then
  begin

     m_objVaxCOM.ForceDigitDTMF(TVaxSIPUserAgentExCOM.VAX_DTMF_TYPE_RFC2833);

  end

  else if RadioForceInfoDTMF.Checked = True then
  begin

    m_objVaxCOM.ForceDigitDTMF(TVaxSIPUserAgentExCOM.VAX_DTMF_TYPE_SIP_INFO);

  end;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.ListAudioInClick(Sender: TObject);
var
  nItemIndex : Integer;
  nDeviceId : Integer;
  objListData : TListData;
begin
  nItemIndex := ListAudioIn.ItemIndex;
  objListData := TListData(ListAudioIn.Items.Objects[nItemIndex]);
  nDeviceId := objListData.m_nData;
  m_objVaxCOM.SetActiveAudioInDevice(nDeviceId);
end;


procedure TMainSettingForm.ListAudioOutClick(Sender: TObject);
var
  nItemIndex : Integer;
  nDeviceId : Integer;
  objListData : TListData;
begin

  nItemIndex := ListAudioOut.ItemIndex;
  objListData := TListData(ListAudioOut.Items.Objects[nItemIndex]);

  nDeviceId := objListData.m_nData;
  m_objVaxCOM.SetActiveAudioOutDevice(nDeviceId);

end;

procedure TMainSettingForm.ListVideoDevicesClick(Sender: TObject);
begin
  ActivateVideoDevice();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.CheckGSM610Click(Sender: TObject);
begin
  ActivateAudioCodecs();
end;

procedure TMainSettingForm.CheckiLBCClick(Sender: TObject);
begin
  ActivateAudioCodecs();
end;

procedure TMainSettingForm.CheckG711AClick(Sender: TObject);
begin
  ActivateAudioCodecs();
end;

procedure TMainSettingForm.CheckG711UClick(Sender: TObject);
begin
  ActivateAudioCodecs();
end;

procedure TMainSettingForm.CheckG729Click(Sender: TObject);
begin
  ActivateAudioCodecs();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.ComboBoxVideoQualityChange(Sender: TObject);
begin
  ActivateVideoQuality();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.CheckEchoCancelClick(Sender: TObject);
begin
  ActivateOtherSettings();
end;

procedure TMainSettingForm.CheckAGCClick(Sender: TObject);
begin
  ActivateOtherSettings();
end;

procedure TMainSettingForm.CheckMicBoostClick(Sender: TObject);
begin
  ActivateOtherSettings();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainSettingForm.RadioForceNoneClick(Sender: TObject);
begin
  ActivateDigitDTMF();
end;

procedure TMainSettingForm.RadioForceInbandDTMFClick(Sender: TObject);
begin
  ActivateDigitDTMF();
end;

procedure TMainSettingForm.RadioForceRfc2833DTMFClick(Sender: TObject);
begin
  ActivateDigitDTMF();
end;

procedure TMainSettingForm.RadioForceInfoDTMFClick(Sender: TObject);
begin
  ActivateDigitDTMF();
end;


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


end.
