unit PhoneVoice;

interface

uses
  LineVoice,
  VaxSIPUserAgentExCOM;

type TPhoneVoice = class

  public

    m_objVaxCOM: TVaxSIPUserAgentExCOM;
    m_aLineVoice: array of TLineVoice;

  public

  Constructor Create();
  function SpkListenChannel(bListenLeft: Boolean; bListenRight: Boolean): Integer;

  procedure OnVaxOnline();

	procedure MuteLineMIC(nLineNo: Integer; bMute: Boolean);
	procedure MuteLineSPK(nLineNo: Integer; bMute: Boolean);

	procedure LineVoiceChannelSPK(nLineNo: Integer; bLeftSpkListen: Boolean; bRightSpkListen: Boolean);
	procedure ConfAllowLine(nLineNo: Integer; bAllowListen: Boolean; bAllowSpeak: Boolean);

end;

implementation

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

Constructor TPhoneVoice.Create();
begin
//
end;

procedure TPhoneVoice.OnVaxOnline();
var
  nCount: Integer;
  nTotalLine: Integer;
begin

  nTotalLine := m_objVaxCOM.GetTotalLine();
  SetLength(m_aLineVoice, nTotalLine);

  for nCount := 0 to (nTotalLine - 1) do
  begin

    m_aLineVoice[nCount] := TLineVoice.Create;

  end;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneVoice.MuteLineSPK(nLineNo: Integer; bMute: Boolean);
begin

  if m_objVaxCOM.MuteLineSPK(nLineNo, bMute) = False Then
    Exit;

  m_aLineVoice[nLineNo].m_bMuteLineSPK := bMute;

end;

procedure TPhoneVoice.MuteLineMIC(nLineNo: Integer; bMute: Boolean);
begin

  if m_objVaxCOM.MuteLineMIC(nLineNo, bMute) = False Then
    Exit;

  m_aLineVoice[nLineNo].m_bMuteLineMIC := bMute;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function TPhoneVoice.SpkListenChannel(bListenLeft: Boolean; bListenRight: Boolean): Integer;
begin

  if (bListenLeft = True) and (bListenRight = False) then
  begin
    Result := 0;
    Exit;
  end;

  if (bListenLeft = False) and (bListenRight = True) then
  begin
    Result := 1;
    Exit;
  end;

  Result := 2;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneVoice.LineVoiceChannelSPK(nLineNo: Integer; bLeftSpkListen: Boolean; bRightSpkListen: Boolean);
begin

  if m_objVaxCOM.LineVoiceChannelSPK(nLineNo, SpkListenChannel(bLeftSpkListen, bRightSpkListen)) = False Then
    Exit;

  m_aLineVoice[nLineNo].m_bListenLeftSpk := bLeftSpkListen;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneVoice.ConfAllowLine(nLineNo: Integer; bAllowListen: Boolean; bAllowSpeak: Boolean);
begin

  if m_objVaxCOM.ConfAllowLine(nLineNo, bAllowListen, bAllowSpeak) = False Then
    Exit;

  m_aLineVoice[nLineNo].m_bAllowListenConf := bAllowListen;
  m_aLineVoice[nLineNo].m_bAllowSpeakConf := bAllowSpeak;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


end.
