unit MainForm;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.OleCtrls,
  Vcl.ComCtrls,
  MainAccountForm,
  MainPhoneForm,
  MainChatForm,
  MainBusyLampForm,
  MainSettingForm,
  MainVideoForm,
  MainAccountRecForm,
  Vcl.OleServer,
  VaxSIPUserAgentExCOM,
  Vcl.StdCtrls;

type

  TMainForm = class(TForm)
  PageControl1: TPageControl;

  m_objTabSheetAccount: TTabSheet;
  m_objTabSheetPhone: TTabSheet;
  m_objTabSheetVideo: TTabSheet;
  m_objTabSheetChat: TTabSheet;
  m_objTabSheetBusyLamp: TTabSheet;
  m_objTabSheetSetting: TTabSheet;
  m_objTabSheetRecSIP: TTabSheet;

  Function GetActiveTab: Integer;
  procedure SetActiveTab(nTabIndex: Integer);
  procedure m_objTabSheetVideoContextPopup(MousePos: TPoint);

  procedure FormCreate(Sender: TObject);

  public
  procedure OnVaxOnline();
  procedure OnVaxOffline();

  public
  procedure OnConnectingToRegister();
  procedure OnTryingToRegister();
  procedure OnSuccessToRegister();
  procedure OnFailToRegister(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnConnectingToReRegister();
  procedure OnTryingToReRegister();
  procedure OnSuccessToReRegister();
  procedure OnFailToReRegister(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnTryingToUnRegister();
  procedure OnFailToUnRegister();
  procedure OnSuccessToUnRegister();

  public
  procedure OnConnectingToRegisterREC();
  procedure OnTryingToRegisterREC();
  procedure OnSuccessToRegisterREC();
  procedure OnFailToRegisterREC(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnConnectingToReRegisterREC();
  procedure OnTryingToReRegisterREC();
  procedure OnSuccessToReRegisterREC();
  procedure OnFailToReRegisterREC(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnTryingToUnRegisterREC();
  procedure OnFailToUnRegisterREC();
  procedure OnSuccessToUnRegisterREC();

  public
  procedure OnDigitDTMF(nLineNo: Integer; sDigit: String);
  procedure OnPlayWaveDone(nLineNo: Integer);

  procedure OnIncomingCallStarted(sCallId: String; sCallerName: String; sCallerId: String);
  procedure OnIncomingCallEnded(sCallId: String);

  procedure OnRingToneStarted(sCallId: String);
  procedure OnRingToneEnded(sCallId: String);

  procedure OnTransferCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnTransferCallAccepted(nLineNo: Integer);

  procedure OnDialCallStarted(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
  procedure OnDialingCall(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnDialCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
  procedure OnConnectedCall(nLineNo: Integer);
  procedure OnHungupCall(nLineNo: Integer);

  procedure OnDialCallStartedREC(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
  procedure OnDialingCallREC(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnDialCallFailedREC(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnConnectedCallREC(nLineNo: Integer);
  procedure OnHungupCallREC(nLineNo: Integer);

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure OnSuccessToHold(nLineNo: Integer);
  procedure OnTryingToHold(nLineNo: Integer);
  procedure OnFailToHold(nLineNo: Integer);

  procedure OnSuccessToUnHold(nLineNo: Integer);
  procedure OnTryingToUnHold(nLineNo: Integer);
  procedure OnFailToUnHold(nLineNo: Integer);

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure OnDetectedAMD(nLineNo: Integer; bIsHuman: Boolean);

  procedure OnNetworkReachability(bAvailable: Boolean);
  procedure OnVoiceMailMsg(bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String);

  procedure OnChatSubscribeSuccess(sUserName: String);
  procedure OnChatSubscribeFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);

  procedure OnChatContactStatus(sUserName: String; nStatusId: Integer);
  procedure OnChatRecvMsgText(sUserName: String; sMsgText: String);

  procedure OnChatRecvMsgTypingStart(sUserName: String);
  procedure OnChatRecvMsgTypingStop(sUserName: String);

  procedure OnChatSendMsgTextFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String; sMsgText: String);
  procedure OnChatSendMsgTextSuccess(sUserName, sMsgText: String);

  procedure OnChatSendMsgTypingSuccess(sUserName: String);
  procedure OnChatSendMsgTypingFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);

  procedure OnVideoRemoteStarted(nLineNo: Integer);
  procedure OnVideoRemoteEnded(nLineNo: Integer);

  procedure OnVideoRemoteFrameRGB(nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  procedure OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);

  procedure OnAudioDeviceMicVU(nLevelVU: Integer);
  procedure OnAudioDeviceSpkVU(nLevelVU: Integer);

  procedure OnBusyLampSubscribeSuccess(sUserName: String);
  procedure OnBusyLampSubscribeFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnBusyLampContactStatus(sUserName: String; nStatusId: Integer);

  procedure OnStatusMsgREC(nLineNo: Integer; nErrorCode: Integer; sErrorMsg: String);

  Private

  m_objFormAccount: TMainAccountForm;
  m_objFormPhone: TMainPhoneForm;
  m_objFormVideo: TMainVideoForm;
  m_objFormChat: TMainChatForm;
  m_objFormBusyLamp: TMainBusyLampForm;
  m_objFormSetting: TMainSettingForm;
  m_objFormRecSIP: TMainAccountRecForm;

  m_objVaxCOM: TVaxSIPUserAgentExCOM;

  end;

  var
  m_objMainForm: TMainForm;

implementation

{$R *.dfm}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.FormCreate(Sender: TObject);
begin

  m_objVaxCOM := TVaxSIPUserAgentExCOM.Create(m_objMainForm);

  m_objFormAccount := TMainAccountForm.Create(m_objTabSheetAccount, m_objVaxCOM);
  m_objFormAccount.Parent := m_objTabSheetAccount;
  m_objFormAccount.Align := alClient;
  m_objFormAccount.Visible := true;

  m_objFormPhone := TMainPhoneForm.Create(m_objTabSheetPhone, m_objVaxCOM, m_objMainForm);
  m_objFormPhone.Parent := m_objTabSheetPhone;
  m_objFormPhone.Align := alClient;
  m_objFormPhone.Visible := true;

  m_objFormVideo := TMainVideoForm.Create(m_objTabSheetVideo, m_objVaxCOM);
  m_objFormVideo.Parent := m_objTabSheetVideo;
  m_objFormVideo.Align := alClient;
  m_objFormVideo.visible := true;

  m_objFormChat := TMainChatForm.Create(m_objTabSheetChat, m_objVaxCOM);
  m_objFormChat.Parent := m_objTabSheetChat;
  m_objFormChat.Align := alClient;
  m_objFormChat.Visible := true;

  m_objFormBusyLamp := TMainBusyLampForm.Create(m_objTabSheetBusyLamp, m_objVaxCOM);
  m_objFormBusyLamp.Parent := m_objTabSheetBusyLamp;
  m_objFormBusyLamp.Align := alClient;
  m_objFormBusyLamp.Visible := true;

  m_objFormSetting := TMainSettingForm.Create(m_objTabSheetSetting, m_objVaxCOM);
  m_objFormSetting.Parent := m_objTabSheetSetting;
  m_objFormSetting.Align := alClient;
  m_objFormSetting.Visible := true;

  m_objFormRecSIP := TMainAccountRecForm.Create(m_objTabSheetRecSIP, m_objVaxCOM);
  m_objFormRecSIP.Parent := m_objTabSheetRecSIP;
  m_objFormRecSIP.Align := alClient;
  m_objFormRecSIP.Visible := true;

  PageControl1.ActivePage := m_objTabSheetAccount;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnVaxOnline();
begin
  m_objFormPhone.OnVaxOnline();
  m_objFormVideo.OnVaxOnline();
  m_objFormChat.OnVaxOnline();
  m_objFormBusyLamp.OnVaxOnline();
  m_objFormSetting.OnVaxOnline();
end;

procedure TMainForm.OnVaxOffline();
begin
  m_objFormPhone.OnVaxOffline();
  m_objFormVideo.OnVaxOffline();
  m_objFormChat.OnVaxOffline();
  m_objFormBusyLamp.OnVaxOffline();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

Function TMainForm.GetActiveTab: Integer;
begin
  Result := PageControl1.ActivePageIndex;
end;

procedure TMainForm.SetActiveTab(nTabIndex: Integer);
begin
  PageControl1.ActivePageIndex := nTabIndex;
end;

procedure TMainForm.m_objTabSheetVideoContextPopup(MousePos: TPoint);
begin
//
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnConnectingToRegister();
begin
    m_objFormAccount.OnConnectingToRegister();
end;

procedure TMainForm.OnTryingToRegister();
begin
  m_objFormAccount.OnTryingToRegister();
end;

procedure TMainForm.OnFailToRegister(nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormAccount.OnFailToRegister(nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnSuccessToRegister();
begin
  m_objFormAccount.OnSuccessToRegister();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnConnectingToReRegister();
begin
  m_objFormAccount.OnConnectingToReRegister();
end;

procedure TMainForm.OnTryingToReRegister();
begin
  m_objFormAccount.OnTryingToReRegister();
end;

procedure TMainForm.OnSuccessToReRegister();
begin
  m_objFormAccount.OnSuccessToReRegister();
end;

procedure TMainForm.OnFailToReRegister(nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormAccount.OnFailToReRegister(nStatusCode, sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnTryingToUnRegister();
begin
  m_objFormAccount.OnTryingToUnRegister();
end;

procedure TMainForm.OnFailToUnRegister();
begin
  m_objFormAccount.OnSuccessToReRegister();
end;

procedure TMainForm.OnSuccessToUnRegister();
begin
  m_objFormAccount.OnSuccessToUnRegister();
end;

///////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnConnectingToRegisterREC();
begin
    m_objFormRecSIP.OnConnectingToRegister();
end;

procedure TMainForm.OnTryingToRegisterREC();
begin
  m_objFormRecSIP.OnTryingToRegister();
end;

procedure TMainForm.OnFailToRegisterREC(nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormRecSIP.OnFailToRegister(nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnSuccessToRegisterREC();
begin
  m_objFormRecSIP.OnSuccessToRegister();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnConnectingToReRegisterREC();
begin
  m_objFormRecSIP.OnConnectingToReRegister();
end;

procedure TMainForm.OnTryingToReRegisterREC();
begin
  m_objFormRecSIP.OnTryingToReRegister();
end;

procedure TMainForm.OnSuccessToReRegisterREC();
begin
  m_objFormRecSIP.OnSuccessToReRegister();
end;

procedure TMainForm.OnFailToReRegisterREC(nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormRecSIP.OnFailToReRegister(nStatusCode, sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnTryingToUnRegisterREC();
begin
  m_objFormRecSIP.OnTryingToUnRegister();
end;

procedure TMainForm.OnFailToUnRegisterREC();
begin
  m_objFormRecSIP.OnSuccessToReRegister();
end;

procedure TMainForm.OnSuccessToUnRegisterREC();
begin
  m_objFormRecSIP.OnSuccessToUnRegister();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


procedure TMainForm.OnDigitDTMF(nLineNo: Integer; sDigit: String);
begin
  m_objFormPhone.OnDigitDTMF(nLineNo, sDigit);
end;

procedure TMainForm.OnPlayWaveDone(nLineNo: Integer);
begin
  m_objFormPhone.OnPlayWaveDone(nLineNo);
end;

procedure TMainForm.OnIncomingCallStarted(sCallId: String; sCallerName: String; sCallerId: String);
begin
  m_objFormPhone.OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
end;

procedure TMainForm.OnIncomingCallEnded(sCallId: String);
begin
  m_objFormPhone.OnIncomingCallEnded(sCallId);
end;

procedure TMainForm.OnRingToneStarted(sCallId: String);
begin
  m_objFormPhone.OnRingToneStarted(sCallId);
end;

procedure TMainForm.OnRingToneEnded(sCallId: String);
begin
m_objFormPhone.OnRingToneEnded(sCallId);
end;

procedure TMainForm.OnTransferCallAccepted(nLineNo: Integer);
begin
  m_objFormPhone.OnTransferCallAccepted(nLineNo);
end;

procedure TMainForm.OnTransferCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormPhone.OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnDialCallStarted(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
begin
  m_objFormPhone.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
end;

procedure TMainForm.OnDialingCall(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormPhone.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnDialCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
begin
  m_objFormPhone.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase, sContact);
end;

procedure TMainForm.OnConnectedCall(nLineNo: Integer);
begin
  m_objFormPhone.OnConnectedCall(nLineNo);
end;

procedure TMainForm.OnHungupCall(nLineNo: Integer);
begin
  m_objFormPhone.OnHungupCall(nLineNo);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnDialCallStartedREC(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
begin
  m_objFormRecSIP.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
end;

procedure TMainForm.OnDialingCallREC(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormRecSIP.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnDialCallFailedREC(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormRecSIP.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnConnectedCallREC(nLineNo: Integer);
begin
  m_objFormRecSIP.OnConnectedCall(nLineNo);
end;

procedure TMainForm.OnHungupCallREC(nLineNo: Integer);
begin
  m_objFormRecSIP.OnHungupCall(nLineNo);
end;


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnStatusMsgREC(nLineNo: Integer; nErrorCode: Integer; sErrorMsg: String);
begin
    m_objFormRecSIP.OnStatusMsg(nLineNo, nErrorCode, sErrorMsg);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainForm.OnSuccessToHold(nLineNo: Integer);
  begin
    m_objFormPhone.OnSuccessToHold(nLineNo);
  end;

  procedure TMainForm.OnTryingToHold(nLineNo: Integer);
  begin
    m_objFormPhone.OnTryingToHold(nLineNo);
  end;

  procedure TMainForm.OnFailToHold(nLineNo: Integer);
  begin
    m_objFormPhone.OnFailToHold(nLineNo);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainForm.OnSuccessToUnHold(nLineNo: Integer);
  begin
    m_objFormPhone.OnSuccessToUnHold(nLineNo);
  end;

  procedure TMainForm.OnTryingToUnHold(nLineNo: Integer);
  begin
    m_objFormPhone.OnTryingToUnHold(nLineNo);
  end;

  procedure TMainForm.OnFailToUnHold(nLineNo: Integer);
  begin
    m_objFormPhone.OnFailToUnHold(nLineNo);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  procedure TMainForm.OnDetectedAMD(nLineNo: Integer; bIsHuman: Boolean);
  begin
    m_objFormPhone.OnDetectAMD(nLineNo, bIsHuman);
  end;

  procedure TMainForm.OnNetworkReachability(bAvailable: Boolean);
  begin
    m_objFormAccount.OnNetworkReachability(bAvailable);
  end;

  procedure TMainForm.OnVoiceMailMsg(bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String);
  begin
    m_objFormAccount.OnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnChatSubscribeSuccess(sUserName: String);
begin
  m_objFormChat.OnChatSubscribeSuccess(sUserName);
end;

procedure TMainForm.OnChatSubscribeFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormChat.OnChatSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnChatContactStatus(sUserName: String; nStatusId: Integer);
begin
  m_objFormChat.OnChatContactStatus(sUserName, nStatusId);
end;

procedure TMainForm.OnChatRecvMsgText(sUserName: String; sMsgText: String);
begin
  m_objFormChat.OnChatRecvMsgText(sUserName, sMsgText);
end;

procedure TMainForm.OnChatRecvMsgTypingStart(sUserName: String);
begin
  m_objFormChat.OnChatRecvMsgTypingStart(sUserName);
end;

procedure TMainForm.OnChatRecvMsgTypingStop(sUserName: String);
begin
  m_objFormChat.OnChatRecvMsgTypingStop();
end;

procedure TMainForm.OnChatSendMsgTextFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String; sMsgText: String);
begin
  m_objFormChat.OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText);
end;

procedure TMainForm.OnChatSendMsgTextSuccess(sUserName, sMsgText: String);
begin
  m_objFormChat.OnChatSendMsgTextSuccess(sUserName, sMsgText);
end;

procedure TMainForm.OnChatSendMsgTypingSuccess(sUserName: String);
begin
  m_objFormChat.OnChatSendMsgTypingSuccess(sUserName);
end;

procedure TMainForm.OnChatSendMsgTypingFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
begin
  m_objFormChat.OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnVideoRemoteStarted(nLineNo: Integer);
begin
  m_objFormVideo.OnVideoRemoteStarted(nLineNo);
end;

procedure TMainForm.OnVideoRemoteEnded(nLineNo: Integer);
begin
  m_objFormVideo.OnVideoRemoteEnded(nLineNo);
end;

procedure TMainForm.OnVideoRemoteFrameRGB(nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
begin
  m_objFormVideo.OnVideoRemoteFrameRGB(nLineNo, nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
end;

procedure TMainForm.OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
begin
  m_objFormVideo.OnVideoDeviceFrameRGB(nDeviceId, nFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnAudioDeviceMicVU(nLevelVU: Integer);
begin
  m_objFormPhone.OnAudioDeviceMicVU(nLevelVU);
end;

procedure TMainForm.OnAudioDeviceSpkVU(nLevelVU: Integer);
begin
  m_objFormPhone.OnAudioDeviceSpkVU(nLevelVU);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainForm.OnBusyLampSubscribeSuccess(sUserName: String);
begin
m_objFormBusyLamp.OnBusyLampSubscribeSuccess(sUserName);
end;

procedure TMainForm.OnBusyLampSubscribeFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
begin
m_objFormBusyLamp.OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
end;

procedure TMainForm.OnBusyLampContactStatus(sUserName: String; nStatusId: Integer);
begin
m_objFormBusyLamp.OnBusyLampContactStatus(sUserName, nStatusId);
end;



end.
