unit MainBusyLampForm;

interface

uses

  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
  VaxSIPUserAgentExCOM, StoreBusyLamp,
  Vcl.ExtCtrls,
  StrUtils;

type

  TMainBusyLampForm = class(TForm)

    GroupStatusLog: TGroupBox;
    ListBoxStatusLog: TListBox;

    ListBoxContacts: TListView;
    EditContactName: TEdit;

    BtnAddContact: TButton;
    BtnRemoveContact: TButton;
    BtnClearLog: TButton;

    constructor Create(objTabSheetBusyLamp: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);overload;

    procedure BtnAddContactClick(Sender: TObject);
    procedure BtnRemoveContactClick(Sender: TObject);
    procedure BtnClearLogClick(Sender: TObject);

    procedure OnVaxOnline();
    procedure OnVaxOffline();

    procedure OnBusyLampSubscribeSuccess(sUserName: String);
    procedure OnBusyLampSubscribeFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
    procedure OnBusyLampContactStatus(sUserName: String; nStatusId: Integer);

    private
    m_objVaxCOM: TVaxSIPUserAgentExCOM;

    private
    procedure LoadContactAll();

    function GetStatusText(nStatusId: Integer): String;
    procedure AddToStatusLog(sBusyLampLog: String);

  end;

implementation
 {$R *.dfm}

  constructor TMainBusyLampForm.Create(objTabSheetBusyLamp: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);
  var
  Column: TListColumn;
  begin

    inherited Create(objTabSheetBusyLamp);
    m_objVaxCOM := objVaxCOM;

    Column := ListBoxContacts.Columns.Add();
    Column.Caption := 'UserName';
    Column.Width := 90;

    Column := ListBoxContacts.Columns.Add();
    Column.Caption := 'Status';
    Column.Width := 110;

  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.OnVaxOnline();
  begin
    LoadContactAll();
  end;

  procedure TMainBusyLampForm.OnVaxOffline();
  begin
    ListBoxStatusLog.Items.Clear();
    ListBoxContacts.Items.Clear();
  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.LoadContactAll();
  var
    nIndex: Integer;
    objList: TStringList;
    Item: TListItem;
    sContactName: String;
  begin

    ListBoxContacts.Items.Clear();

    objList := TStringList.Create();
    TStoreBusyLamp.GetContactAll(objList);

    if(objList.Count <= 0) then
        Exit();

    for nIndex := 0 to objList.Count - 1 do
    begin

      Item := ListBoxContacts.Items.Add;
      sContactName := objList[nIndex];

      Item.Caption := sContactName;
      Item.SubItems.Add('');

      m_objVaxCOM.BusyLampAddContact(sContactName);

    end;

    if (ListBoxContacts.ItemIndex = -1) and (ListBoxContacts.Items.Count <> 0) then
      ListBoxContacts.ItemIndex := 0;

  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.BtnAddContactClick(Sender: TObject);
  var
    Item: TListItem;
  begin

    if EditContactName.Text = '' then
      Exit;

    if m_objVaxCOM.BusyLampAddContact(EditContactName.Text) = False then
      Exit;

     Item := ListBoxContacts.Items.Add;
     Item.Caption := EditContactName.Text;
     Item.SubItems.Add('');

     TStoreBusyLamp.AddContact(EditContactName.Text);

    if (ListBoxContacts.ItemIndex = -1) and (ListBoxContacts.Items.Count <> 0) then
      ListBoxContacts.ItemIndex := 0;

    EditContactName.Text := '';

  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.BtnRemoveContactClick(Sender: TObject);
  var
    sContactName: String;
  begin

    if ListBoxContacts.ItemIndex = -1 then
      Exit;

    if MessageDlg('Do you really want to remove this Contact?', mtConfirmation, [mbYes, mbNo], 0, mbNo) = mrNo then
    begin
      Exit();
    end;

    sContactName := ListBoxContacts.Items[ListBoxContacts.ItemIndex].Caption;

    if m_objVaxCOM.BusyLampRemoveContact(sContactName) = False then
      Exit;

    ListBoxContacts.DeleteSelected;
    TStoreBusyLamp.RemoveContact(sContactName);

  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.AddToStatusLog(sBusyLampLog: String);
  begin
    ListBoxStatusLog.Items.Add(sBusyLampLog);
    ListBoxStatusLog.TopIndex := ListBoxStatusLog.Items.Count - 1;
  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.BtnClearLogClick(Sender: TObject);
  begin
    ListBoxStatusLog.Items.Clear();
  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  function TMainBusyLampForm.GetStatusText(nStatusId: Integer): String;
  var
    sStatus: String;
  begin

    sStatus := '';

    Case nStatusId of
      TVaxSIPUserAgentExCOM.VAX_BUSY_LAMP_STATUS_FREE: sStatus := 'Free';
      TVaxSIPUserAgentExCOM.VAX_BUSY_LAMP_STATUS_OFFLINE: sStatus := 'Offline';
      TVaxSIPUserAgentExCOM.VAX_BUSY_LAMP_STATUS_BUSY: sStatus := 'Busy';
      TVaxSIPUserAgentExCOM.VAX_BUSY_LAMP_STATUS_UNKNOWN: sStatus := 'UnKnown';
      TVaxSIPUserAgentExCOM.VAX_BUSY_LAMP_STATUS_CONNECTING: sStatus := 'Busy';
    end;

    Result := sStatus;

  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.OnBusyLampSubscribeSuccess(sUserName: String);
  begin
    AddToStatusLog('BusyLamp Subscribe ' + sUserName + ' Success.');
  end;

  procedure TMainBusyLampForm.OnBusyLampSubscribeFailed(sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
    AddToStatusLog('BusyLamp Subscribe ' + sUserName + ' Failed.');
  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

  procedure TMainBusyLampForm.OnBusyLampContactStatus(sUserName: String; nStatusId: Integer);
  var
    sContactName: String;
    nContactCount: Integer;
    Item: TListItem;
  begin

    for nContactCount := 0 to (ListBoxContacts.Items.Count - 1) do
    begin
      sContactName := UpperCase(ListBoxContacts.Items.Item[nContactCount].Caption);

      if UpperCase(sUserName) = sContactName then
      begin
        Item := ListBoxContacts.items.Item[nContactCount];

        Item.SubItems.Strings[0] := ' [' + GetStatusText(nStatusId) + ']';
      end;

    end;

  end;

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

 end.
