unit MainAccountForm;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.DateUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
  StoreAccount,
  StoreRegistry,
  VaxSIPUserAgentCOM,
  VaxSIPUserAgentExCOM;

type

  TMainAccountForm = class(TForm)

  GroupAccount: TGroupBox;
  LabelUserName: TLabel;
  LabelDisplayName: TLabel;
  LabelDomainRealm: TLabel;
  LabelPasswd: TLabel;
  LabelLogin: TLabel;

  LabelServerAddr: TLabel;
  LabelServerPort: TLabel;

  EditUserName: TEdit;
  EditDisplayName: TEdit;

  EditDomainRealm: TEdit;
  EditAuthPwd: TEdit;

  BtnOnline: TButton;
  EditAuthLogin: TEdit;

  CheckRegisterToServerSIP: TCheckBox;

  EditServerAddr: TEdit;
  EditServerPort: TEdit;

  CheckCaptureSoundDevice: TCheckBox;
  GroupAccountLog: TGroupBox;
  ListBoxStatusLog: TListBox;

  BtnClearLog: TButton;
  BtnDemoAcc: TButton;
  BtnAdvance: TButton;

  LabelServerType: TLabel;
  ComboServerType: TComboBox;

  GroupBoxVoiceMail: TGroupBox;
  LabelTextIsMsgWaiting: TLabel;
  LabelIsMsgWaiting: TLabel;
  LabelTextNewMsgs: TLabel;

  LabelNewMsgs: TLabel;
  LabelTextOldMsgs: TLabel;
  LabelOldMsgs: TLabel;

  constructor Create(objTabSheetAccount: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);overload;
  procedure FormCreate(Sender: TObject);

  procedure BtnOnlineClick(Sender: TObject);
  procedure BtnClearLogClick(Sender: TObject);

  procedure AddToStatusLog(LogText: String);

  procedure LoadAccountData();
  function GetServerType(): Integer;
  procedure UpdateServerType(nServerType: Integer);

  procedure BtnAdvanceClick(Sender: TObject);
  procedure BtnDemoAccClick(Sender: TObject);
  procedure ComboServerTypeClick(Sender: TObject);

  public
  procedure OnNetworkReachability(bAvailable: Boolean);
  procedure OnVoiceMailMsg(bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String);

  procedure OnConnectingToRegister();
  procedure OnTryingToRegister();
  procedure OnSuccessToRegister();
  procedure OnFailToRegister(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnConnectingToReRegister();
  procedure OnTryingToReRegister();
  procedure OnSuccessToReRegister();
  procedure OnFailToReRegister(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnTryingToUnRegister();
  procedure OnFailToUnRegister();
  procedure OnSuccessToUnRegister();

  private
  m_objVaxCOM: TVaxSIPUserAgentExCOM;
  m_bBtnAdvanceShow: Boolean;

end;


implementation

{$R *.dfm}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

constructor TMainAccountForm.Create(objTabSheetAccount: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);
begin

  inherited Create(objTabSheetAccount);

  m_objVaxCOM := objVaxCOM;
  m_bBtnAdvanceShow := True;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.FormCreate(Sender: TObject);
begin

  ComboServerType.Items.Add('UDP');
  ComboServerType.Items.Add('TCP');
  ComboServerType.Items.Add('TLS');
  ComboServerType.ItemIndex := 0;

  LoadAccountData();

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.BtnOnlineClick(Sender: TObject);
var
  bResult: Boolean;
  nServerType: Integer;
begin

  if BtnOnline.Caption = 'Offline' Then
  begin

    BtnOnline.Caption := 'Online';
    m_objVaxCOM.UnInitialize();

    Exit;

  end;

  if EditAuthLogin.Text = '' Then
  begin
    Application.MessageBox('Invalid auth Login.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit;
  end;

  if EditServerAddr.Text = '' Then
  begin
    Application.MessageBox('Invalid SIP server domain or IP address.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit;
  end;

  nServerType := GetServerType();

  bResult := m_objVaxCOM.Initialize(EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, strtoint(EditServerPort.Text), nServerType, CheckRegisterToServerSIP.Checked, CheckCaptureSoundDevice.Checked);

  if bResult = False Then
    Exit;

  if (CheckRegisterToServerSIP.Checked  = False) Then
  begin
    AddToStatusLog('Account is online.');
  end;

  BtnOnline.Caption := 'Offline';
  TStoreAccount.AddUser(EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, strtoint(EditServerPort.Text), nServerType, CheckRegisterToServerSIP.Checked);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.BtnAdvanceClick(Sender: TObject);
begin

  if (m_bBtnAdvanceShow) then
  begin

    LabelDisplayName.Visible := True;
    LabelUserName.Visible := True;

    LabelDomainRealm.Visible := True;
    EditUserName.Visible := True;

    EditDisplayName.Visible := True;
    EditDomainRealm.Visible := True;

    BtnAdvance.Caption := 'Basic';
    m_bBtnAdvanceShow := False;

    Exit();

  end;

  LabelDisplayName.Visible := False;
  LabelUserName.Visible := False;

  LabelDomainRealm.Visible := False;
  EditUserName.Visible := False;
  EditDisplayName.Visible := False;
  EditDomainRealm.Visible := False;
  BtnAdvance.Caption := 'Advance';

  m_bBtnAdvanceShow := True;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.BtnClearLogClick(Sender: TObject);
begin
  ListBoxStatusLog.Clear();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function DateTimeToUnix(): Longint;
var
  EpocDate: TDateTime;
begin

  EpocDate := EncodeDate(1970, 01, 01);
  Result := Round((now - EpocDate) * 86400);

end;

procedure TMainAccountForm.BtnDemoAccClick(Sender: TObject);
var
  sAccountDemo: String;
  nSeconds: Integer;
  sDemoMsg: String;
begin

  nSeconds := DateTimeToUnix();
  sAccountDemo := IntToStr(nSeconds mod 9999999);

  EditAuthLogin.Text := sAccountDemo;
  EditAuthPwd.Text := sAccountDemo;

  EditServerAddr.Text := 'demo.vaxvoip.com';
  EditServerPort.Text := '8060';

  ComboServerType.ItemIndex := 0;

  sDemoMsg := 'Auth Login: ' + sAccountDemo + #13#10;
  sDemoMsg := sDemoMsg + 'Auth Password: ' + sAccountDemo + #13#10;
  sDemoMsg := sDemoMsg + 'Server Addr: ' + EditServerAddr.Text + #13#10;
  sDemoMsg := sDemoMsg + 'Server Port: ' + EditServerPort.Text + #13#10#13#10;

  sDemoMsg := sDemoMsg + 'Demo accounts are only for account-to-account VoIP calls. Use demo accounts on different devices to dial/receive VoIP calls.'+#13#10+#13#10+'Dial 000 for self testing.'+ #13#10 +#13#10+ '[Powered by VaxVoIP Server SDK]';

  Application.MessageBox(PWideChar(sDemoMsg), 'VaxVoIP Phone SDK');

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.AddToStatusLog(LogText: String);
begin
  ListBoxStatusLog.Items.Add(LogText);
  ListBoxStatusLog.TopIndex := ListBoxStatusLog.Count - 1;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.LoadAccountData();
var
  sDisplayName, sUserName, sAuthLogin, sAuthPwd: String;
  sDomainRealm, sServerAddr: String;
  nServerPort: Integer; nServerType: Integer;
  bRegisterSIP: Boolean;
begin

  TStoreAccount.GetUser(sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort, nServerType, bRegisterSIP);

  EditDisplayName.Text := sDisplayName;
  EditUserName.Text := sUserName;

  EditAuthLogin.Text := sAuthLogin;
  EditAuthPwd.Text := sAuthPwd;

  EditDomainRealm.Text := sDomainRealm;
  EditServerAddr.Text := sServerAddr;
  EditServerPort.Text := IntToStr(nServerPort);

  UpdateServerType(nServerType);
  CheckRegisterToServerSIP.Checked := bRegisterSIP;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.UpdateServerType(nServerType: Integer);
begin

  if (nServerType = TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP) then
  begin
     ComboServerType.ItemIndex := 0;
     LabelServerPort.Caption := 'Server Port UDP (Default: 5060)';
  end
  else if (nServerType = TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TCP) then
  begin
     ComboServerType.ItemIndex := 1;
     LabelServerPort.Caption := 'Server Port TCP (Default: 5060)';
  end
  else if (nServerType = TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS) then
  begin
     ComboServerType.ItemIndex := 2;
     LabelServerPort.Caption := 'Server Port TLS (Default: 5061)';
  end;

  if (EditServerAddr.Text = 'demo.vaxvoip.com') then
  begin
    if (nServerType = TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS) then
      EditServerPort.Text := '8061'
    else
      EditServerPort.Text := '8060';
  end
  else if ((EditServerPort.Text = '5060') or (EditServerPort.Text = '5061') or (Length(EditServerPort.Text) = 0)) then
  begin
    if (nServerType = TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS) then
      EditServerPort.Text := '5061'
    else
      EditServerPort.Text := '5060';
  end;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function TMainAccountForm.GetServerType(): Integer;
begin

  if (ComboServerType.ItemIndex = 0) then
    Exit(TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP);

  if (ComboServerType.ItemIndex = 1) then
    Exit(TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TCP);

  if (ComboServerType.ItemIndex = 2) then
    Exit(TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS);

  Exit(TVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.ComboServerTypeClick(Sender: TObject);
var
  nServerType: Integer;
begin
  nServerType := GetServerType();
  UpdateServerType(nServerType);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.OnNetworkReachability(bAvailable: Boolean);
begin

  if(bAvailable = True) then
    AddToStatusLog('Network is available')
  else
    AddToStatusLog('Network is not available');

end;

procedure TMainAccountForm.OnVoiceMailMsg(bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String);
begin

  if(bIsMsgWaiting = True) then
    LabelIsMsgWaiting.Caption := 'Yes'
  else
    LabelIsMsgWaiting.Caption := 'No';

  LabelNewMsgs.Caption := IntToStr(nNewMsgCount);
  LabelOldMsgs.Caption := IntToStr(nOldMsgCount);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.OnConnectingToRegister();
begin
     AddToStatusLog('Connecting to register.');
end;

procedure TMainAccountForm.OnTryingToRegister();
begin
  AddToStatusLog('Trying to Register.');
end;

procedure TMainAccountForm.OnSuccessToRegister();
begin
  AddToStatusLog('Success to Register.');
end;

procedure TMainAccountForm.OnFailToRegister(nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToStatusLog('Failed: ' + sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.OnConnectingToReRegister();
begin
    AddToStatusLog('Connecting to re-register.');
end;

procedure TMainAccountForm.OnTryingToReRegister();
begin
  AddToStatusLog('Trying to Re-Register.');
end;

procedure TMainAccountForm.OnSuccessToReRegister();
begin
  AddToStatusLog('Success to Re-Register.');
end;

procedure TMainAccountForm.OnFailToReRegister(nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToStatusLog('Failed' + sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountForm.OnTryingToUnRegister();
begin
  AddToStatusLog('Trying to Unregister.');
end;

procedure TMainAccountForm.OnFailToUnRegister();
begin
  AddToStatusLog('Failed to Unregister.');
end;

procedure TMainAccountForm.OnSuccessToUnRegister();
begin
  AddToStatusLog('Unregistered successfully.');
end;



end.
