unit StoreChat;

interface

uses
System.SysUtils,
System.Classes,
StoreRegistry,
VaxSIPUserAgentCOM;

type TStoreChat = class

const CHAT_ROOT_PATH = 'Chat\\';

public

  class function AddContact(sContactName: String): Boolean; static;
  class procedure RemoveContact(sContactName: String); static;

  class procedure GetContactAll(var objList: TStringList); static;
  class function AddMsg(sContactName: String; sMsgText: String): Boolean; static;

  class procedure RemoveMsgAll(sContactName: String); static;
  class procedure GetMsgAll(sContactName: String; var objList: TStringList);

  class function IsDataStored(): Boolean; static;

end;

implementation

  class function TStoreChat.AddContact(sContactName: String): Boolean;
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

   sKeyPath := CHAT_ROOT_PATH + sContactName;
   objStore := TStoreRegistry.Create();

   objStore.SetTEXT(sKeyPath, 'ContactName', sContactName);

   objStore.Destroy();
   Result := True;

  end;

  class procedure TStoreChat.RemoveContact(sContactName: String);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

   sKeyPath := CHAT_ROOT_PATH + sContactName;
   objStore := TStoreRegistry.Create();

   objStore.DeleteSubKey(sKeyPath);
   objStore.Destroy();

  end;

  class procedure TStoreChat.GetContactAll(var objList: TStringList);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

    sKeyPath := CHAT_ROOT_PATH;
    objStore := TStoreRegistry.Create();

    objStore.EnumSubKeys(sKeyPath, objList);
    objStore.Destroy();

  end;


  class function TStoreChat.AddMsg(sContactName: String; sMsgText: String): Boolean;
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
    nMsgCount: Integer;
  begin

   sKeyPath := CHAT_ROOT_PATH + sContactName + '\\Messages';
   objStore := TStoreRegistry.Create();

   nMsgCount := 0;

   objStore.GetINT(sKeyPath, 'MsgCount', nMsgCount, 0);
   objStore.SetINT(sKeyPath, 'MsgCount', nMsgCount + 1);

   objStore.SetTEXT(sKeyPath + '\\MsgText', 'Msg' + IntToStr(nMsgCount), sMsgText);

   objStore.Destroy();
   Result := True;

  end;


  class procedure TStoreChat.RemoveMsgAll(sContactName: String);
  var
    sKeyPath: String;
    objStore: TStoreRegistry;
  begin

    if Length(sContactName) = 0 then
    begin
      Exit();
    end;

    sKeyPath := CHAT_ROOT_PATH + sContactName + '\\Messages';
    objStore := TStoreRegistry.Create();

    objStore.DeleteSubKey(sKeyPath);
    objStore.Destroy();

  end;

  class procedure TStoreChat.GetMsgAll(sContactName: String; var objList: TStringList);
  var
    nCount: Integer;
    sKeyPath: String;
    objStore: TStoreRegistry;
    objValueNameList: TStringList;
    sMsgText: String;
  begin

    if Length(sContactName) = 0 then
    begin
      Exit();
    end;

    sKeyPath := CHAT_ROOT_PATH + sContactName + '\\Messages\\MsgText';
    objStore := TStoreRegistry.Create();

    objValueNameList :=  TStringList.Create();
    objStore.EnumValueNames(sKeyPath, objValueNameList);

    for nCount := 0 to objValueNameList.Count - 1 do
    begin
      objStore.GetTEXT(sKeyPath, objValueNameList[nCount], sMsgText, '');
      objList.Add(sMsgText);
    end;

    objStore.Destroy();

  end;

  class function TStoreChat.IsDataStored(): Boolean;
  var
    objStore: TStoreRegistry;
  begin
    objStore := TStoreRegistry.Create();
    Result := objStore.IsKeyExist(CHAT_ROOT_PATH);
    objStore.Destroy();
  end;

end.
