unit VaxSIPUserAgentCOM;

interface

uses

  System.Win.StdVCL,
  Vcl.Graphics,
  Winapi.ActiveX,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.OleServer,
  Vcl.Forms,
  VAXSIPUSERAGENTCOMLib_TLB;

  type

  TVaxSIPUserAgentCOM = class(TVaxVoIPSIP)

  public

  const VAX_ACCOUNT_TYPE_UDP = 0;
  const VAX_ACCOUNT_TYPE_TCP = 1;
  const VAX_ACCOUNT_TYPE_TLS = 2;

  const VAX_VIDEO_QUALITY_LOW = 0;
  const VAX_VIDEO_QUALITY_STANDARD = 1;
  const VAX_VIDEO_QUALITY_MEDIUM = 2;
  const VAX_VIDEO_QUALITY_HIGH = 3;
  const VAX_VIDEO_QUALITY_MAX = 4;

  const VAX_AUDIO_CODEC_G711U = 0;
  const VAX_AUDIO_CODEC_G711A = 1;
  const VAX_AUDIO_CODEC_GSM610 = 2;
  const VAX_AUDIO_CODEC_ILBC = 3;
  const VAX_AUDIO_CODEC_G729 = 4;

  const VAX_VIDEO_CODEC_VP8 = 0;

  const VAX_DTMF_TYPE_AUTO = 0;
  const VAX_DTMF_TYPE_RFC2833 = 1;
  const VAX_DTMF_TYPE_SIP_INFO = 2;
  const VAX_DTMF_TYPE_INBAND = 3;

  const VAX_CAPTURE_SOUND_DEVICE_NONE = -2;

  const VAX_CONTACT_STATUS_ONLINE = 0;
  const VAX_CONTACT_STATUS_OFFLINE = 1;
  const VAX_CONTACT_STATUS_AWAY = 2;
  const VAX_CONTACT_STATUS_ON_PHONE = 3;
  const VAX_CONTACT_STATUS_BUSY = 4;
  const VAX_CONTACT_STATUS_UNKNOWN = 5;

  const VAX_BUSY_LAMP_STATUS_FREE = 0;
  const VAX_BUSY_LAMP_STATUS_OFFLINE = 1;
  const VAX_BUSY_LAMP_STATUS_BUSY = 2;
  const VAX_BUSY_LAMP_STATUS_UNKNOWN = 3;
  const VAX_BUSY_LAMP_STATUS_CONNECTING = 4;

  const VAX_INCOMING_CALL_ACCEPTED = 0;
  const VAX_INCOMING_CALL_REJECTED = 1;
  const VAX_INCOMING_CALL_CANCELED = 2;

  public
  constructor Create(); reintroduce;

  private
  procedure InvokeEvent(DispID: TDispID; var Params: TVariantArray); override;

  public

  function GetVersionFile: String;
  function GetVersionSDK: String;

  function Initialize: Boolean;
  procedure UnInitialize;

  function SetLicenceKey(sLicenceKey: String): Boolean;
  function GetCallId(nLineNo: Integer): String;

  function AudioDeviceVU(bActivate: Boolean; bMicVU: Boolean; bSpkVU: Boolean): Boolean;

  function GetAudioInDevTotal: Integer;
  function GetAudioOutDevTotal: Integer;

  function GetAudioInDevName(nDeviceId: Integer): String;
  function GetAudioOutDevName(nDeviceId: Integer): String;

  function AddAccountSIP(sAccountName: String; nAccountType: Integer; sListenIP: String; nListenPort: Integer; sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer): Boolean;
  procedure RemoveAccountSIP(sAccountName: String);

  function RegisterAccountSIP(sAccountName: String; nExpire: Integer): Boolean;
  function UnRegisterAccountSIP(sAccountName: String): Boolean;

  function OpenLine(nLineNo: Integer; sRTPRxIP: String; sRxAudioPortRTP: Integer; nRxVideoPortRTP: Integer): Boolean;
  function OpenLineREC(nLineNo: Integer; sRTPRxIP: String; nAudioPortRTP: Integer): Boolean;

  function CloseLine(nLineNo: Integer): Boolean;

  function GetVaxErrorCode: Integer;
  function GetVaxErrorMsg: String;

  function DialCall(sAccountName: String; nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String; nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  function DialCallToREC(sAccountName: String; nLineNo: Integer; sDialNo: String): Boolean;

  function DisconnectCall(nLineNo: Integer): Boolean;

  function AcceptCall(nLineNo: Integer; sCallId: String; nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  function RejectCall(sCallId: String): Boolean;

  function TransferCallBlind(nLineNo: Integer; sToUserName: String): Boolean;
  function TransferCallConsult(nLineNoA: Integer; nLineNoB: Integer): Boolean;

  function HoldLine(nLineNo: Integer): Boolean;
  function UnHoldLine(nLineNo: Integer): Boolean;

  function IsLineOpen(nLineNo: Integer): Boolean;
  function IsLineHold(nLineNo: Integer): Boolean;
  function IsLineBusy(nLineNo: Integer): Boolean;
  function IsLineConnected(nLineNo: Integer): Boolean;

  function EnableKeepAlive(sAccountName: String; nSeconds: Integer): Boolean;
  procedure DisableKeepAlive(sAccountName: String);

  procedure DeselectAllAudioCodec;
  procedure SelectAllAudioCodec;

  function SelectAudioCodec(nCodecNo: Integer): Boolean;
  function DeselectAudioCodec(nCodecNo: Integer): Boolean;

  procedure DeselectAllVideoCodec;
  procedure SelectAllVideoCodec;

  function SelectVideoCodec(nCodecNo: Integer): Boolean;
  procedure DeselectVideoCodec(nCodecNo: Integer);

  function DigitDTMF(nLineNo: Integer; sDigit: String; nTypeDTMF: Integer): Boolean;

  function SetVolumeDTMF(nVolume: Integer): Boolean;
  function GetVolumeDTMF: Integer;
  
  function MuteMic(bMute: Boolean): Boolean;
  function MuteSpk(bMute: Boolean): Boolean;

  function MuteLineSpk(nLineNo: Integer; bMute: Boolean): Boolean;
  function MuteLineMic(nLineNo: Integer; bMute: Boolean): Boolean;

  function AutoGainMic(bEnable: Boolean; nVolume: Integer): Boolean;
  function AutoGainSpk(bEnable: Boolean; nVolume: Integer): Boolean;

  function SetVolumeMic(nVolume: Integer): Boolean;
  function GetVolumeMic: Integer;
  function SetVolumeSpk(nVolume: Integer): Boolean;
  function GetVolumeSpk: Integer;

  function SetLineVolumeSpk(nLineNo: Integer; nVolume: Integer): Boolean;
  function GetLineVolumeSpk(nLineNo: Integer): Integer;

  function EchoCancellation(bEnable: Boolean): Boolean;
  function DonotDisturb(bEnable: Boolean): Boolean;

  function IsLineRecording(nLineNo: Integer): Boolean;

  function StartRecording(nLineNo: Integer; sFileName: String; nTypeRecord: Integer; nTypePCM: Integer): Boolean;
  function StopRecording(nLineNo: Integer): Boolean;
  function ResetRecording(nLineNo: Integer): Boolean;

  function IsLinePlaying(nLineNo: Integer): Boolean;

  function PlayWaveOpen(nLineNo: Integer; sFileName: String): Boolean;
  function PlayWaveClose(nLineNo: Integer): Boolean;
  function PlayWaveSkipTo(nLineNo: Integer; nMilliSeconds: Integer): Boolean;

  function PlayWaveTotalTime(nLineNo: Integer): Integer;
  function PlayWavePause(nLineNo: Integer): Boolean;
  function PlayWaveStart(nLineNo: Integer; bListen: Boolean): Boolean;
  function PlayWaveStop(nLineNo: Integer): Boolean;
  function PlayWavePosition(nLineNo: Integer): Integer;

  function GetOutboundCodec(nLineNo: Integer): Integer;
  function GetInboundCodec(nLineNo: Integer): Integer;

  function AudioSessionLost(nSeconds: Integer): Boolean;

  function SetUserAgentSIP(sUserAgentName: String): Boolean;
  function GetUserAgentSIP: String;

  function SetSubjectSDP(sSubjectSDP: String): Boolean;
  function GetSubjectSDP: String;

  function ConfAllowLine(nLineNo: Integer; bAllowListen: Boolean; bAllowSpeak: Boolean): Boolean;
  function LineVoiceChannelSpk(nLineNo: Integer; nChannel: Integer): Boolean;

  function ChatAddContact(sAccountName: String; sUserName: String; bPresence: Boolean): Boolean;
  function ChatRemoveContact(sAccountName: String; sUserName: String): Boolean;

  function ChatSendMessageTyping(sAccountName: String; sUserName: String; nUserValue: Int64): Boolean;
  function ChatSendMessageText(sAccountName: String; sUserName: String; sMsgText: String; bMsgTypeHtml: Boolean; nUserValue: Int64): Boolean;
  function ChatSetMyStatus(sAccountName: String; nStatusId: Integer): Boolean;

  function VoiceChanger(nPitch: Integer): Boolean;
  function ForwardCall(bEnable: Boolean; sToUserName: String): Boolean;

  function PlayAddPCM(nLineNo: Integer; nDataPCM: Int64; nSizePCM: Integer): Boolean;
  function PlayResetPCM(nLineNo: Integer): Boolean;

  function DetectAMD(nLineNo: Integer; bEnable: Boolean; nAnalysisTime: Integer; nSilenceTime: Integer; nSilenceCount: Integer): Boolean;

  function AddCustomHeader(nLineNo: Integer; nReqId: Integer; sName: String; sValue: String): Boolean;
  function RemoveCustomHeader(nLineNo: Integer; nReqId: Integer; sName: String): Boolean;
  function RemoveCustomHeaderAll(nLineNo: Integer; nReqId: Integer): Boolean;

  function ActivateQosSIP(nPriorityQos: Integer): Boolean;
  procedure DeactivateQosSIP;

  function ActivateQosRTP(nLineNo: Integer; nPriorityQos: Integer): Boolean;
  procedure DeactivateQosRTP(nLineNo: Integer);

  function GetCountPacketLost(nLineNo: Integer): Integer;
  function GetSizeJitterBuffer(nLineNo: Integer): Integer;

  function OpenMediaSecondry(nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  function CloseMediaSecondry: Boolean;

  function ChangeMEDIA(nLineNo: Integer; nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;

  function GetVideoDevTotal: Integer;
  function GetVideoDevName(nDeviceId: Integer): String;

  function OpenVideoDev(nDeviceId: Integer; nQuality: Integer): Boolean;
  procedure CloseVideoDev;

  function DialRingEnable(sFileName: String): Boolean;
  function DialRingDisable: Boolean;

  function BusyRingEnable(sFileName: String): Boolean;
  function BusyRingDisable: Boolean;

  function EnableVideo(nLineNo: Integer; bOutbound: Boolean; bInbound: Boolean): Boolean;

  function IsNetworkAvailable: Boolean;
  function NetworkReachability(bEnable: Boolean): Boolean;

  function AutoRegistration(sAccountName: String; bEnable: Boolean; nTickCountLimit: Integer; nTickSeconds: Integer): Boolean;
  function VideoCodecBitRate(nCodecNo: Integer; nQuality: Integer): Boolean;

  function AddCustomHeaderReferToURI(sName: String; sValue: String): Boolean;
  function RemoveCustomHeaderReferToURI(sName: String): Boolean;
  function RemoveCustomHeaderAllReferToURI: Boolean;

  function BusyLampGetContactStatus(sAccountName: String; sUserName: String): Integer;
  function BusyLampFindContact(sAccountName: String; sUserName: String): Boolean;
  function BusyLampAddContact(sAccountName: String; sUserName: String): Boolean;
  function BusyLampRemoveContact(sAccountName: String; sUserName: String): Boolean;
  function BusyLampSubscribeContactAll(sAccountName: String): Boolean;

  function CryptoMediaNONE(bForced: Boolean): Boolean;
  function CryptoMediaSDP(bForced: Boolean): Boolean;

  function DiagnosticLogSIP(sAccountName: String; bInbound: Boolean; bOutbound: Boolean): Boolean;
  function RefreshLine(nLineNo: Integer): Boolean;
  function AudioVAD(nLineNo: Integer; bEnable: Boolean): Boolean;

  public

  procedure OnInitialized(); virtual;
  procedure OnUnInitialized(); virtual;

  procedure OnConnectingToRegister(sAccountName: String); virtual;
  procedure OnTryingToRegister(sAccountName: String); virtual;

  procedure OnFailToRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String); virtual;
  procedure OnSuccessToRegister(sAccountName: String); virtual;

  procedure OnConnectingToReRegister(sAccountName: String); virtual;
  procedure OnTryingToReRegister(sAccountName: String); virtual;
  procedure OnFailToReRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String); virtual;
  procedure OnSuccessToReRegister(sAccountName: String); virtual;

  procedure OnTryingToUnRegister(sAccountName: String); virtual;
  procedure OnFailToUnRegister(sAccountName: String); virtual;
  procedure OnSuccessToUnRegister(sAccountName: String); virtual;

  procedure OnDialCallStarted(sAccountName: String; nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String); virtual;
  procedure OnDialingCall(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String); virtual;
  procedure OnDialCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String); virtual;

  procedure OnConnectedCall(sAccountName: String; nLineNo: Integer; sToRTPIP: String; ToRTPPort: Integer); virtual;
  procedure OnHungupCall(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnIncomingCallStarted(sAccountName: String; sCallId: String; sCallerName: String; sCallerId: String; sDialNo: String; sFromURI: String; sToURI: String); virtual;
  procedure OnIncomingCallEnded(sAccountName: String; sCallId: String; nReasonCode: Integer); virtual;

  procedure OnRingToneStarted(sAccountName: String; sCallId: String); virtual;
  procedure OnRingToneEnded(sAccountName: String; sCallId: String); virtual;

  procedure OnTransferCallAccepted(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnTransferCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String); virtual;

  procedure OnPlayWaveDone(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnDigitDTMF(sAccountName: String; nLineNo: Integer; sDigit: String); virtual;
  procedure OnMsgNOTIFY(sAccountName: String; sMsg: String); virtual;

  procedure OnVoiceMailMsg(sAccountName: String; bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String); virtual;

  procedure OnIncomingDiagnostic(sAccountName: String; sMsgSIP: String; sFromIP: String; nFromPort: Integer); virtual;
  procedure OnOutgoingDiagnostic(sAccountName: String; sMsgSIP: String; sToIP: String; nToPort: Integer); virtual;

  procedure OnAudioSessionLost(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnSuccessToHold(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnTryingToHold(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnFailToHold(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnSuccessToUnHold(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnTryingToUnHold(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnFailToUnHold(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnChatSubscribeSuccess(sAccountName: String; sUserName: String); virtual;
  procedure OnChatSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String); virtual;

  procedure OnChatContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer); virtual;
  procedure OnChatSendMsgTextSuccess(sAccountName: String; sUserName: String; sMsgText: String; nUserValue: Int64); virtual;
  procedure OnChatSendMsgTextFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; sMsgText: String; UserValue: Int64); virtual;

  procedure OnChatSendMsgTypingSuccess(sAccountName: String; sUserName: String; nUserValue: Int64); virtual;
  procedure OnChatSendMsgTypingFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; nUserValue: Int64); virtual;

  procedure OnChatRecvMsgText(sAccountName: String; sUserName: String; sMsgText: String; bIsChatContact: Boolean); virtual;

  procedure OnChatRecvMsgTypingStart(sAccountName: String; sUserName: String); virtual;
  procedure OnChatRecvMsgTypingStop(sAccountName: String; sUserName: String); virtual;

  procedure OnDetectedAMD(sAccountName: String; nLineNo: Integer; bIsHuman: Boolean); virtual;

  procedure OnHoldCall(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnUnHoldCall(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer); virtual;
  procedure OnVideoRemoteFrameRGB(sAccountName: String; nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer); virtual;

  procedure OnVideoRemoteStarted(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnVideoRemoteEnded(sAccountName: String; nLineNo: Integer); virtual;

  procedure OnAddCallHistory(sAccountName: String; bOutboundCallType: Boolean; sCallerName: String; sCallerId: String; sDialNo: String; nStartTime: Largeuint; nEndTime: Largeuint; nDuration: Largeuint; nDayNo: Largeuint; nHistoryTypeId: Integer); virtual;
  procedure OnNetworkReachability(bAvailable: Boolean); virtual;

  procedure OnAudioDeviceMicVU(nLevelVU: Integer); virtual;
  procedure OnAudioDeviceSpkVU(nLevelVU: Integer); virtual;

  procedure OnVaxErrorMsg(sFuncName: String; sErrorMsg: String; nErrorCode: Integer); virtual;

  procedure OnBusyLampSubscribeSuccess(sAccountName: String; sUserName: String); virtual;
  procedure OnBusyLampSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String); virtual;
  procedure OnBusyLampContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer); virtual;

  procedure OnAudioRecordedPCM(sAccountName: String; nLineNo: Integer; nDataPCM: Int64; nSizePCM: Integer; nTypePCM: Integer); virtual;

  procedure OnSuccessToRefresh(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnTryingToRefresh(sAccountName: String; nLineNo: Integer); virtual;
  procedure OnFailToRefresh(sAccountName: String; nLineNo: Integer); virtual;

end;

 //////////////////////////////////////////////////////////////////////////////
 //////////////////////////////////////////////////////////////////////////////

implementation

  constructor TVaxSIPUserAgentCOM.Create();
  begin
    inherited Create(Nil);
  end;

  function TVaxSIPUserAgentCOM.GetVersionFile: String;
  begin
    Result := String(inherited GetVersionFile());
  end;

  function TVaxSIPUserAgentCOM.GetVersionSDK: String;
  begin
    Result := String(inherited GetVersionSDK());
  end;

  function TVaxSIPUserAgentCOM.Initialize: Boolean;
  begin
    Result := Boolean(inherited Initialize());
  end;

  procedure TVaxSIPUserAgentCOM.UnInitialize;
  begin
    inherited UnInitialize();
  end;

  function TVaxSIPUserAgentCOM.SetLicenceKey(sLicenceKey: String): Boolean;
  begin
    Result := Boolean(inherited SetLicenceKey(sLicenceKey));
  end;

  function TVaxSIPUserAgentCOM.GetCallId(nLineNo: Integer): String;
  begin
    Result := String(inherited GetCallId(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.AudioDeviceVU(bActivate: Boolean; bMicVU: Boolean; bSpkVU: Boolean): Boolean;
  begin
    Result := Boolean(inherited AudioDeviceVU(bActivate, bMicVU, bSpkVU));
  end;

  function TVaxSIPUserAgentCOM.GetAudioInDevTotal: Integer;
  begin
    Result := Integer(inherited GetAudioInDevTotal());
  end;

  function TVaxSIPUserAgentCOM.GetAudioOutDevTotal: Integer;
  begin
    Result := Integer(inherited GetAudioOutDevTotal());
  end;

  function TVaxSIPUserAgentCOM.GetAudioInDevName(nDeviceId: Integer): String;
  begin
    Result := String(inherited GetAudioInDevName(nDeviceId));
  end;

  function TVaxSIPUserAgentCOM.GetAudioOutDevName(nDeviceId: Integer): String;
  begin
    Result := String(inherited GetAudioOutDevName(nDeviceId));
  end;

  function TVaxSIPUserAgentCOM.AddAccountSIP(sAccountName: String; nAccountType: Integer; sListenIP: String; nListenPort: Integer; sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer): Boolean;
  begin
    Result := Boolean(inherited AddAccountSIP(sAccountName, nAccountType, sListenIP, nListenPort, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort));
  end;

  procedure TVaxSIPUserAgentCOM.RemoveAccountSIP(sAccountName: String);
  begin
    inherited RemoveAccountSIP(sAccountName);
  end;

  function TVaxSIPUserAgentCOM.RegisterAccountSIP(sAccountName: String; nExpire: Integer): Boolean;
  begin
    Result := Boolean(inherited RegisterAccountSIP(sAccountName, nExpire));
  end;

  function TVaxSIPUserAgentCOM.UnRegisterAccountSIP(sAccountName: String): Boolean;
  begin
    Result := Boolean(inherited UnRegisterAccountSIP(sAccountName));
  end;

  function TVaxSIPUserAgentCOM.OpenLine(nLineNo: Integer; sRTPRxIP: String; sRxAudioPortRTP: Integer; nRxVideoPortRTP: Integer): Boolean;
  begin
    Result := Boolean(inherited OpenLine(nLineNo, sRTPRxIP, sRxAudioPortRTP, nRxVideoPortRTP));
  end;

  function TVaxSIPUserAgentCOM.OpenLineREC(nLineNo: Integer; sRTPRxIP: String; nAudioPortRTP: Integer): Boolean;
  begin
    Result := Boolean(inherited OpenLineREC(nLineNo, sRTPRxIP, nAudioPortRTP));
  end;

  function TVaxSIPUserAgentCOM.CloseLine(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited CloseLine(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.GetVaxErrorCode: Integer;
  begin
    Result := Integer(inherited GetVaxErrorCode());
  end;

  function TVaxSIPUserAgentCOM.GetVaxErrorMsg: String;
  begin
    Result := String(inherited GetVaxErrorMsg());
  end;

  function TVaxSIPUserAgentCOM.DialCall(sAccountName: String; nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String; nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  begin
    Result := Boolean(inherited DialCall(sAccountName, nLineNo, sCallerName, sCallerId, sDialNo, nInputDeviceId, nOutputDeviceId));
  end;

  function TVaxSIPUserAgentCOM.DialCallToREC(sAccountName: String; nLineNo: Integer; sDialNo: String): Boolean;
  begin
    Result := Boolean(inherited DialCallToREC(sAccountName, nLineNo, sDialNo));
  end;

  function TVaxSIPUserAgentCOM.DisconnectCall(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited DisconnectCall(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.AcceptCall(nLineNo: Integer; sCallId: String; nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  begin
    Result := Boolean(inherited AcceptCall(nLineNo, sCallId, nInputDeviceId, nOutputDeviceId));
  end;

  function TVaxSIPUserAgentCOM.RejectCall(sCallId: String): Boolean;
  begin
    Result := Boolean(inherited RejectCall(sCallId));
  end;

  function TVaxSIPUserAgentCOM.TransferCallBlind(nLineNo: Integer; sToUserName: String): Boolean;
  begin
    Result := Boolean(inherited TransferCallBlind(nLineNo, sToUserName));
  end;

  function TVaxSIPUserAgentCOM.TransferCallConsult(nLineNoA: Integer; nLineNoB: Integer): Boolean;
  begin
    Result := Boolean(inherited TransferCallConsult(nLineNoA, nLineNoB));
  end;

  function TVaxSIPUserAgentCOM.HoldLine(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited HoldLine(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.UnHoldLine(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited UnHoldLine(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.IsLineOpen(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited IsLineOpen(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.IsLineHold(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited IsLineHold(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.IsLineBusy(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited IsLineBusy(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.IsLineConnected(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited IsLineConnected(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.EnableKeepAlive(sAccountName: String; nSeconds: Integer): Boolean;
  begin
    Result := Boolean(inherited EnableKeepAlive(sAccountName, nSeconds));
  end;

  procedure TVaxSIPUserAgentCOM.DisableKeepAlive(sAccountName: String);
  begin
    inherited DisableKeepAlive(sAccountName);
  end;

  procedure TVaxSIPUserAgentCOM.DeselectAllAudioCodec;
  begin
    inherited DeselectAllAudioCodec();
  end;

  procedure TVaxSIPUserAgentCOM.SelectAllAudioCodec;
  begin
    inherited SelectAllAudioCodec();
  end;

  function TVaxSIPUserAgentCOM.SelectAudioCodec(nCodecNo: Integer): Boolean;
  begin
    Result := Boolean(inherited SelectAudioCodec(nCodecNo));
  end;

  function TVaxSIPUserAgentCOM.DeselectAudioCodec(nCodecNo: Integer): Boolean;
  begin
    Result := Boolean(inherited DeselectAudioCodec(nCodecNo));
  end;

  procedure TVaxSIPUserAgentCOM.DeselectAllVideoCodec;
  begin
    inherited DeselectAllVideoCodec();
  end;

  procedure TVaxSIPUserAgentCOM.SelectAllVideoCodec;
  begin
    inherited SelectAllVideoCodec();
  end;

  function TVaxSIPUserAgentCOM.SelectVideoCodec(nCodecNo: Integer): Boolean;
  begin
    Result := Boolean(inherited SelectVideoCodec(nCodecNo));
  end;

  procedure TVaxSIPUserAgentCOM.DeselectVideoCodec(nCodecNo: Integer);
  begin
    inherited DeselectVideoCodec(nCodecNo);
  end;

  function TVaxSIPUserAgentCOM.DigitDTMF(nLineNo: Integer; sDigit: String; nTypeDTMF: Integer): Boolean;
  begin
    Result := Boolean(inherited DigitDTMF(nLineNo, sDigit, nTypeDTMF));
  end;

  function TVaxSIPUserAgentCOM.SetVolumeDTMF(nVolume: Integer): Boolean;
  begin
    Result := Boolean(inherited SetVolumeDTMF(nVolume));
  end;

  function TVaxSIPUserAgentCOM.GetVolumeDTMF: Integer;
  begin
    Result := Integer(inherited GetVolumeDTMF());
  end;
    
  function TVaxSIPUserAgentCOM.MuteMic(bMute: Boolean): Boolean;
  begin
    Result := Boolean(inherited MuteMic(bMute));
  end;

  function TVaxSIPUserAgentCOM.MuteSpk(bMute: Boolean): Boolean;
  begin
    Result := Boolean(inherited MuteSpk(bMute));
  end;

  function TVaxSIPUserAgentCOM.MuteLineSpk(nLineNo: Integer; bMute: Boolean): Boolean;
  begin
    Result := Boolean(inherited MuteLineSpk(nLineNo, bMute));
  end;

  function TVaxSIPUserAgentCOM.MuteLineMic(nLineNo: Integer; bMute: Boolean): Boolean;
  begin
    Result := Boolean(inherited MuteLineMic(nLineNo, bMute));
  end;

  function TVaxSIPUserAgentCOM.AutoGainMic(bEnable: Boolean; nVolume: Integer): Boolean;
  begin
    Result := Boolean(inherited AutoGainMic(bEnable, nVolume));
  end;

  function TVaxSIPUserAgentCOM.AutoGainSpk(bEnable: Boolean; nVolume: Integer): Boolean;
  begin
    Result := Boolean(inherited AutoGainSpk(bEnable, nVolume));
  end;

  function TVaxSIPUserAgentCOM.SetVolumeMic(nVolume: Integer): Boolean;
  begin
    Result := Boolean(inherited SetVolumeMic(nVolume));
  end;

  function TVaxSIPUserAgentCOM.GetVolumeMic: Integer;
  begin
    Result := Integer(inherited GetVolumeMic());
  end;

  function TVaxSIPUserAgentCOM.SetVolumeSpk(nVolume: Integer): Boolean;
  begin
    Result := Boolean(inherited SetVolumeSpk(nVolume));
  end;

  function TVaxSIPUserAgentCOM.GetVolumeSpk: Integer;
  begin
    Result := Integer(inherited GetVolumeSpk());
  end;

  function TVaxSIPUserAgentCOM.SetLineVolumeSpk(nLineNo: Integer; nVolume: Integer): Boolean;
  begin
    Result := Boolean(inherited SetLineVolumeSpk(nLineNo, nVolume));
  end;

  function TVaxSIPUserAgentCOM.GetLineVolumeSpk(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited GetLineVolumeSpk(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.EchoCancellation(bEnable: Boolean): Boolean;
  begin
    Result := Boolean(inherited EchoCancellation(bEnable));
  end;

  function TVaxSIPUserAgentCOM.DonotDisturb(bEnable: Boolean): Boolean;
  begin
    Result := Boolean(inherited DonotDisturb(bEnable));
  end;

  function TVaxSIPUserAgentCOM.IsLineRecording(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited IsLineRecording(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.StartRecording(nLineNo: Integer; sFileName: String; nTypeRecord: Integer; nTypePCM: Integer): Boolean;
  begin
    Result := Boolean(inherited StartRecording(nLineNo, sFileName, nTypeRecord, nTypePCM));
  end;

  function TVaxSIPUserAgentCOM.StopRecording(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited StopRecording(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.ResetRecording(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited ResetRecording(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.IsLinePlaying(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited IsLinePlaying(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.PlayWaveOpen(nLineNo: Integer; sFileName: String): Boolean;
  begin
    Result := Boolean(inherited PlayWaveOpen(nLineNo, sFileName));
  end;

  function TVaxSIPUserAgentCOM.PlayWaveClose(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited PlayWaveClose(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.PlayWaveSkipTo(nLineNo: Integer; nMilliSeconds: Integer): Boolean;
  begin
    Result := Boolean(inherited PlayWaveSkipTo(nLineNo, nMilliSeconds));
  end;

  function TVaxSIPUserAgentCOM.PlayWaveTotalTime(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited PlayWaveTotalTime(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.PlayWavePause(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited PlayWavePause(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.PlayWaveStart(nLineNo: Integer; bListen: Boolean): Boolean;
  begin
    Result := Boolean(inherited PlayWaveStart(nLineNo, bListen));
  end;

  function TVaxSIPUserAgentCOM.PlayWaveStop(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited PlayWaveStop(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.PlayWavePosition(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited PlayWavePosition(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.GetOutboundCodec(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited GetOutboundCodec(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.GetInboundCodec(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited GetInboundCodec(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.AudioSessionLost(nSeconds: Integer): Boolean;
  begin
    Result := Boolean(inherited AudioSessionLost(nSeconds));
  end;

  function TVaxSIPUserAgentCOM.SetUserAgentSIP(sUserAgentName: String): Boolean;
  begin
    Result := Boolean(inherited SetUserAgentSIP(sUserAgentName));
  end;

  function TVaxSIPUserAgentCOM.GetUserAgentSIP: String;
  begin
    Result := String(inherited GetUserAgentSIP());
  end;

  function TVaxSIPUserAgentCOM.SetSubjectSDP(sSubjectSDP: String): Boolean;
  begin
    Result := Boolean(inherited SetSubjectSDP(sSubjectSDP));
  end;

  function TVaxSIPUserAgentCOM.GetSubjectSDP: String;
  begin
    Result := String(inherited GetSubjectSDP());
  end;

  function TVaxSIPUserAgentCOM.ConfAllowLine(nLineNo: Integer; bAllowListen: Boolean; bAllowSpeak: Boolean): Boolean;
  begin
    Result := Boolean(inherited ConfAllowLine(nLineNo, bAllowListen, bAllowSpeak));
  end;

  function TVaxSIPUserAgentCOM.LineVoiceChannelSpk(nLineNo: Integer; nChannel: Integer): Boolean;
  begin
    Result := Boolean(inherited LineVoiceChannelSpk(nLineNo, nChannel));
  end;

  function TVaxSIPUserAgentCOM.ChatAddContact(sAccountName: String; sUserName: String; bPresence: Boolean): Boolean;
  begin
    Result := Boolean(inherited ChatAddContact(sAccountName, sUserName, bPresence));
  end;

  function TVaxSIPUserAgentCOM.ChatRemoveContact(sAccountName: String; sUserName: String): Boolean;
  begin
    Result := Boolean(inherited ChatRemoveContact(sAccountName, sUserName));
  end;

  function TVaxSIPUserAgentCOM.ChatSendMessageTyping(sAccountName: String; sUserName: String; nUserValue: Int64): Boolean;
  begin
    Result := Boolean(inherited ChatSendMessageTyping(sAccountName, sUserName, nUserValue));
  end;

  function TVaxSIPUserAgentCOM.ChatSendMessageText(sAccountName: String; sUserName: String; sMsgText: String; bMsgTypeHtml: Boolean; nUserValue: Int64): Boolean;
  begin
    Result := Boolean(inherited ChatSendMessageText(sAccountName, sUserName, sMsgText, bMsgTypeHtml, nUserValue));
  end;

  function TVaxSIPUserAgentCOM.ChatSetMyStatus(sAccountName: String; nStatusId: Integer): Boolean;
  begin
    Result := Boolean(inherited ChatSetMyStatus(sAccountName, nStatusId));
  end;

  function TVaxSIPUserAgentCOM.VoiceChanger(nPitch: Integer): Boolean;
  begin
    Result := Boolean(inherited VoiceChanger(nPitch));
  end;

  function TVaxSIPUserAgentCOM.ForwardCall(bEnable: Boolean; sToUserName: String): Boolean;
  begin
    Result := Boolean(inherited ForwardCall(bEnable, sToUserName));
  end;

  function TVaxSIPUserAgentCOM.PlayAddPCM(nLineNo: Integer; nDataPCM: Int64; nSizePCM: Integer): Boolean;
  begin
    Result := Boolean(inherited PlayAddPCM(nLineNo, nDataPCM, nSizePCM));
  end;

  function TVaxSIPUserAgentCOM.PlayResetPCM(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited PlayResetPCM(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.DetectAMD(nLineNo: Integer; bEnable: Boolean; nAnalysisTime: Integer; nSilenceTime: Integer; nSilenceCount: Integer): Boolean;
  begin
    Result := Boolean(inherited DetectAMD(nLineNo, bEnable, nAnalysisTime, nSilenceTime, nSilenceCount));
  end;

  function TVaxSIPUserAgentCOM.AddCustomHeader(nLineNo: Integer; nReqId: Integer; sName: String; sValue: String): Boolean;
  begin
    Result := Boolean(inherited AddCustomHeader(nLineNo, nReqId, sName, sValue));
  end;

  function TVaxSIPUserAgentCOM.RemoveCustomHeader(nLineNo: Integer; nReqId: Integer; sName: String): Boolean;
  begin
    Result := Boolean(inherited RemoveCustomHeader(nLineNo, nReqId, sName));
  end;

  function TVaxSIPUserAgentCOM.RemoveCustomHeaderAll(nLineNo: Integer; nReqId: Integer): Boolean;
  begin
    Result := Boolean(inherited RemoveCustomHeaderAll(nLineNo, nReqId));
  end;

  function TVaxSIPUserAgentCOM.ActivateQosSIP(nPriorityQos: Integer): Boolean;
  begin
    Result := Boolean(inherited ActivateQosSIP(nPriorityQos));
  end;

  procedure TVaxSIPUserAgentCOM.DeactivateQosSIP;
  begin
    inherited DeactivateQosSIP();
  end;

  function TVaxSIPUserAgentCOM.ActivateQosRTP(nLineNo: Integer; nPriorityQos: Integer): Boolean;
  begin
    Result := Boolean(inherited ActivateQosRTP(nLineNo, nPriorityQos));
  end;

  procedure TVaxSIPUserAgentCOM.DeactivateQosRTP(nLineNo: Integer);
  begin
    inherited DeactivateQosRTP(nLineNo);
  end;

  function TVaxSIPUserAgentCOM.GetCountPacketLost(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited GetCountPacketLost(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.GetSizeJitterBuffer(nLineNo: Integer): Integer;
  begin
    Result := Integer(inherited GetSizeJitterBuffer(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.OpenMediaSecondry(nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  begin
    Result := Boolean(inherited OpenMediaSecondry(nInputDeviceId, nOutputDeviceId));
  end;

  function TVaxSIPUserAgentCOM.CloseMediaSecondry: Boolean;
  begin
    Result := Boolean(inherited CloseMediaSecondry());
  end;

  function TVaxSIPUserAgentCOM.ChangeMEDIA(nLineNo: Integer; nInputDeviceId: Integer; nOutputDeviceId: Integer): Boolean;
  begin
    Result := Boolean(inherited ChangeMEDIA(nLineNo, nInputDeviceId, nOutputDeviceId));
  end;

  function TVaxSIPUserAgentCOM.GetVideoDevTotal: Integer;
  begin
    Result := Integer(inherited GetVideoDevTotal());
  end;

  function TVaxSIPUserAgentCOM.GetVideoDevName(nDeviceId: Integer): String;
  begin
    Result := String(inherited GetVideoDevName(nDeviceId));
  end;

  function TVaxSIPUserAgentCOM.OpenVideoDev(nDeviceId: Integer; nQuality: Integer): Boolean;
  begin
    Result := Boolean(inherited OpenVideoDev(nDeviceId, nQuality));
  end;

  procedure TVaxSIPUserAgentCOM.CloseVideoDev;
  begin
    inherited CloseVideoDev();
  end;

  function TVaxSIPUserAgentCOM.DialRingEnable(sFileName: String): Boolean;
  begin
    Result := Boolean(inherited DialRingEnable(sFileName));
  end;

  function TVaxSIPUserAgentCOM.DialRingDisable: Boolean;
  begin
    Result := Boolean(inherited DialRingDisable());
  end;

  function TVaxSIPUserAgentCOM.BusyRingEnable(sFileName: String): Boolean;
  begin
    Result := Boolean(inherited BusyRingEnable(sFileName));
  end;

  function TVaxSIPUserAgentCOM.BusyRingDisable: Boolean;
  begin
    Result := Boolean(inherited BusyRingDisable());
  end;

  function TVaxSIPUserAgentCOM.EnableVideo(nLineNo: Integer; bOutbound: Boolean; bInbound: Boolean): Boolean;
  begin
    Result := Boolean(inherited EnableVideo(nLineNo, bOutbound, bInbound));
  end;

  function TVaxSIPUserAgentCOM.IsNetworkAvailable: Boolean;
  begin
    Result := Boolean(inherited IsNetworkAvailable());
  end;

  function TVaxSIPUserAgentCOM.NetworkReachability(bEnable: Boolean): Boolean;
  begin
    Result := Boolean(inherited NetworkReachability(bEnable));
  end;

  function TVaxSIPUserAgentCOM.AutoRegistration(sAccountName: String; bEnable: Boolean; nTickCountLimit: Integer; nTickSeconds: Integer): Boolean;
  begin
    Result := Boolean(inherited AutoRegistration(sAccountName, bEnable, nTickCountLimit, nTickSeconds));
  end;

  function TVaxSIPUserAgentCOM.VideoCodecBitRate(nCodecNo: Integer; nQuality: Integer): Boolean;
  begin
    Result := Boolean(inherited VideoCodecBitRate(nCodecNo, nQuality));
  end;

  function TVaxSIPUserAgentCOM.AddCustomHeaderReferToURI(sName: String; sValue: String): Boolean;
  begin
    Result := Boolean(inherited AddCustomHeaderReferToURI(sName, sValue));
  end;

  function TVaxSIPUserAgentCOM.RemoveCustomHeaderReferToURI(sName: String): Boolean;
  begin
    Result := Boolean(inherited RemoveCustomHeaderReferToURI(sName));
  end;

  function TVaxSIPUserAgentCOM.RemoveCustomHeaderAllReferToURI: Boolean;
  begin
    Result := Boolean(inherited RemoveCustomHeaderAllReferToURI());
  end;

  function TVaxSIPUserAgentCOM.BusyLampGetContactStatus(sAccountName: String; sUserName: String): Integer;
  begin
    Result := Integer(inherited BusyLampGetContactStatus(sAccountName, sUserName));
  end;

  function TVaxSIPUserAgentCOM.BusyLampFindContact(sAccountName: String; sUserName: String): Boolean;
  begin
    Result := Boolean(inherited BusyLampFindContact(sAccountName, sUserName));
  end;

  function TVaxSIPUserAgentCOM.BusyLampAddContact(sAccountName: String; sUserName: String): Boolean;
  begin
    Result := Boolean(inherited BusyLampAddContact(sAccountName, sUserName));
  end;

  function TVaxSIPUserAgentCOM.BusyLampRemoveContact(sAccountName: String; sUserName: String): Boolean;
  begin
    Result := Boolean(inherited BusyLampRemoveContact(sAccountName, sUserName));
  end;

  function TVaxSIPUserAgentCOM.BusyLampSubscribeContactAll(sAccountName: String): Boolean;
  begin
    Result := Boolean(inherited BusyLampSubscribeContactAll(sAccountName));
  end;

  function TVaxSIPUserAgentCOM.CryptoMediaNONE(bForced: Boolean): Boolean;
  begin
    Result := Boolean(inherited CryptoMediaNONE(bForced));
  end;

  function TVaxSIPUserAgentCOM.CryptoMediaSDP(bForced: Boolean): Boolean;
  begin
    Result := Boolean(inherited CryptoMediaSDP(bForced));
  end;

  function TVaxSIPUserAgentCOM.DiagnosticLogSIP(sAccountName: String; bInbound: Boolean; bOutbound: Boolean): Boolean;
  begin
    Result := Boolean(inherited DiagnosticLogSIP(sAccountName, bInbound, bOutbound));
  end;

  function TVaxSIPUserAgentCOM.RefreshLine(nLineNo: Integer): Boolean;
  begin
    Result := Boolean(inherited RefreshLine(nLineNo));
  end;

  function TVaxSIPUserAgentCOM.AudioVAD(nLineNo: Integer; bEnable: Boolean): Boolean;
  begin
    Result := Boolean(inherited AudioVAD(nLineNo, bEnable));
  end;



procedure TVaxSIPUserAgentCOM.InvokeEvent(DispID: TDispID; var Params: TVariantArray);
begin

  case DispID of
    -1: Exit;  // DISPID_UNKNOWN
    1: OnInitialized();
    2: OnUnInitialized();
    3: OnConnectingToRegister(Params[0]);
    4: OnTryingToRegister(Params[0]);
    5: OnFailToRegister(Params[0], Params[1], Params[2]);
    6: OnSuccessToRegister(Params[0]);
    7: OnConnectingToReRegister(Params[0]);
    8: OnTryingToReRegister(Params[0]);
    9: OnFailToReRegister(Params[0], Params[1], Params[2]);
    10: OnSuccessToReRegister(Params[0]);
    11: OnTryingToUnRegister(Params[0]);
    12: OnFailToUnRegister(Params[0]);
    13: OnSuccessToUnRegister(Params[0]);
    14: OnDialCallStarted(Params[0], Params[1], Params[2], Params[3], Params[4]);
    15: OnDialingCall(Params[0], Params[1], Params[2], Params[3]);
    16: OnDialCallFailed(Params[0], Params[1], Params[2], Params[3], Params[4]);
    17: OnConnectedCall(Params[0], Params[1], Params[2], Params[3]);
    18: OnHungupCall(Params[0], Params[1]);
    19: OnIncomingCallStarted(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5], Params[6]);
    20: OnIncomingCallEnded(Params[0], Params[1], Params[2]);
    21: OnRingToneStarted(Params[0],Params[1]);
    22: OnRingToneEnded(Params[0],Params[1]);
    23: OnTransferCallAccepted(Params[0], Params[1]);
    24: OnTransferCallFailed(Params[0], Params[1], Params[2], Params[3]);
    25: OnPlayWaveDone(Params[0], Params[1]);
    26: OnDigitDTMF(Params[0], Params[1], Params[2]);
    27: OnMsgNOTIFY(Params[0], Params[1]);
    28: OnVoiceMailMsg(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5], Params[6]);
    29: OnIncomingDiagnostic(Params[0], Params[1], Params[2], Params[3]);
    30: OnOutgoingDiagnostic(Params[0], Params[1], Params[2], Params[3]);
    31: OnAudioSessionLost(Params[0], Params[1]);
    32: OnSuccessToHold(Params[0], Params[1]);
    33: OnTryingToHold(Params[0], Params[1]);
    34: OnFailToHold(Params[0], Params[1]);
    35: OnSuccessToUnHold(Params[0], Params[1]);
    36: OnTryingToUnHold(Params[0], Params[1]);
    37: OnFailToUnHold(Params[0], Params[1]);
    38: OnChatContactStatus(Params[0], Params[1], Params[2]);
    39: OnChatSendMsgTextSuccess(Params[0], Params[1],Params[2], Params[3]);
    40: OnChatSendMsgTextFailed(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5]);
    41: OnChatSendMsgTypingSuccess(Params[0], Params[1], Params[2]);
    42: OnChatSendMsgTypingFailed(Params[0], Params[1], Params[2], Params[3], Params[4]);
    43: OnChatRecvMsgText(Params[0], Params[1], Params[2], Params[3]);
    44: OnChatRecvMsgTypingStart(Params[0], Params[1]);
    45: OnChatRecvMsgTypingStop(Params[0], Params[1]);
    46: OnDetectedAMD(Params[0], Params[1], Params[2]);
    47: OnHoldCall(Params[0], Params[1]);
    48: OnUnHoldCall(Params[0], Params[1]);
    49: OnVideoDeviceFrameRGB(Params[0], Params[1], Params[2], Params[3], Params[4]);
    50: OnVideoRemoteFrameRGB(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5]);
    51: OnVideoRemoteStarted(Params[0], Params[1]);
    52: OnVideoRemoteEnded(Params[0], Params[1]);
    53: OnAddCallHistory(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5], Params[6], Params[7], Params[8], Params[9]);
    54: OnNetworkReachability(Params[0]);
    55: OnAudioDeviceMicVU(Params[0]);
    56: OnAudioDeviceSpkVU(Params[0]);
    57: OnVaxErrorMsg(Params[0], Params[1], Params[2]);
    58: OnBusyLampSubscribeSuccess(Params[0], Params[1]);
    59: OnBusyLampSubscribeFailed(Params[0], Params[1], Params[2], Params[3]);
    60: OnBusyLampContactStatus(Params[0], Params[1], Params[2]);
    61: OnAudioRecordedPCM(Params[0], Params[1], Params[2], Params[3], Params[4]);
    62: OnChatSubscribeSuccess(Params[0], Params[1]);
    63: OnChatSubscribeFailed(Params[0], Params[1], Params[2], Params[3]);
    64: OnSuccessToRefresh(Params[0], Params[1]);
    65: OnTryingToRefresh(Params[0], Params[1]);
    66: OnFailToRefresh(Params[0], Params[1]);

  end; {case DispID}
end;


  procedure TVaxSIPUserAgentCOM.OnInitialized();
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnUnInitialized();
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnConnectingToRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTryingToRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnFailToRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnSuccessToRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnConnectingToReRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTryingToReRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnFailToReRegister(sAccountName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnSuccessToReRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTryingToUnRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnFailToUnRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnSuccessToUnRegister(sAccountName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnDialCallStarted(sAccountName: String; nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnDialingCall(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnDialCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnConnectedCall(sAccountName: String; nLineNo: Integer; sToRTPIP: String; ToRTPPort: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnHungupCall(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnIncomingCallStarted(sAccountName: String; sCallId: String; sCallerName: String; sCallerId: String; sDialNo: String; sFromURI: String; sToURI: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnIncomingCallEnded(sAccountName: String; sCallId: String; nReasonCode: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnRingToneStarted(sAccountName: String; sCallId: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnRingToneEnded(sAccountName: String; sCallId: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTransferCallAccepted(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTransferCallFailed(sAccountName: String; nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnPlayWaveDone(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnDigitDTMF(sAccountName: String; nLineNo: Integer; sDigit: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnMsgNOTIFY(sAccountName: String; sMsg: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnVoiceMailMsg(sAccountName: String; bIsMsgWaiting: Boolean; nNewMsgCount: Integer; nOldMsgCount: Integer; nNewUrgentMsgCount: Integer; nOldUrgentMsgCount: Integer; sMsgAccount: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnIncomingDiagnostic(sAccountName: String; sMsgSIP: String; sFromIP: String; nFromPort: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnOutgoingDiagnostic(sAccountName: String; sMsgSIP: String; sToIP: String; nToPort: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnAudioSessionLost(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnSuccessToHold(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTryingToHold(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnFailToHold(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnSuccessToUnHold(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTryingToUnHold(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnFailToUnHold(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatSubscribeSuccess(sAccountName: String; sUserName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatSendMsgTextSuccess(sAccountName: String; sUserName: String; sMsgText: String; nUserValue: Int64);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatSendMsgTextFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; sMsgText: String; UserValue: Int64);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatSendMsgTypingSuccess(sAccountName: String; sUserName: String; nUserValue: Int64);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatSendMsgTypingFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String; nUserValue: Int64);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatRecvMsgText(sAccountName: String; sUserName: String; sMsgText: String; bIsChatContact: Boolean);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatRecvMsgTypingStart(sAccountName: String; sUserName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnChatRecvMsgTypingStop(sAccountName: String; sUserName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnDetectedAMD(sAccountName: String; nLineNo: Integer; bIsHuman: Boolean);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnHoldCall(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnUnHoldCall(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnVideoDeviceFrameRGB(nDeviceId: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnVideoRemoteFrameRGB(sAccountName: String; nLineNo: Integer; nFrameRGB: Int64; nFrameSize: Integer; nFrameWidth: Integer; nFrameHeight: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnVideoRemoteStarted(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnVideoRemoteEnded(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnAddCallHistory(sAccountName: String; bOutboundCallType: Boolean; sCallerName: String; sCallerId: String; sDialNo: String; nStartTime: Largeuint; nEndTime: Largeuint; nDuration: Largeuint; nDayNo: Largeuint; nHistoryTypeId: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnNetworkReachability(bAvailable: Boolean);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnAudioDeviceMicVU(nLevelVU: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnAudioDeviceSpkVU(nLevelVU: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnVaxErrorMsg(sFuncName: String; sErrorMsg: String; nErrorCode: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnBusyLampSubscribeSuccess(sAccountName: String; sUserName: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnBusyLampSubscribeFailed(sAccountName: String; sUserName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnBusyLampContactStatus(sAccountName: String; sUserName: String; nStatusId: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnAudioRecordedPCM(sAccountName: String; nLineNo: Integer; nDataPCM: Int64; nSizePCM: Integer; nTypePCM: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnSuccessToRefresh(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnTryingToRefresh(sAccountName: String; nLineNo: Integer);
  begin
  end;

  procedure TVaxSIPUserAgentCOM.OnFailToRefresh(sAccountName: String; nLineNo: Integer);
  begin
  end;

end.
