unit PhoneTone;

interface

uses
  MMSystem,
  Vcl.StdCtrls,
  VaxSIPUserAgentExCOM,
  System.SysUtils;

type TPhoneTone = class

private
	m_bActivateRingTone: Boolean;
  m_objVaxCOM: TVaxSIPUserAgentExCOM;

public

  constructor Create(objVaxCOM: TVaxSIPUserAgentExCOM);
  procedure ActivateRingTone(bActivate: Boolean);
  procedure ActivateDialTone(bActivate: Boolean);

public

  procedure OnVaxOnline(bActivateRingTone: Boolean; bActivateDialTone: Boolean);

	procedure OnRingToneStarted(sCallId: String);
	procedure OnRingToneEnded(sCallId: String);

end;

implementation

constructor TPhoneTone.Create(objVaxCOM: TVaxSIPUserAgentExCOM);
begin

  m_objVaxCOM := objVaxCOM;
  m_bActivateRingTone := False;

end;
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneTone.OnVaxOnline(bActivateRingTone: Boolean; bActivateDialTone: Boolean);
begin

  m_objVaxCOM.BusyRingEnable();

  ActivateRingTone(bActivateRingTone);
  ActivateDialTone(bActivateDialTone);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneTone.ActivateRingTone(bActivate: Boolean);
begin

  m_bActivateRingTone := bActivate;

  if bActivate = false then
  begin
    PlaySound(nil, 0, 0);
  end;

end;

procedure TPhoneTone.ActivateDialTone(bActivate: Boolean);
begin

  if bActivate then

  begin
    m_objVaxCOM.DialRingEnable();
  end

  else
    m_objVaxCOM.DialRingDisable();

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneTone.OnRingToneStarted(sCallId: String);
begin

  if m_bActivateRingTone = false then exit;

  PlaySound('../../Ring.wav', 0, SND_ASYNC + SND_FILENAME + SND_LOOP + SND_NODEFAULT);

end;

procedure TPhoneTone.OnRingToneEnded(sCallId: String);
begin

  if m_bActivateRingTone = false then exit;
  
  PlaySound(nil, 0, 0);

end;

end.
