unit PhoneIncomingCall;

interface

uses
  MainForm,
  Alert,
  ListData,
  MainPhoneForm,
  Vcl.StdCtrls,
  VaxSIPUserAgentExCOM;

type
  TPhoneIncomingCall = class

public
    m_objMainForm: TMainForm;
    m_objVaxCOM: TVaxSIPUserAgentExCOM;
    m_ctrlListIncomingCalls: TListBox;

private
    m_objAlertForm: TFormAlert;
     m_objFormPhone: TMainPhoneForm;
public

    constructor Create();
    Function FindCallId(sCallId: String): Boolean;
    procedure RemoveCall(sCallID: String);
    procedure SetListIncomingCall(ctrlList: TListBox);

    procedure OnIncomingCallStarted(sCallId: String; sCallerName: String; sCallerId: String);
    procedure OnIncomingCallEnded(sCallId: String);
    procedure ShowIncomingCallMsgBox(bShow: Boolean);

    Function AcceptCall(nLineNo: Integer): Boolean;
    procedure RejectCall();

private
   function GenCallerInfo(sCallerName: String; sCallerId: String): String;
public

      const PHONE_TAB_PAGE_INDEX: Integer = 1;

  end;

implementation

constructor TPhoneIncomingCall.Create();
begin
  //
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneIncomingCall.SetListIncomingCall(ctrlList: TListBox);
begin
  m_ctrlListIncomingCalls := ctrlList;
end;

function TPhoneIncomingCall.GenCallerInfo(sCallerName: String; sCallerId: String): String;
var
  sCallerInfo: String;
begin

  if Length(sCallerName) <> 0 then
  begin
    sCallerInfo := 'NAME:' + sCallerName + ', CLI:' +  sCallerId;
  end
  else
    sCallerInfo := 'NAME: Unknown' + ', CLI:' +  sCallerId;

  Result := sCallerInfo;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneIncomingCall.OnIncomingCallStarted(sCallId: String; sCallerName: String; sCallerId: String);
var
  sCallerInfo: String;
begin

  if FindCallId(sCallId) = True Then
    Exit;

  sCallerInfo := GenCallerInfo(sCallerName, sCallerId);

  m_ctrlListIncomingCalls.AddItem(sCallerInfo, TListData.Create(sCallId));

  if (m_ctrlListIncomingCalls.ItemIndex = -1) and (m_ctrlListIncomingCalls.Items.Count > 0) Then
    m_ctrlListIncomingCalls.ItemIndex := 0;

    ShowIncomingCallMsgBox(True);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneIncomingCall.OnIncomingCallEnded(sCallId: String);
begin
  ShowIncomingCallMsgBox(False);
  RemoveCall(sCallId);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneIncomingCall.ShowIncomingCallMsgBox(bShow: Boolean);
var
  nTabIndex: Integer;
begin

  if bShow then
  begin

    nTabIndex := m_objMainForm.GetActiveTab();
    if (nTabIndex = PHONE_TAB_PAGE_INDEX) or (m_objAlertForm <> nil) then Exit();

    m_objAlertForm := TFormAlert.Create(m_objFormPhone);
    m_objAlertForm.ShowModal;

    Exit();

  end;

   if (m_objAlertForm = nil) Then Exit();

   m_objAlertForm.Close;
   m_objAlertForm := nil;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function TPhoneIncomingCall.AcceptCall(nLineNo: Integer): Boolean;
var
  nSelectedItemIndex: Integer;
  sCallId: String;
  objListData: TListData;
begin

  nSelectedItemIndex := m_ctrlListIncomingCalls.ItemIndex;

  if nSelectedItemIndex = -1 then
  begin
    Result := False;
    Exit();
  end;

  objListData := TListData(m_ctrlListIncomingCalls.Items.Objects[nSelectedItemIndex]);
  sCallId := objListData.m_sData;

  if not m_objVaxCOM.AcceptCall(nLineNo, sCallId) then
  begin
    Result := False;
    Exit();
  end;

  m_ctrlListIncomingCalls.Items.Objects[nSelectedItemIndex].Free;
  m_ctrlListIncomingCalls.Items.Delete(nSelectedItemIndex);

  if m_ctrlListIncomingCalls.Items.Count > 0 then
  begin
    if m_ctrlListIncomingCalls.ItemIndex = -1 Then
      m_ctrlListIncomingCalls.ItemIndex := 0;

      Result := False;
      Exit();
  end;

  Result := True;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneIncomingCall.RejectCall;
var
  nSelectedItemIndex: Integer;
  sCallId: String;
  objListData: TListData;
begin

  nSelectedItemIndex := m_ctrlListIncomingCalls.ItemIndex;

  if nSelectedItemIndex = -1 then
    Exit;

  objListData := TListData(m_ctrlListIncomingCalls.Items.Objects[nSelectedItemIndex]);
  sCallId := objListData.m_sData;

  if not m_objVaxCOM.RejectCall(sCallId) then
    Exit;

  m_ctrlListIncomingCalls.Items.Objects[nSelectedItemIndex].Free;
  m_ctrlListIncomingCalls.Items.Delete(nSelectedItemIndex);

  if m_ctrlListIncomingCalls.Items.Count > 0 then
  begin
    if m_ctrlListIncomingCalls.ItemIndex = -1 Then
      m_ctrlListIncomingCalls.ItemIndex := 0;
      Exit;
  end;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function TPhoneIncomingCall.FindCallId(sCallId: String): Boolean;
var
  nListIndex: Integer;
  sResult: String;
  objListData: TListData;
begin

  for nListIndex := 0 to m_ctrlListIncomingCalls.Items.Count - 1 do
  begin
    objListData := TListData(m_ctrlListIncomingCalls.Items.Objects[nListIndex]);
    sResult := objListData.m_sData;

    if sResult = sCallId Then
    begin
      Result := True;
      Exit;
    end;

  end;

  Result := False;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TPhoneIncomingCall.RemoveCall(sCallId: String);
var
  nListIndex: Integer;
  objListData: TListData;
  sResult: String;
begin

  for nListIndex := 0 to m_ctrlListIncomingCalls.GetCount() - 1 do
  begin

    objListData := TListData(m_ctrlListIncomingCalls.Items.Objects[nListIndex]);
    sResult := objListData.m_sData;

    if sCallId = sResult then
    begin
      m_ctrlListIncomingCalls.Items.Objects[nListIndex].Free;
      m_ctrlListIncomingCalls.Items.Delete(nListIndex);

      Exit
    end;

  end;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

end.
