unit MainPhoneForm;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  MMSystem,
  Vcl.Forms,
  ExtCtrls,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
  VaxSIPUserAgentExCOM,
  ListData,
  Alert,
  LineVoice,
  PhoneTone,
  StorePhoneNo;

type
  TMainPhoneForm = class(TForm)
    GroupDialPad: TGroupBox;
    EditPhoneNo: TEdit;
    BtnDial1: TButton;
    BtnDial2: TButton;
    BtnDial3: TButton;
    BtnDial4: TButton;
    BtnDial5: TButton;
    BtnDial6: TButton;
    BtnDial7: TButton;
    BtnDial8: TButton;
    BtnDial9: TButton;
    BtnDialStar: TButton;
    BtnDial0: TButton;
    BtnDialNo: TButton;
    CheckPlayDialTone: TCheckBox;
    BtnDial: TButton;
    BtnHold: TButton;
    GroupAnsMachine: TGroupBox;
    CheckDetectAMD: TCheckBox;
    GroupCallRecord: TGroupBox;
    LabelFileRecord: TLabel;
    BtnResetRecordingBuffer: TButton;
    EditRecordFileName: TEdit;
    GroupPlaywav: TGroupBox;
    LabelFilePlay: TLabel;
    CheckPlayListen: TCheckBox;
    BtnStartPlay: TButton;
    BtnSetPlayFile: TButton;
    EditPlayFileName: TEdit;
    BtnPlayRewind: TButton;
    BtnPlayForward: TButton;
    BtnPlayPause: TButton;
    BtnPlayStop: TButton;
    GroupIncomingCall: TGroupBox;
    BtnAccept: TButton;
    BtnReject: TButton;
    ListIncomingCall: TListBox;
    CheckPlayRingTone: TCheckBox;
    GroupCallFwd: TGroupBox;
    LabelPhoneFwd: TLabel;
    EditForwardCallPhoneNo: TEdit;
    CheckForwardCall: TCheckBox;
    GroupBlindTransfer: TGroupBox;
    LabelBlindPhone: TLabel;
    BtnTransferCall: TButton;
    EditTransferPhoneNo: TEdit;
    GroupConsultTransfer: TGroupBox;
    BtnConsultTransfer: TButton;
    ComboConsultLineB: TComboBox;
    ComboConsultLineA: TComboBox;
    GroupPhoneLog: TGroupBox;
    ListStatusLog: TListBox;
    BtnClearPhoneLog: TButton;
    GroupLineStatus: TGroupBox;
    GroupSoundSetting: TGroupBox;
    CheckAllowListenConf: TCheckBox;
    CheckAllowSpeakConf: TCheckBox;
    GroupVolume: TGroupBox;
    LabelSpeaker: TLabel;
    CheckSpkMute: TCheckBox;
    TrackBarSpkVol: TTrackBar;
    SpkProgBar: TProgressBar;
    LabelMic: TLabel;
    CheckMuteMic: TCheckBox;
    TrackBarMicVol: TTrackBar;
    MicProgBar: TProgressBar;
    TimerTick: TTimer;
    ListLines: TListBox;
    GroupBox12: TGroupBox;
    CheckMuteLineSPK: TCheckBox;
    CheckMuteLineMIC: TCheckBox;
    CheckRightSpkListen: TCheckBox;
    CheckLeftSpkListen: TCheckBox;
    ComboAcceptCallSecureMediaSRTP: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    ComboDialCallSecureMediaSRTP: TComboBox;
    CheckDisturb: TCheckBox;
    GroupVoiceChanger: TGroupBox;
    ComboVoiceChanger: TComboBox;
    BtnStartRecording: TButton;
    GroupBox1: TGroupBox;
    CheckAudioVAD: TCheckBox;

    constructor Create(objTabSheetPhone: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM; objMainForm: TObject);overload;
    procedure FormCreate(Sender: TObject);

    procedure OnVaxOnline();
    Procedure OnVaxOffline();

    procedure BtnDial1Click(Sender: TObject);
    procedure BtnDial2Click(Sender: TObject);
    procedure BtnDial3Click(Sender: TObject);
    procedure BtnDial4Click(Sender: TObject);
    procedure BtnDial5Click(Sender: TObject);
    procedure BtnDial6Click(Sender: TObject);
    procedure BtnDial7Click(Sender: TObject);
    procedure BtnDial8Click(Sender: TObject);
    procedure BtnDial9Click(Sender: TObject);
    procedure BtnDialStarClick(Sender: TObject);
    procedure BtnDial0Click(Sender: TObject);
    procedure BtnDialNoClick(Sender: TObject);

    procedure CheckPlayDialToneClick(Sender: TObject);
    procedure BtnDialClick(Sender: TObject);
    procedure AddToStatusLog(sLogText: String);
    procedure BtnHoldClick(Sender: TObject);

    procedure BtnResetRecordingBufferClick(Sender: TObject);
    procedure BtnSetPlayFileClick(Sender: TObject);
    procedure BtnPlayRewindClick(Sender: TObject);
    procedure BtnPlayForwardClick(Sender: TObject);
    procedure BtnStartPlayClick(Sender: TObject);
    procedure BtnPlayPauseClick(Sender: TObject);
    procedure BtnPlayStopClick(Sender: TObject);
    procedure TimerTickTimer(Sender: TObject);

    procedure CheckPlayRingToneClick(Sender: TObject);
    procedure OnDigitDTMF(nLineNo: Integer; const sDigit: String);
    procedure OnPlayWaveDone(nLineNo: Integer);

    procedure OnConnectedCall(nLineNo: Integer);
    procedure OnDialCallStarted(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
    procedure OnDialingCall(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
    procedure OnDialCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
    procedure OnHungupCall(nLineNo: Integer);

    //////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////

    procedure OnSuccessToHold(nLineNo: Integer);
    procedure OnTryingToHold(nLineNo: Integer);
    procedure OnFailToHold(nLineNo: Integer);

    procedure OnSuccessToUnHold(nLineNo: Integer);
    procedure OnTryingToUnHold(nLineNo: Integer);
    procedure OnFailToUnHold(nLineNo: Integer);

  //////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////

    procedure OnIncomingCallStarted(sCallId: String; sCallerName: String; sCallerId: String);
    procedure OnIncomingCallEnded(const sCallId: String);

    procedure OnRingToneStarted(const sCallId: String);
    procedure OnRingToneEnded(const sCallId: String);

    procedure OnTransferCallAccepted(nLineNo: Integer);
    procedure OnTransferCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
    procedure OnDetectAMD(nLineNo: Integer; bIsHuman: Boolean);

    procedure OnAudioDeviceMicVU(nLevelVU: Integer);
    procedure OnAudioDeviceSpkVU(nLevelVU: Integer);

    procedure BtnAcceptClick(Sender: TObject);
    procedure BtnRejectClick(Sender: TObject);

    procedure BtnTransferCallClick(Sender: TObject);
    procedure BtnConsultTransferClick(Sender: TObject);

    procedure CheckAllowListenConfClick(Sender: TObject);
    procedure CheckAllowSpeakConfClick(Sender: TObject);

    procedure CheckSpkMuteClick(Sender: TObject);
    procedure CheckMuteMicClick(Sender: TObject);

    procedure TrackBarMicVolChange(Sender: TObject);
    procedure TrackBarSpkVolChange(Sender: TObject);

    procedure CheckForwardCallClick(Sender: TObject);
    procedure ListLinesClick(Sender: TObject);

    procedure CheckMuteLineSPKClick(Sender: TObject);
    procedure CheckMuteLineMICClick(Sender: TObject);

    procedure CheckLeftSpkListenClick(Sender: TObject);
    procedure CheckRightSpkListenClick(Sender: TObject);

    procedure BtnClearPhoneLogClick(Sender: TObject);

    procedure OkAlert();
    procedure CancelAlert();

    procedure CheckDetectAMDClick(Sender: TObject);
    procedure ComboVoiceChangerClick(Sender: TObject);
    procedure CheckDisturbClick(Sender: TObject);

    procedure UpdateBtnStatus();
    procedure BtnStartRecordingClick(Sender: TObject);
    procedure CheckAudioVADClick(Sender: TObject);

public

    m_objVaxCOM: TVaxSIPUserAgentExCOM;
    m_objFormAlert: TFormAlert;
    m_objPhoneTone: TPhoneTone;

    function FindCallId(sCallId: String): Boolean;   // Incoming call
    function GetCallerId(sDisplayName, sUserName: String): String; // Incoming call

    procedure FillListLines();
    function FindLine(): Integer;

    procedure ShowListBoxLineStatus(nLineNo: Integer; sStatus: String);
    procedure AdjustSecureMediaSRTP(bDialCall: Boolean);

    function SpkListenChannel(bListenLeft: Boolean; bListenRight: Boolean): Integer;
    procedure ConfAllowLine(nLineNo: Integer; bAllowListen: Boolean; bAllowSpeak: Boolean);

    const PHONE_TAB_PAGE_INDEX: Integer = 1;

  end;

implementation

{$R *.dfm}
uses
MainForm,
PhoneIncomingCall;

var
m_objMainForm: TMainForm;
m_objPhoneIncomingCall: TPhoneIncomingCall;
m_aLineVoice: array of TLineVoice;

constructor TMainPhoneForm.Create(objTabSheetPhone: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM; objMainForm: TObject);
begin

  inherited Create(objTabSheetPhone);

  m_objVaxCOM := objVaxCOM;
  m_objMainForm := TMainForm(objMainForm);

  m_objPhoneIncomingCall := TPhoneIncomingCall.Create();
  m_objPhoneIncomingCall.m_objVaxCOM := m_objVaxCOM;
  m_objPhoneIncomingCall.m_objMainForm := m_objMainForm;

  m_objPhoneTone := TPhoneTone.Create(m_objVaxCOM);

  m_objPhoneIncomingCall.SetListIncomingCall(ListIncomingCall);

  ComboDialCallSecureMediaSRTP.Items.Add('Secure Media None');
  ComboDialCallSecureMediaSRTP.Items.Add('Secure Media Forced');
  ComboDialCallSecureMediaSRTP.ItemIndex := 0;

  ComboAcceptCallSecureMediaSRTP.Items.Add('Secure Media Auto');
  ComboAcceptCallSecureMediaSRTP.Items.Add('Secure Media None');
  ComboAcceptCallSecureMediaSRTP.Items.Add('Secure Media Forced');
  ComboAcceptCallSecureMediaSRTP.ItemIndex := 0;

  ComboVoiceChanger.Items.Add('Disable');
  ComboVoiceChanger.Items.Add('Grandpa drunk');
  ComboVoiceChanger.Items.Add('Teen boy');
  ComboVoiceChanger.Items.Add('Household robot');
  ComboVoiceChanger.Items.Add('Helium inhaled');
  ComboVoiceChanger.Items.Add('Chipmunk');
  ComboVoiceChanger.ItemIndex := 0;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.FormCreate(Sender: TObject);
var
  sPhoneNo: String;
begin
  TStorePhoneNo.GetPhoneNo(sPhoneNo);
  EditPhoneNo.Text := sPhoneNo;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnVaxOnline();
var
  nTotalLine: Integer;
  nCount: Integer;
begin

  nTotalLine := m_objVaxCOM.GetTotalLine();
  SetLength(m_aLineVoice, nTotalLine);

  for nCount := 0 to (nTotalLine - 1) do
  begin
    m_aLineVoice[nCount] := TLineVoice.Create;
  end;

  ComboConsultLineA.Clear();
  ComboConsultLineB.Clear();

  EditForwardCallPhoneNo.Text := ' ';
  CheckForwardCall.Checked := False;
  EditForwardCallPhoneNo.Text := '';

  m_objPhoneTone.OnVaxOnline(CheckPlayRingTone.Checked, CheckPlayDialTone.Checked);

  for nCount := 0 to (nTotalLine - 1) do
  begin
    ComboConsultLineA.Items.Add('Line-' + IntToStr(nCount + 1));
    ComboConsultLineB.Items.Add('Line-' + IntToStr(nCount + 1));
  end;

  FillListLines();

  ComboConsultLineA.ItemIndex := 0;
  ComboConsultLineB.ItemIndex := 1;

  CheckLeftSpkListen.Checked := True;
  CheckRightSpkListen.Checked := True;

  CheckAllowListenConf.Checked := True;
  CheckAllowSpeakConf.Checked := True;

  CheckMuteLineSPK.Checked := False;
  CheckMuteLineMIC.Checked := False;

  CheckAudioVAD.Checked := False;
  TimerTick.Enabled := True;

  m_objVaxCOM.AudioDeviceVU(True, True, True);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

Procedure TMainPhoneForm.OnVaxOffline();
begin

  TimerTick.Enabled := false;

  SpkProgBar.Position := 100;
  MicProgBar.Position := 10;

  ListLines.Items.Clear();
  ListStatusLog.Items.Clear();

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.FillListLines();
var
  nLineNo: Integer;
  nTotalLine: Integer;
begin

  ListLines.Items.Clear();

  nTotalLine := m_objVaxCOM.GetTotalLine;

  for nLineNo := 0 to (nTotalLine - 1) do
  begin
    ListLines.Items.Add('Line-' + IntToStr(nLineNo+1) + ': FREE');
  end;

  ListLines.ItemIndex := 0;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnDialClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  if BtnDial.Caption = 'Hangup' Then
  begin

    nLineNo := ListLines.ItemIndex;
    m_objVaxCOM.DisconnectCall(nLineNo);

    BtnDial.Caption := 'Dial';
    BtnHold.Caption := 'Hold';

    Exit();

  end;

  If EditPhoneNo.Text = '' Then
  begin
    Application.MessageBox('Please enter a phone number.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit();
  end;

  nLineNo := FindLine();

  if nLineNo = -1 Then
  begin
    Application.MessageBox('No line is free.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit();
  end;

  AdjustSecureMediaSRTP(True);
  TStorePhoneNo.AddPhoneNo(EditPhoneNo.Text);

  If m_objVaxCOM.DialCall(nLineNo, '', '', EditPhoneNo.Text) = False Then
  begin
    Exit();
  end;

  BtnDial.Caption := 'Hangup';

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnAcceptClick(Sender: TObject);
var
  nLineNo: Integer;
  nSelectedIndex: Integer;
begin

  nSelectedIndex := ListIncomingCall.ItemIndex;
  if nSelectedIndex = -1 Then
    Exit();

  nLineNo := FindLine();

  if nLineNo = -1 Then
  begin
    Application.MessageBox('No line is free.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit();
  end;

  AdjustSecureMediaSRTP(False);

  if not m_objPhoneIncomingCall.AcceptCall(nLineNo) Then
    Exit();

  ListLines.Items.Strings[nLineNo] := 'Line-' + IntToStr(nLineNo+1) + ': CONNECTING';

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnRejectClick(Sender: TObject);
begin
  m_objPhoneIncomingCall.RejectCall();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnClearPhoneLogClick(Sender: TObject);
begin
  ListStatusLog.Items.Clear();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnConsultTransferClick(Sender: TObject);
begin
  If ComboConsultLineA.ItemIndex = ComboConsultLineB.ItemIndex Then
  begin
    application.MessageBox('Please select two different lines.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit();
  end;

  m_objVaxCOM.TransferCallConsult(ComboConsultLineA.ItemIndex, ComboConsultLineB.ItemIndex);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.AddToStatusLog(sLogText: String);
begin
  ListStatusLog.Items.Add(sLogText);
  ListStatusLog.TopIndex := ListStatusLog.Count - 1;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnHoldClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if BtnHold.Caption = 'UnHold' Then
  begin

    m_objVaxCOM.UnHoldLine(nLineNo);
    BtnHold.Caption := 'Hold';

    Exit();

  end;

  if(m_objVaxCOM.HoldLine(nLineNo) = False) Then
    Exit();

  BtnHold.Caption := 'UnHold';

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnSetPlayFileClick(Sender: TObject);
begin
  m_objVaxCOM.PlayWaveOpen(ListLines.ItemIndex, EditPlayFileName.Text);
end;

procedure TMainPhoneForm.BtnPlayForwardClick(Sender: TObject);
begin
  m_objVaxCOM.PlayWaveSkipTo(ListLines.ItemIndex, m_objVaxCOM.PlayWavePosition(ListLines.ItemIndex) + 1000);
end;

procedure TMainPhoneForm.BtnPlayPauseClick(Sender: TObject);
begin
  m_objVaxCOM.PlayWavePause(ListLines.ItemIndex);
end;

procedure TMainPhoneForm.BtnPlayRewindClick(Sender: TObject);
begin
  m_objVaxCOM.PlayWaveSkipTo(ListLines.ItemIndex, m_objVaxCOM.PlayWavePosition(ListLines.ItemIndex) - 1000)
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnStartPlayClick(Sender: TObject);
begin
  m_objVaxCOM.PlayWaveStart(ListLines.ItemIndex, CheckPlayListen.Checked);
end;

procedure TMainPhoneForm.BtnPlayStopClick(Sender: TObject);
begin
  m_objVaxCOM.PlayWaveStop(ListLines.ItemIndex);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnResetRecordingBufferClick(Sender: TObject);
begin
  m_objVaxCOM.ResetRecording(ListLines.ItemIndex);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnTransferCallClick(Sender: TObject);
begin
  m_objVaxCOM.TransferCallBlind(ListLines.ItemIndex, EditTransferPhoneNo.Text);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckAllowListenConfClick(Sender: TObject);
var
  nLineNo: Integer;
begin
  nLineNo := ListLines.ItemIndex;
  ConfAllowLine(nLineNo, CheckAllowListenConf.Checked, CheckAllowSpeakConf.Checked);
end;

procedure TMainPhoneForm.CheckAllowSpeakConfClick(Sender: TObject);
var
  nLineNo: Integer;
begin
  nLineNo := ListLines.ItemIndex;
  ConfAllowLine(nLineNo, CheckAllowListenConf.Checked, CheckAllowSpeakConf.Checked);
end;

procedure TMainPhoneForm.ConfAllowLine(nLineNo: Integer; bAllowListen: Boolean; bAllowSpeak: Boolean);
begin

  if m_objVaxCOM.ConfAllowLine(nLineNo, bAllowListen, bAllowSpeak) = False Then
    Exit();

  m_aLineVoice[nLineNo].m_bAllowListenConf := bAllowListen;
  m_aLineVoice[nLineNo].m_bAllowSpeakConf := bAllowSpeak;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckAudioVADClick(Sender: TObject);
var
  nLineNo: Integer;
  bEnable: Boolean;
begin

  nLineNo := ListLines.ItemIndex;
  bEnable := CheckAudioVAD.Checked;

  if nLineNo = -1 then
    Exit();

  if m_objVaxCOM.AudioVAD(nLineNo, CheckAudioVAD.Checked) = False Then
    Exit();

  m_aLineVoice[nLineNo].m_bAudioVAD := bEnable;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckDetectAMDClick(Sender: TObject);
begin
  m_objVaxCOM.DetectAMD(CheckDetectAMD.Checked);
end;

procedure TMainPhoneForm.CheckDisturbClick(Sender: TObject);
begin
  m_objVaxCOM.DonotDisturb(CheckDisturb.Checked);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckSpkMuteClick(Sender: TObject);
begin
  m_objVaxCOM.MuteSpk(CheckSpkMute.Checked);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnStartRecordingClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo :=  ListLines.ItemIndex;

  if BtnStartRecording.Caption = 'Start' Then
  begin

    If EditRecordFileName.Text = '' Then
    begin
      Application.MessageBox('File name is not valid.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
      Exit();
    end;

    m_objVaxCOM.StartRecording(nLineNo, EditRecordFileName.Text, 2, 0);
    BtnStartRecording.Caption := 'Stop'

  end
  else
  begin
    m_objVaxCOM.StopRecording(nLineNo);
    BtnStartRecording.Caption := 'Sart'
  end;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckForwardCallClick(Sender: TObject);
begin

  if CheckForwardCall.Checked = True Then
  begin
    If EditForwardCallPhoneNo.Text = '' Then
    begin
      CheckForwardCall.Checked := False;
      Application.MessageBox('Please enter a phone number.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
      Exit();
    end;
  end;

  If m_objVaxCOM.ForwardCall(CheckForwardCall.Checked, EditForwardCallPhoneNo.Text) = False Then
    CheckForwardCall.Checked := False;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.AdjustSecureMediaSRTP(bDialCall: Boolean);
var
  nSecureIndex: Integer;
begin

  nSecureIndex := -1;

  if (bDialCall) Then
  begin

    nSecureIndex := ComboDialCallSecureMediaSRTP.ItemIndex;

    if ((nSecureIndex = -1) or (nSecureIndex = 0)) Then
    begin
      m_objVaxCOM.CryptoMediaNONE(False);
      Exit();
    end;

    if (nSecureIndex = 1) Then
    begin
      m_objVaxCOM.CryptoMediaNONE(True);
      Exit();
    end;

    if (nSecureIndex = 2) Then
    begin
      m_objVaxCOM.CryptoMediaSDP(True);
      Exit();
    end;

  end;

  nSecureIndex := ComboAcceptCallSecureMediaSRTP.ItemIndex;

  if ((nSecureIndex = -1) or (nSecureIndex = 0)) Then
    begin
      m_objVaxCOM.CryptoMediaNONE(False);
      Exit();
    end;

    if (nSecureIndex = 1) Then
    begin
      m_objVaxCOM.CryptoMediaNONE(True);
      Exit();
    end;

    if (nSecureIndex = 2) Then
    begin
      m_objVaxCOM.CryptoMediaSDP(True);
      Exit();
    end;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckMuteLineMICClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if m_objVaxCOM.MuteLineMIC(nLineNo, CheckMuteLineMIC.Checked) = False Then
    Exit();

  m_aLineVoice[nLineNo].m_bMuteLineMIC := CheckMuteLineMIC.Checked;

end;

procedure TMainPhoneForm.CheckMuteLineSPKClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if m_objVaxCOM.MuteLineSPK(nLineNo, CheckMuteLineSPK.Checked) = False Then
    Exit();

  m_aLineVoice[nLineNo].m_bMuteLineSPK := CheckMuteLineSPK.Checked;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckMuteMicClick(Sender: TObject);
begin
  m_objVaxCOM.MuteMic(CheckMuteMic.Checked);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckPlayDialToneClick(Sender: TObject);
begin
  m_objPhoneTone.ActivateDialTone(CheckPlayDialTone.Checked);
end;

procedure TMainPhoneForm.CheckPlayRingToneClick(Sender: TObject);
begin
  m_objPhoneTone.ActivateRingTone(CheckPlayRingTone.Checked);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.CheckRightSpkListenClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if (CheckLeftSpkListen.Checked = False) and (CheckRightSpkListen.Checked = False) Then
    CheckLeftSpkListen.Checked := True;

  if m_objVaxCOM.LineVoiceChannelSPK(nLineNo, SpkListenChannel(CheckLeftSpkListen.Checked, CheckRightSpkListen.Checked)) = False Then
    Exit();

  m_aLineVoice[nLineNo].m_bListenLeftSpk := CheckLeftSpkListen.Checked;

end;

procedure TMainPhoneForm.CheckLeftSpkListenClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if(CheckLeftSpkListen.Checked = False) and (CheckRightSpkListen.Checked = False) Then
    CheckRightSpkListen.Checked := True;

  if m_objVaxCOM.LineVoiceChannelSPK(nLineNo, SpkListenChannel(CheckLeftSpkListen.Checked, CheckRightSpkListen.Checked)) = False Then
    Exit();

  m_aLineVoice[nLineNo].m_bListenLeftSpk := CheckLeftSpkListen.Checked;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.UpdateBtnStatus();
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if (m_objVaxCOM.IsLineRecording(nLineNo) = False) And (BtnStartRecording.Caption <> 'Start') Then
    BtnStartRecording.Caption := 'Start'

  else if (m_objVaxCOM.IsLineRecording(nLineNo) = True) And (BtnStartRecording.Caption <> 'Stop') Then
    BtnStartRecording.Caption := 'Stop';


  if (m_objVaxCOM.IsLineBusy(nLineNo) = False) And (BtnDial.Caption <> 'Dial') Then
    BtnDial.Caption := 'Dial'

  else if (m_objVaxCOM.IsLineBusy(nLineNo) = True) And (BtnDial.Caption <> 'Hangup') Then
    BtnDial.Caption := 'Hangup';


  if (m_objVaxCOM.IsLineHold(nLineNo) = False) And (BtnHold.Caption <> 'Hold') Then
    BtnHold.Caption := 'Hold'

  else if (m_objVaxCOM.IsLineHold(nLineNo) = True) And (BtnHold.Caption <> 'UnHold') Then
    BtnHold.Caption := 'UnHold';

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.ComboVoiceChangerClick(Sender: TObject);
var
  nVoiceChangerType: Integer;
begin

  nVoiceChangerType := ComboVoiceChanger.ItemIndex;
  if(nVoiceChangerType = -1) Then Exit();

  if nVoiceChangerType = 0 Then
    m_objVaxCOM.VoiceChanger(-1)

  else if nVoiceChangerType = 1 Then
    m_objVaxCOM.VoiceChanger(4)

  else if nVoiceChangerType = 2 Then
    m_objVaxCOM.VoiceChanger(8)

  else if nVoiceChangerType = 3 Then
    m_objVaxCOM.VoiceChanger(12)

  else if nVoiceChangerType = 4 Then
    m_objVaxCOM.VoiceChanger(16)

  else if nVoiceChangerType = 5 Then
    m_objVaxCOM.VoiceChanger(20);

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function TMainPhoneForm.SpkListenChannel(bListenLeft: Boolean; bListenRight: Boolean): Integer;
begin

  if (bListenLeft = True) and (bListenRight = False) Then
  begin
    Result := 0;
    Exit();
  end;

  if (bListenLeft = False) and (bListenRight = True) Then
  begin
    Result := 1;
    Exit();
  end;

  Result := 2;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function TMainPhoneForm.FindLine(): Integer;
var
  nLineNo: Integer;
  nTotalLine: Integer;
begin

  nLineNo := ListLines.ItemIndex;
  nTotalLine := m_objVaxCOM.GetTotalLine();

  if m_objVaxCOM.IsLineBusy(nLineNo) = False Then
  begin
    Result := nLineNo;
    Exit();
  end;

  for nLineNo := 0 to (nTotalLine - 1) do
  begin
    if m_objVaxCOM.IsLineBusy(nLineNo) = False Then
    begin
      Result := nLineNo;
      Exit();
    end;
  end;

  Result := -1;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.ListLinesClick(Sender: TObject);
var
  nLineNo: Integer;
begin

  nLineNo := ListLines.ItemIndex;

  if nLineNo = -1 Then
  begin
    Exit();
  end;

  CheckMuteLineMIC.Checked := m_aLineVoice[nLineNo].m_bMuteLineMIC;
  CheckMuteLineSPK.Checked := m_aLineVoice[nLineNo].m_bMuteLineSPK;

  CheckAllowListenConf.Checked := m_aLineVoice[nLineNo].m_bAllowListenConf;
  CheckAllowSpeakConf.Checked := m_aLineVoice[nLineNo].m_bAllowSpeakConf;

  CheckLeftSpkListen.Checked := m_aLineVoice[nLineNo].m_bListenLeftSpk;
  CheckRightSpkListen.Checked := m_aLineVoice[nLineNo].m_bListenRightSpk;

  CheckAudioVAD.Checked := m_aLineVoice[nLineNo].m_bAudioVAD;

  UpdateBtnStatus();

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.BtnDial1Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '1';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '1');
end;

procedure TMainPhoneForm.BtnDial2Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '2';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '2');
end;

procedure TMainPhoneForm.BtnDial3Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '3';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '3');
end;

procedure TMainPhoneForm.BtnDial4Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '4';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '4');
end;

procedure TMainPhoneForm.BtnDial5Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '5';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '5');
end;

procedure TMainPhoneForm.BtnDial6Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '6';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '6');
end;

procedure TMainPhoneForm.BtnDial7Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '7';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '7');
end;

procedure TMainPhoneForm.BtnDial8Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '8';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '8');
end;

procedure TMainPhoneForm.BtnDial9Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '9';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '9');
end;

procedure TMainPhoneForm.BtnDial0Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '0';
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '0');
end;

procedure TMainPhoneForm.BtnDialNoClick(Sender: TObject);
begin
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '#');
end;

procedure TMainPhoneForm.BtnDialStarClick(Sender: TObject);
begin
  m_objVaxCOM.DigitDTMF(ListLines.ItemIndex, '*');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.ShowListBoxLineStatus(nLineNo: Integer; sStatus: String);
begin
  ListLines.Items.Strings[nLineNo] := 'Line-' + IntToStr(nLineNo+1) + ': ' + sStatus;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.TimerTickTimer(Sender: TObject);
var
  nLineNo: Integer;
  nTotalLine: Integer;
  sItemText: String;
begin

  UpdateBtnStatus();

  nTotalLine := m_objVaxCOM.GetTotalLine();

  for nLineNo := 0 to (nTotalLine - 1) do
  begin
    sItemText := ListLines.Items.Strings[nLineNo];

    if m_objVaxCOM.IsLineBusy(nLineNo) = True Then
    begin

      if m_objVaxCOM.IsLinePlaying(nLineNo) = True Then
      begin
        if Pos('PLAYING', sItemText) = 0 Then
          ShowListBoxLineStatus(nLineNo, 'PLAYING');
      end
      else
      begin
      if m_objVaxCOM.IsLineHold(nLineNo) = True  Then
        begin
          if Pos('HOLD', sItemText) = 0 Then
            ShowListBoxLineStatus(nLineNo, 'HOLD');
        end
        else
        begin
          if (Pos('BUSY', sItemText) = 0) and (Pos('CONNECTING', sItemText) = 0) Then
            ShowListBoxLineStatus(nLineNo, 'BUSY');
        end;
      end;

    end
    else
    begin
      if Pos('FREE', sItemText) = 0 Then
        ShowListBoxLineStatus(nLineNo, 'FREE');
    end;
  end;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.TrackBarSpkVolChange(Sender: TObject);
begin
   // Value range (-100) --- 0 --- (+100)
   m_objVaxCOM.SetVolumeSpk(TrackBarSpkVol.Position - 100);
end;

procedure TMainPhoneForm.TrackBarMicVolChange(Sender: TObject);
begin
  // Value range (-100) --- 0 --- (+100)
  m_objVaxCOM.SetVolumeMic(TrackBarMicVol.Position - 100);
end;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnDigitDTMF(nLineNo: Integer; const sDigit: String);
begin
 AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Key-pressed: ' + sDigit);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnPlayWaveDone(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Play wave done.');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnConnectedCall(nLineNo: Integer);
begin

  ShowListBoxLineStatus(nLineNo,'BUSY');
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Success to connect.');

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

Function TMainPhoneForm.FindCallId(sCallId: String): Boolean;
var
  nListIndex: Integer;
  sResult: String;
  objListData: TListData;
begin

  for nListIndex := 0 to ListIncomingCall.Items.Count - 1 do
  begin
    objListData := TListData(ListIncomingCall.Items.Objects[nListIndex]);
    sResult := objListData.m_sData;

    if sResult = sCallId Then
    begin
      Result := True;
      Exit();
    end;

  end;

  Result := False;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

Function TMainPhoneForm.GetCallerId(sDisplayName, sUserName: String): String;
begin

  if Length(sDisplayName) <> 0 Then
    Result := sDisplayName
  else
    Result := sUserName;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnIncomingCallStarted(sCallId: String; sCallerName: String; sCallerId: String);
begin
  m_objPhoneIncomingCall.OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
end;

procedure TMainPhoneForm.OnIncomingCallEnded(const sCallId: String);
begin
  m_objPhoneIncomingCall.OnIncomingCallEnded(sCallId);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnRingToneStarted(const sCallId: String);
begin
  m_objPhoneTone.OnRingToneStarted(sCallId);
end;

procedure TMainPhoneForm.OnRingToneEnded(const sCallId: String);
begin
  m_objPhoneTone.OnRingToneEnded(sCallId);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

Procedure  TMainPhoneForm.OkAlert();
begin
  m_objMainForm.SetActiveTab(PHONE_TAB_PAGE_INDEX);
end;

procedure TMainPhoneForm.CancelAlert;
begin
  //
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnTransferCallAccepted(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Transfer accepted.');
end;

procedure TMainPhoneForm.OnTransferCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToStatusLog('Fail to Transfer:' + sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnDialCallStarted(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
begin
  ShowListBoxLineStatus(nLineNo, 'CONNECTING');
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Dialing.');
end;

procedure TMainPhoneForm.OnDialingCall(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Response: ' + sReasonPhrase);
end;

procedure TMainPhoneForm.OnDialCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Response: ' + sReasonPhrase);
end;

procedure TMainPhoneForm.OnHungupCall(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Hung up.');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnSuccessToHold(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Hold success.');
end;

procedure TMainPhoneForm.OnTryingToHold(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Hold trying.');
end;

procedure TMainPhoneForm.OnFailToHold(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Hold failed.');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnSuccessToUnHold(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Unhold success.');
end;

procedure TMainPhoneForm.OnTryingToUnHold(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Unhold trying.');
end;

procedure TMainPhoneForm.OnFailToUnHold(nLineNo: Integer);
begin
  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Unhold failed.');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnDetectAMD(nLineNo: Integer; bIsHuman: Boolean);
begin

  if (bIsHuman = False) Then
  begin
    AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Answering Machine [Yes]');
    Exit();
  end;

  AddToStatusLog('Line-' + IntToStr(nLineNo + 1) + ': Answering Machine [No]');

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainPhoneForm.OnAudioDeviceMicVU(nLevelVU: Integer);
begin
  MicProgBar.Position := nLevelVU;
end;

procedure TMainPhoneForm.OnAudioDeviceSpkVU(nLevelVU: Integer);
begin
  SpkProgBar.Position := nLevelVU;
end;

end.
