unit Alert;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TFormAlert = class(TForm)
    BtnOk: TButton;
    BtnCancel: TButton;
    LabelAlert: TLabel;

    Constructor Create(objFormPhone : TForm);overload;
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);

    procedure OnRingToneStarted(sCallId: String; objFormPhone : TForm);
    procedure OnRingToneEnded(sCallId: String);

    procedure CloseClass();

  end;

implementation

uses
MainPhoneForm;
{$R *.dfm}

var
  m_objFormPhone : TMainPhoneForm;

procedure TFormAlert.BtnCancelClick(Sender: TObject);
begin
   //m_objFormPhone.CancelAlert();
   CloseClass();
end;

procedure TFormAlert.BtnOkClick(Sender: TObject);
begin
    m_objFormPhone.OkAlert();
    CloseClass();
end;

Constructor TFormAlert.Create(objFormPhone : TForm);
begin
  m_objFormPhone := TMainPhoneForm(objFormPhone);
  inherited Create(nil);

end;

procedure TFormAlert.OnRingToneStarted(sCallId: String; objFormPhone : TForm);
{var
  nTabIndex : Integer;}
begin

  {nTabIndex := m_objFormMain.GetActiveTab;

  if nTabIndex <> PHONE_TAB_PAGE_INDEX then
  begin
    if self = nil Then
    begin
      self.Create(objFormPhone);
      self.ShowModal;
    end;
  end;}

end;

procedure TFormAlert.OnRingToneEnded(sCallId: String);
begin
  CloseClass();
end;

procedure TFormAlert.CloseClass();
begin

if self <> nil then
  begin
    self.Close;
    self.Release;
    self := nil;
  end;

end;

end.
