unit MainAccountRecForm;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
  StoreAccountREC,
  VaxSIPUserAgentExCOM;

type

  TMainAccountRecForm = class(TForm)

  GroupAccountLog: TGroupBox;
  ListBoxStatusLog: TListBox;
  BtnClearStatusLog: TButton;

  GroupCallLog: TGroupBox;
  ListBoxCallLog: TListBox;
  BtnClearCallLog: TButton;
  GroupAccount: TGroupBox;

  LabelUserName: TLabel;
  LabelDisplayName: TLabel;
  LabelDomainRealm: TLabel;

  LabelAuthPwd: TLabel;
  LabelAuthLogin: TLabel;
  LabelServerAddr: TLabel;
  LabelServerPort: TLabel;

  EditUserName: TEdit;
  EditDisplayName: TEdit;
  EditDomainRealm: TEdit;

  EditAuthPwd: TEdit;
  BtnOnline: TButton;
  EditAuthLogin: TEdit;
  CheckRegisterToServerREC: TCheckBox;

  EditServerAddr: TEdit;
  EditServerPort: TEdit;
  BtnAdvance: TButton;

  procedure FormCreate(Sender: TObject);
  procedure BtnClearCallLogClick(Sender: TObject);
  procedure BtnOnlineClick(Sender: TObject);
  procedure BtnClearStatusLogClick(Sender: TObject);
  procedure BtnAdvanceClick(Sender: TObject);

  private
  procedure LoadAccountData();
  procedure AddToStatusLog(sStatus: String);
  procedure AddToCallLog(sStatus: String);

  public
  constructor Create(objTabSheetAccount: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);overload;

  public
  procedure OnConnectingToRegister();
  procedure OnTryingToRegister();
  procedure OnSuccessToRegister();
  procedure OnFailToRegister(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnConnectingToReRegister();
  procedure OnTryingToReRegister();
  procedure OnSuccessToReRegister();
  procedure OnFailToReRegister(nStatusCode: Integer; sReasonPhrase: String);

  procedure OnTryingToUnRegister();
  procedure OnFailToUnRegister();
  procedure OnSuccessToUnRegister();

  public
  procedure OnDialCallStarted(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
  procedure OnDialingCall(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnDialCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
  procedure OnConnectedCall(nLineNo: Integer);
  procedure OnHungupCall(nLineNo: Integer);

  public
  procedure OnStatusMsg(nLineNo: Integer; nErrorCode: Integer; sErrorMsg: String);

  end;

var
  AccountRecForm: TMainAccountRecForm;
  m_objVaxCOM: TVaxSIPUserAgentExCOM;
  m_bBtnAdvanceShow: Boolean;

implementation

{$R *.dfm}

constructor TMainAccountRecForm.Create(objTabSheetAccount: TTabSheet; objVaxCOM: TVaxSIPUserAgentExCOM);
begin

  inherited Create(objTabSheetAccount);

  m_objVaxCOM := objVaxCOM;
  m_bBtnAdvanceShow := True;

end;

procedure TMainAccountRecForm.FormCreate(Sender: TObject);
begin
  LoadAccountData();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.BtnOnlineClick(Sender: TObject);
var
  bResult: Boolean;
begin

  if BtnOnline.Caption = 'Offline' Then
  begin
    m_objVaxCOM.UnRegisterAccountREC();
    BtnOnline.Caption := 'Online';
    Exit();
  end;

  if EditAuthLogin.Text = '' Then
  begin
    application.MessageBox('Invalid auth Login.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit();
  end;

  if EditServerAddr.Text = '' Then
  begin
    application.MessageBox('Invalid SIP server domain or IP address.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit();
  end;

  TStoreAccountREC.AddAccountInfo(EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, StrToInt(EditServerPort.Text), CheckRegisterToServerREC.Checked);

  bResult := m_objVaxCOM.RegisterAccountREC(CheckRegisterToServerREC.Checked, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDisplayName.Text, EditDomainRealm.Text, EditServerAddr.Text, StrToInt(EditServerPort.Text));

  if bResult = False Then
    Exit();

  if CheckRegisterToServerREC.Checked = True Then
  begin
    AddToStatusLog('Registering to SIP Server REC.');
  end;

  BtnOnline.Caption := 'Offline';

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.BtnClearStatusLogClick(Sender: TObject);
begin
  ListBoxStatusLog.Clear();
end;

procedure TMainAccountRecForm.BtnAdvanceClick(Sender: TObject);
begin

  if (m_bBtnAdvanceShow) then
  begin

    LabelDisplayName.Visible := True;
    LabelUserName.Visible := True;
    LabelDomainRealm.Visible := True;

    EditUserName.Visible := True;
    EditDisplayName.Visible := True;
    EditDomainRealm.Visible := True;

    BtnAdvance.Caption := 'Basic';
    m_bBtnAdvanceShow := False;

    Exit();

  end;

  LabelDisplayName.Visible := False;
  LabelUserName.Visible := False;
  LabelDomainRealm.Visible := False;

  EditUserName.Visible := False;
  EditDisplayName.Visible := False;
  EditDomainRealm.Visible := False;

  BtnAdvance.Caption := 'Advance';
  m_bBtnAdvanceShow := True;

end;

procedure TMainAccountRecForm.BtnClearCallLogClick(Sender: TObject);
begin
  ListBoxCallLog.Clear();
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.AddToStatusLog(sStatus: String);
begin
  ListBoxStatusLog.Items.Add(sStatus);
  ListBoxStatusLog.TopIndex := ListBoxStatusLog.Count - 1;
end;

procedure TMainAccountRecForm.AddToCallLog(sStatus: String);
begin
  ListBoxCallLog.Items.Add(sStatus);
  ListBoxCallLog.TopIndex := ListBoxCallLog.Count - 1;
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.LoadAccountData();
var
  sDisplayName, sUserName, sAuthLogin, sAuthPwd: String;
  sDomainRealm, sServerAddr: String;
  nServerPort: Integer;
  bRegisterSIP: Boolean;
begin

  TStoreAccountREC.GetAccountInfo(sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort, bRegisterSIP);

  EditDisplayName.Text := sDisplayName;
  EditUserName.Text := sUserName;

  EditAuthLogin.Text := sAuthLogin;
  EditAuthPwd.Text := sAuthPwd;

  EditDomainRealm.Text := sDomainRealm;
  EditServerAddr.Text := sServerAddr;
  EditServerPort.Text := IntToStr(nServerPort);

  CheckRegisterToServerREC.Checked := bRegisterSIP;

end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.OnConnectingToRegister();
begin
  AddToStatusLog('Connecting to register.');
end;

procedure TMainAccountRecForm.OnTryingToRegister();
begin
  AddToStatusLog('Trying to Register.');
end;

procedure TMainAccountRecForm.OnSuccessToRegister();
begin
  AddToStatusLog('Success to Register.');
end;

procedure TMainAccountRecForm.OnFailToRegister(nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToStatusLog('Failed: ' + sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.OnConnectingToReRegister();
begin
  AddToStatusLog('Connecting to re-register.');
end;

procedure TMainAccountRecForm.OnTryingToReRegister();
begin
  AddToStatusLog('Trying to Re-Register.');
end;

procedure TMainAccountRecForm.OnSuccessToReRegister();
begin
  AddToStatusLog('Success to Re-Register.');
end;

procedure TMainAccountRecForm.OnFailToReRegister(nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToStatusLog('Failed' + sReasonPhrase);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.OnTryingToUnRegister();
begin
  AddToStatusLog('Trying to Unregister.');
end;

procedure TMainAccountRecForm.OnFailToUnRegister();
begin
  AddToStatusLog('Failed to Unregister.');
end;

procedure TMainAccountRecForm.OnSuccessToUnRegister();
begin
  AddToStatusLog('Unregistered successfully.');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.OnDialCallStarted(nLineNo: Integer; sCallerName: String; sCallerId: String; sDialNo: String);
begin
  AddToCallLog('Line-' + IntToStr(nLineNo + 1) + ': Dialing.');
end;

procedure TMainAccountRecForm.OnDialingCall(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToCallLog('Line-' + IntToStr(nLineNo + 1) + ': Response: ' + sReasonPhrase);
end;

procedure TMainAccountRecForm.OnDialCallFailed(nLineNo: Integer; nStatusCode: Integer; sReasonPhrase: String);
begin
  AddToCallLog('Line-' + IntToStr(nLineNo + 1) + ': Response: ' + sReasonPhrase);
end;

procedure TMainAccountRecForm.OnConnectedCall(nLineNo: Integer);
begin
  AddToCallLog('Line-' + IntToStr(nLineNo + 1) + ': Success to connect.');
end;

procedure TMainAccountRecForm.OnHungupCall(nLineNo: Integer);
begin
  AddToCallLog('Line-' + IntToStr(nLineNo + 1) + ': Hung up.');
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

procedure TMainAccountRecForm.OnStatusMsg(nLineNo: Integer; nErrorCode: Integer; sErrorMsg: String);
begin
  AddToCallLog('Line-' + IntToStr(nLineNo + 1) + ': ' + sErrorMsg);
end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

end.
